/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.XMLPropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.configuration2.io.URLConnectionOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestFileBasedConfigurationBuilder {
    private static final String PROP = "testProperty";
    @TempDir
    public File tempFolder;

    private static void checkSavedConfig(File file, int expValue) throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)config);
        handler.load(file);
        Assertions.assertEquals((int)expValue, (int)config.getInt(PROP));
    }

    private File createTestFile(int value) {
        return (File)Assertions.assertDoesNotThrow(() -> {
            File file = TempDirUtils.newFile(this.tempFolder);
            try (FileWriter out = new FileWriter(file);){
                out.write(String.format("%s=%d", PROP, value));
            }
            return file;
        });
    }

    @Test
    void testAutoSave() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        Assertions.assertFalse((boolean)builder.isAutoSave());
        builder.setAutoSave(true);
        Assertions.assertTrue((boolean)builder.isAutoSave());
        builder.setAutoSave(true);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    void testAutoSaveWithPropertiesConfiguration() throws ConfigurationException, IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.setAutoSave(true);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    void testAutoSaveWithReset() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config1 = (PropertiesConfiguration)builder.getConfiguration();
        builder.setAutoSave(true);
        builder.resetResult();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)config1, (Object)config2);
        config2.setProperty(PROP, (Object)1);
        config1.setProperty(PROP, (Object)2);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    void testChangeLocationAfterCreation() throws ConfigurationException {
        File file1 = this.createTestFile(1);
        File file2 = this.createTestFile(2);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        builder.getConfiguration();
        builder.getFileHandler().setFile(file2);
        builder.resetResult();
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((int)2, (int)config.getInt(PROP));
    }

    @Test
    void testChangeLocationAfterReset() throws ConfigurationException {
        File file1 = this.createTestFile(1);
        File file2 = this.createTestFile(2);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        builder.getConfiguration();
        builder.getFileHandler().setFile(file2);
        builder.reset();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file1)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(PROP));
        builder.getFileHandler().setFile(file2);
        builder.resetResult();
        config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((int)2, (int)config.getInt(PROP));
    }

    @Test
    void testCreateConfigurationNonExistingFileAndThenSave() throws ConfigurationException {
        File outFile = ConfigurationAssert.getOutFile("save.properties");
        Parameters parameters = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true).configure(new BuilderParameters[]{(BuilderParameters)parameters.properties().setFile(outFile)});
        Configuration config = (Configuration)builder.getConfiguration();
        config.setProperty(PROP, (Object)1);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(outFile, 1);
        Assertions.assertTrue((boolean)outFile.delete());
    }

    @Test
    void testDisableAutoSave() throws ConfigurationException {
        File file = this.createTestFile(0);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.setAutoSave(true);
        config.setProperty(PROP, (Object)1);
        builder.setAutoSave(false);
        config.setProperty(PROP, (Object)2);
        builder.setAutoSave(false);
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 1);
    }

    @Test
    void testFileBasedConfigurationBuilderWithHomeDirectoryLocationStrategy() throws IOException, ConfigurationException {
        String folderName = "test";
        String fileName = "sample.properties";
        TempDirUtils.newFolder("test", this.tempFolder);
        TempDirUtils.newFile("test" + File.separator + "sample.properties", this.tempFolder);
        FileBasedConfigurationBuilder homeDirConfigurationBuilder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesBuilderParameters homeDirProperties = new Parameters().properties();
        HomeDirectoryLocationStrategy strategy = new HomeDirectoryLocationStrategy(this.tempFolder.getAbsolutePath(), true);
        FileBasedConfigurationBuilder builder = homeDirConfigurationBuilder.configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)homeDirProperties.setLocationStrategy((FileLocationStrategy)strategy)).setBasePath("test")).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))).setFileName("sample.properties")});
        Assertions.assertDoesNotThrow(() -> ((FileBasedConfigurationBuilder)builder).getConfiguration());
    }

    @Test
    void testGetConfigurationLoadFromFile() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(PROP));
        Assertions.assertSame((Object)config, (Object)builder.getFileHandler().getContent());
    }

    @Test
    void testGetConfigurationLoadFromJarFile() throws ConfigurationException, IOException {
        URL jarResourceUrl = this.getClass().getClassLoader().getResource("org/apache/commons/configuration2/test.jar");
        Assertions.assertNotNull((Object)jarResourceUrl);
        Path testJar = Paths.get(this.tempFolder.getAbsolutePath(), "test.jar");
        try (InputStream inputStream = jarResourceUrl.openStream();){
            Files.copy(inputStream, testJar, new CopyOption[0]);
        }
        URL url = new URL("jar:" + testJar.toUri() + "!/configuration.properties");
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setURL(url, new URLConnectionOptions().setUseCaches(false))});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((int)1, (int)config.getInt(PROP));
        Assertions.assertSame((Object)config, (Object)builder.getFileHandler().getContent());
    }

    @Test
    void testGetConfigurationNoLocation() throws ConfigurationException {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("throwExceptionOnMissing", Boolean.TRUE);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, params);
        PropertiesConfiguration conf = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)conf.isThrowExceptionOnMissing());
        Assertions.assertTrue((boolean)conf.isEmpty());
    }

    @Test
    void testGetDefaultEncodingInterface() {
        String encoding = "testEncoding";
        FileBasedConfigurationBuilder.setDefaultEncoding(Configuration.class, (String)"testEncoding");
        Assertions.assertEquals((Object)"testEncoding", (Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLConfiguration.class));
        FileBasedConfigurationBuilder.setDefaultEncoding(Configuration.class, null);
        Assertions.assertNull((Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLConfiguration.class));
    }

    @Test
    void testGetDefaultEncodingProperties() {
        Assertions.assertEquals((Object)PropertiesConfiguration.DEFAULT_ENCODING, (Object)FileBasedConfigurationBuilder.getDefaultEncoding(PropertiesConfiguration.class));
    }

    @Test
    void testGetDefaultEncodingSubClass() {
        PropertiesConfiguration conf = new PropertiesConfiguration(){};
        Assertions.assertEquals((Object)PropertiesConfiguration.DEFAULT_ENCODING, (Object)FileBasedConfigurationBuilder.getDefaultEncoding(conf.getClass()));
    }

    @Test
    void testGetDefaultEncodingXmlProperties() {
        Assertions.assertEquals((Object)XMLPropertiesConfiguration.DEFAULT_ENCODING, (Object)FileBasedConfigurationBuilder.getDefaultEncoding(XMLPropertiesConfiguration.class));
    }

    @Test
    void testInitAllowFailOnInitFlag() {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class, null, true);
        Assertions.assertTrue((boolean)builder.isAllowFailOnInit());
    }

    @Test
    void testInitFileHandlerOverrideDefaultEncoding() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        String encoding = "testEncoding";
        handler.setEncoding("testEncoding");
        builder.initFileHandler(handler);
        Assertions.assertEquals((Object)"testEncoding", (Object)handler.getEncoding());
    }

    @Test
    void testInitFileHandlerSetDefaultEncoding() throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        FileHandler handler = new FileHandler();
        builder.initFileHandler(handler);
        Assertions.assertEquals((Object)PropertiesConfiguration.DEFAULT_ENCODING, (Object)handler.getEncoding());
    }

    @Test
    void testLocationIsFullyDefined() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.getConfiguration();
        FileLocator locator = builder.getFileHandler().getFileLocator();
        Assertions.assertTrue((boolean)FileLocatorUtils.isFullyInitialized((FileLocator)locator));
    }

    @Test
    void testLocationSurvivesResetResult() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        builder.resetResult();
        PropertiesConfiguration config2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)config, (Object)config2);
        Assertions.assertEquals((int)1, (int)config2.getInt(PROP));
    }

    @Test
    void testResetLocation() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        builder.getConfiguration();
        builder.reset();
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertTrue((boolean)config.isEmpty());
        Assertions.assertFalse((boolean)builder.getFileHandler().isLocationDefined());
    }

    @Test
    void testSave() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)5);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 5);
    }

    @Test
    void testSaveNewFile() throws ConfigurationException, IOException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        config.setProperty(PROP, (Object)2);
        File file = TempDirUtils.newFile(this.tempFolder);
        builder.getFileHandler().setFile(file);
        builder.save();
        TestFileBasedConfigurationBuilder.checkSavedConfig(file, 2);
    }

    @Test
    void testSetDefaultEncodingNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileBasedConfigurationBuilder.setDefaultEncoding(null, (String)StandardCharsets.UTF_8.name()));
    }

    @Test
    void testSetLocationNoFileHandler() throws ConfigurationException {
        File file = this.createTestFile(1);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class);
        builder.getFileHandler().setFile(file);
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertFalse((boolean)config.isEmpty());
    }
}

