/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeUpdateData;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.TreeData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestInMemoryNodeModel {
    private static final String KEY = "aTestKey";

    private static void checkPathToRoot(InMemoryNodeModel model, ImmutableNode node, String ... path) {
        NodeHandler handler = model.getNodeHandler();
        for (int i = path.length - 1; i >= 0; --i) {
            node = (ImmutableNode)handler.getParent((Object)node);
            Assertions.assertEquals((Object)path[i], (Object)node.getNodeName());
        }
        Assertions.assertSame((Object)model.getRootNode(), (Object)handler.getParent((Object)node));
    }

    private static NodeKeyResolver<ImmutableNode> createResolver() {
        return (NodeKeyResolver)Mockito.mock(NodeKeyResolver.class);
    }

    private void checkAddNodesNoNodes(Collection<ImmutableNode> newNodes) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        model.addNodes(KEY, newNodes, resolver);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    private void checkClearTreeUpdatedParentMapping(String pathToRemove, ImmutableNode nodeToCheck) {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, pathToRemove));
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(result));
        model.clearTree(KEY, resolver);
        NodeHandler nodeHandler = model.getNodeHandler();
        Assertions.assertThrows(IllegalArgumentException.class, () -> nodeHandler.getParent((Object)nodeToCheck));
    }

    @Test
    void testAddNodesEmptyCollection() {
        this.checkAddNodesNoNodes(Collections.emptySet());
    }

    @Test
    void testAddNodesNullCollection() {
        this.checkAddNodesNoNodes(null);
    }

    @Test
    void testAddNodesToAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.author(1)), (String)"test")));
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        Set<ImmutableNode> nodes = Collections.singleton(newNode);
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.addNodes(KEY, (Collection)nodes, resolver));
    }

    @Test
    void testAddNodesToExistingNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String key = NodeStructureHelper.author(0);
        ImmutableNode newWork1 = new ImmutableNode.Builder().name("King Lear").create();
        ImmutableNode newWork2 = new ImmutableNode.Builder().name("The Taming of the Shrew").create();
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, key))));
        model.addNodes(KEY, Arrays.asList(newWork1, newWork2), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, key);
        int size = node.getChildren().size();
        Assertions.assertSame((Object)newWork1, node.getChildren().get(size - 2));
        Assertions.assertSame((Object)newWork2, node.getChildren().get(size - 1));
    }

    @Test
    void testAddNodesToNewAttributeKey() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.emptyList());
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)new NodeAddData((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, "test", true, null));
        ImmutableNode newNode = new ImmutableNode.Builder().name("newNode").create();
        Set<ImmutableNode> nodes = Collections.singleton(newNode);
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.addNodes(KEY, (Collection)nodes, resolver));
    }

    @Test
    void testAddNodesToNewNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String newAuthor = "Goethe";
        String newWork = "Faust";
        String newPersona = "Mephisto";
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(new ArrayList(0));
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)new NodeAddData((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, "Faust", false, Arrays.asList("Goethe")));
        ImmutableNode personaNode = new ImmutableNode.Builder().name("Mephisto").create();
        model.addNodes(KEY, Collections.singleton(personaNode), resolver);
        Assertions.assertSame((Object)personaNode, (Object)NodeStructureHelper.nodeForKey(model, "Goethe/Faust/Mephisto"));
    }

    @Test
    void testAddPropertyAttributeNoPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Shakespeare/The Tempest"), "year", true, null);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        model.addProperty(KEY, Collections.singleton(1611), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Shakespeare/The Tempest");
        Assertions.assertEquals((Object)1611, node.getAttributes().get("year"));
    }

    @Test
    void testAddPropertyAttributeWithPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "number", true, Arrays.asList("scenes", "scene"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        model.addProperty(KEY, Collections.singleton(1), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias/scenes/scene");
        Assertions.assertEquals((Object)1, node.getAttributes().get("number"));
    }

    @Test
    void testAddPropertyAttributeWithSinglePathNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, NodeStructureHelper.author(0)), "year", true, Arrays.asList("dateOfBirth"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        Integer year = 1564;
        model.addProperty(KEY, Collections.singleton(year), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Shakespeare/dateOfBirth");
        Assertions.assertEquals((Object)year, node.getAttributes().get("year"));
    }

    @Test
    void testAddPropertyNoPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer"), "work", false, null);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        model.addProperty(KEY, Collections.singleton("Odyssee"), resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/work");
        Assertions.assertEquals((Object)"Odyssee", (Object)node.getValue());
        Assertions.assertNotNull((Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    void testAddPropertyNoValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        model.addProperty(KEY, Collections.emptySet(), resolver);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    @Test
    void testAddPropertyUpdateParentReferences() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "location", false, Collections.singleton("locations"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        String[] locations = new String[]{"Troja", "Beach", "Olympos"};
        model.addProperty(KEY, Arrays.asList(locations), resolver);
        String[] path = new String[]{"Homer", "Ilias", "locations"};
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("location(1)", path));
        TestInMemoryNodeModel.checkPathToRoot(model, node, path);
    }

    @Test
    void testAddPropertyWithPathNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias"), "location", false, Collections.singleton("locations"));
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        String[] locations = new String[]{"Troja", "Beach", "Olympos"};
        model.addProperty(KEY, Arrays.asList(locations), resolver);
        ImmutableNode nodeLocs = NodeStructureHelper.nodeForKey(model, "Homer/Ilias/locations");
        Assertions.assertEquals((int)locations.length, (int)nodeLocs.getChildren().size());
        int idx = 0;
        for (ImmutableNode c : nodeLocs) {
            Assertions.assertEquals((Object)"location", (Object)c.getNodeName());
            Assertions.assertEquals((Object)locations[idx], (Object)c.getValue());
            Assertions.assertTrue((boolean)c.getChildren().isEmpty());
            Assertions.assertTrue((boolean)c.getAttributes().isEmpty());
            ++idx;
        }
        Assertions.assertNotNull((Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    void testClear() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        model.clear(TestInMemoryNodeModel.createResolver());
        Assertions.assertFalse((boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
        Assertions.assertEquals((Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), (Object)model.getRootNode().getNodeName());
    }

    @Test
    void testClearPropertyAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Prospero/The Tempest/originalValue";
        Mockito.when((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, "Prospero/The Tempest/originalValue"), (String)"tested")));
        model.clearProperty(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Prospero/The Tempest/originalValue");
        Assertions.assertTrue((boolean)node.getAttributes().isEmpty());
    }

    @Test
    void testClearPropertyNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        Mockito.when((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue"))));
        model.clearProperty(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assertions.assertNull((Object)node.getValue());
    }

    @Test
    void testClearPropertyNonExisting() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Mockito.when((Object)resolver.resolveKey((Object)model.getRootNode(), KEY, model.getNodeHandler())).thenReturn(Collections.emptyList());
        TreeData treeDataOld = model.getTreeData();
        model.clearProperty(KEY, resolver);
        Assertions.assertNotNull((Object)model.getNodeHandler().getRootNode());
        Assertions.assertSame((Object)treeDataOld, (Object)model.getTreeData());
    }

    @Test
    void testClearTreeAttribute() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeName = "Puck";
        QueryResult result = QueryResult.createAttributeResult((Object)NodeStructureHelper.nodeForKey(model, "Puck"), (String)"author");
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(result));
        List removed = model.clearTree(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Puck");
        Assertions.assertTrue((boolean)node.getAttributes().isEmpty());
        Assertions.assertEquals((int)1, (int)removed.size());
        Assertions.assertTrue((boolean)removed.contains(result));
    }

    @Test
    void testClearTreeChildrenRemovedFromParentMapping() {
        String path = "Homer/Ilias";
        this.checkClearTreeUpdatedParentMapping("Homer/Ilias", NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias/Achilles"));
    }

    @Test
    void testClearTreeNodeRemovedFromParentMapping() {
        String path = "Homer/Ilias/Achilles";
        this.checkClearTreeUpdatedParentMapping("Homer/Ilias/Achilles", NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias/Achilles"));
    }

    @Test
    void testClearTreeNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Achilles"));
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(result));
        List removed = model.clearTree(KEY, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assertions.assertEquals((int)2, (int)node.getChildren().size());
        for (ImmutableNode c : node) {
            Assertions.assertNotEquals((Object)((ImmutableNode)result.getNode()).getNodeName(), (Object)c.getNodeName());
        }
        Assertions.assertEquals((int)1, (int)removed.size());
        Assertions.assertTrue((boolean)removed.contains(result));
    }

    @Test
    void testClearTreeNodesAndAttributes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeName = "Puck";
        ImmutableNode orgNode = NodeStructureHelper.nodeForKey(model, "Puck");
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(2);
        results.add(QueryResult.createAttributeResult((Object)orgNode, (String)"author"));
        results.add(QueryResult.createNodeResult((Object)((ImmutableNode)orgNode.getChildren().get(0))));
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).thenReturn(results);
        model.clearTree(KEY, resolver);
        Assertions.assertThrows(NoSuchElementException.class, () -> NodeStructureHelper.nodeForKey(model, "Puck"));
    }

    @Test
    void testClearTreeNonExistingKey() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.emptyList());
        TreeData treeDataOld = model.getTreeData();
        Assertions.assertTrue((boolean)model.clearTree(KEY, resolver).isEmpty());
        Assertions.assertNotNull((Object)model.getNodeHandler().getRootNode());
        Assertions.assertSame((Object)treeDataOld, (Object)model.getTreeData());
    }

    @Test
    void testClearTreeRemoveUndefinedNodes() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(node.getChildren().size());
        for (ImmutableNode child : node) {
            results.add(QueryResult.createNodeResult((Object)child));
        }
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(results);
        model.clearTree(KEY, resolver);
        Assertions.assertEquals((int)(NodeStructureHelper.authorsLength() - 1), (int)model.getRootNode().getChildren().size());
        for (ImmutableNode child : model.getRootNode()) {
            Assertions.assertNotEquals((Object)"Homer", (Object)child.getNodeName());
        }
    }

    @Test
    void testClearTreeResultIsEmpty() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        ImmutableNode child = new ImmutableNode.Builder().name("child").value((Object)"test").create();
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(child).create();
        InMemoryNodeModel model = new InMemoryNodeModel(root);
        Mockito.when((Object)resolver.resolveKey((Object)root, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(QueryResult.createNodeResult((Object)child)));
        model.clearTree(KEY, resolver);
        Assertions.assertFalse((boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
    }

    @Test
    void testClearTreeRootNode() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ArrayList<QueryResult> results = new ArrayList<QueryResult>(2);
        results.add(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.author(0))));
        results.add(QueryResult.createNodeResult((Object)NodeStructureHelper.ROOT_AUTHORS_TREE));
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(results);
        model.clearTree(KEY, resolver);
        Assertions.assertFalse((boolean)model.getNodeHandler().isDefined((Object)model.getRootNode()));
    }

    @Test
    void testClearTreeUpdateParentReferences() {
        String[] path = new String[]{"Homer", "Ilias"};
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("Achilles", path)));
        Mockito.when((Object)resolver.resolveKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn(Collections.singletonList(result));
        model.clearTree(KEY, resolver);
        TestInMemoryNodeModel.checkPathToRoot(model, NodeStructureHelper.nodeForKey(model, NodeStructureHelper.nodePathWithEndNode("Hektor", path)), path);
    }

    @Test
    void testCompactReplacementMapping() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        int numberOfOperations = 200;
        String key = "Homer/Ilias";
        int i = 0;
        while (i < 200) {
            int index = i++;
            Mockito.when((Object)resolver.resolveAddKey((Object)((ImmutableNode)ArgumentMatchers.any()), (String)ArgumentMatchers.eq((Object)KEY), (NodeHandler)ArgumentMatchers.any())).thenAnswer(invocation -> {
                Assertions.assertSame((Object)model.getRootNode(), (Object)invocation.getArgument(0));
                ImmutableNode addParent = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
                return new NodeAddData((Object)addParent, "Warrior" + index, false, null);
            });
        }
        for (i = 0; i < 200; ++i) {
            model.addProperty(KEY, Collections.singleton(i), resolver);
        }
        ImmutableNode orgNode = NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer/Ilias");
        ImmutableNode changedNode = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assertions.assertEquals((int)(orgNode.getChildren().size() + 200), (int)changedNode.getChildren().size());
        Map replacementMapping = model.getTreeData().copyReplacementMapping();
        Assertions.assertTrue((replacementMapping.size() < 200 ? 1 : 0) != 0);
    }

    @Test
    void testConcurrentUpdate() throws InterruptedException {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveAddKey((Object)((ImmutableNode)ArgumentMatchers.any()), (String)ArgumentMatchers.eq((Object)KEY), (NodeHandler)ArgumentMatchers.any())).thenAnswer(invocation -> {
            ImmutableNode addParent = (ImmutableNode)invocation.getArgument(0, ImmutableNode.class);
            return new NodeAddData((Object)addParent, "name", false, Collections.singleton("author"));
        });
        CountDownLatch latch = new CountDownLatch(1);
        String authorPrefix = "newAuthor";
        int threadCount = 32;
        Thread[] threads = new Thread[32];
        for (int i = 0; i < 32; ++i) {
            String authorName = "newAuthor" + i;
            threads[i] = new Thread(() -> {
                try {
                    latch.await();
                    model.addProperty(KEY, Collections.singleton(authorName), resolver);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            threads[i].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        Pattern patternAuthorName = Pattern.compile(Pattern.quote("newAuthor") + "(\\d+)");
        HashSet<Integer> indices = new HashSet<Integer>();
        for (int i = 0; i < 32; ++i) {
            ImmutableNode node = NodeStructureHelper.nodeForKey(model, "author(" + i + ")/name");
            Matcher m = patternAuthorName.matcher(String.valueOf(node.getValue()));
            Assertions.assertTrue((boolean)m.matches(), (String)("Wrong value: " + node.getValue()));
            int idx = Integer.parseInt(m.group(1));
            Assertions.assertTrue((idx >= 0 && idx < 32 ? 1 : 0) != 0, (String)("Invalid index: " + idx));
            indices.add(idx);
        }
        Assertions.assertEquals((int)32, (int)indices.size());
    }

    @Test
    void testGetInMemoryRepresentation() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getInMemoryRepresentation());
    }

    @Test
    void testGetNodeHandler() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assertions.assertSame((Object)model.getTreeData(), (Object)model.getNodeHandler());
    }

    @Test
    void testGetRootNodeFromConstructor() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
    }

    @Test
    void testInitDefaultRoot() {
        InMemoryNodeModel model = new InMemoryNodeModel();
        ImmutableNode root = model.getRootNode();
        Assertions.assertNull((Object)root.getNodeName());
        Assertions.assertNull((Object)root.getValue());
        Assertions.assertTrue((boolean)root.getChildren().isEmpty());
        Assertions.assertTrue((boolean)root.getAttributes().isEmpty());
    }

    @Test
    void testSetPropertyChangedValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        HashMap<QueryResult, String> changedValues = new HashMap<QueryResult, String>();
        String newValue = "of course";
        ImmutableNode changedNode = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        changedValues.put(QueryResult.createAttributeResult((Object)changedNode, (String)"tested"), "of course");
        changedValues.put(QueryResult.createNodeResult((Object)changedNode), "of course");
        NodeUpdateData updateData = new NodeUpdateData(changedValues, null, null, null);
        Mockito.when((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).thenReturn((Object)updateData);
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assertions.assertEquals((Object)"of course", node.getAttributes().get("tested"));
        Assertions.assertEquals((Object)"of course", (Object)node.getValue());
    }

    @Test
    void testSetPropertyClearValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String nodeKey = "Ariel/The Tempest/originalValue";
        NodeUpdateData updateData = new NodeUpdateData(null, null, Collections.singletonList(QueryResult.createNodeResult((Object)NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue"))), null);
        Mockito.when((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).thenReturn((Object)updateData);
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Ariel/The Tempest/originalValue");
        Assertions.assertNull((Object)node.getValue());
    }

    @Test
    void testSetPropertyNewValues() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        NodeAddData addData = new NodeAddData((Object)NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, "Homer"), "work", false, null);
        NodeUpdateData updateData = new NodeUpdateData(null, Collections.singleton("Odyssee"), null, KEY);
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Mockito.when((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, (Object)this, model.getNodeHandler())).thenReturn((Object)updateData);
        Mockito.when((Object)resolver.resolveAddKey((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, KEY, model.getNodeHandler())).thenReturn((Object)addData);
        model.setProperty(KEY, (Object)this, resolver);
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/work");
        Assertions.assertEquals((Object)"Odyssee", (Object)node.getValue());
        Assertions.assertNotNull((Object)NodeStructureHelper.nodeForKey(model, "Homer/Ilias/Hektor"));
    }

    @Test
    void testSetPropertyNoChanges() {
        NodeKeyResolver<ImmutableNode> resolver = TestInMemoryNodeModel.createResolver();
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Mockito.when((Object)resolver.resolveUpdateKey((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, KEY, (Object)this, model.getNodeHandler())).thenReturn((Object)new NodeUpdateData(null, null, null, null));
        model.setProperty(KEY, (Object)this, resolver);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, (Object)model.getRootNode());
    }

    @Test
    void testSetRoot() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        model.setRootNode(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assertions.assertSame((Object)NodeStructureHelper.ROOT_AUTHORS_TREE, (Object)model.getRootNode());
        ImmutableNode node = NodeStructureHelper.nodeForKey(model, "Homer/Ilias");
        Assertions.assertEquals((Object)NodeStructureHelper.nodeForKey(model, "Homer"), (Object)model.getNodeHandler().getParent((Object)node));
    }

    @Test
    void testSetRootNull() {
        InMemoryNodeModel model = new InMemoryNodeModel(NodeStructureHelper.ROOT_PERSONAE_TREE);
        model.setRootNode(null);
        ImmutableNode rootNode = model.getRootNode();
        Assertions.assertTrue((boolean)rootNode.getChildren().isEmpty());
    }
}

