/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.NonCloneableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventSource;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.sync.NoOpSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestConfigurationUtils {
    private static final String CLS_NAME = "org.apache.commons.configuration2.PropertiesConfiguration";
    private ClassLoader ccl;

    @BeforeEach
    public void setUp() throws Exception {
        this.ccl = Thread.currentThread().getContextClassLoader();
    }

    @AfterEach
    public void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(this.ccl);
    }

    @Test
    void testAppend() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.append((Configuration)conf1, (Configuration)conf2);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value1");
        Assertions.assertEquals(expected, (Object)conf2.getList("key1"));
        expected = new ArrayList();
        expected.add("value4");
        expected.add("value2");
        Assertions.assertEquals(expected, (Object)conf2.getList("key2"));
    }

    @Test
    void testAsEventSourceNonSupportedEx() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ConfigurationUtils.asEventSource((Object)this, (boolean)false));
    }

    @Test
    void testAsEventSourceSupported() {
        XMLConfiguration src = new XMLConfiguration();
        Assertions.assertSame((Object)src, (Object)ConfigurationUtils.asEventSource((Object)src, (boolean)true));
    }

    @Test
    void testAsEventSourceUnsupportedMock() {
        EventListener cl = (EventListener)Mockito.mock(EventListener.class);
        EventSource source = ConfigurationUtils.asEventSource((Object)this, (boolean)true);
        source.addEventListener(ConfigurationEvent.ANY, cl);
        Assertions.assertFalse((boolean)source.removeEventListener(ConfigurationEvent.ANY, cl));
        source.addEventListener(ConfigurationEvent.ANY, null);
    }

    @Test
    void testCloneConfiguration() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        BaseHierarchicalConfiguration copy = (BaseHierarchicalConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)conf);
        Assertions.assertNotSame((Object)conf, (Object)copy);
        Assertions.assertEquals((Object)"yes", (Object)copy.getString("test"));
    }

    @Test
    void testCloneConfigurationNotSupported() {
        NonCloneableConfiguration myNonCloneableConfig = new NonCloneableConfiguration();
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> TestConfigurationUtils.lambda$testCloneConfigurationNotSupported$1((Configuration)myNonCloneableConfig));
    }

    @Test
    void testCloneConfigurationNull() {
        Assertions.assertNull((Object)ConfigurationUtils.cloneConfiguration(null));
    }

    @Test
    void testCloneIfPossibleError() {
        XMLBuilderParametersImpl params = new XMLBuilderParametersImpl(){

            public XMLBuilderParametersImpl clone() {
                throw new ConfigurationRuntimeException();
            }
        };
        Assertions.assertSame((Object)params, (Object)ConfigurationUtils.cloneIfPossible((Object)params));
    }

    @Test
    void testCloneIfPossibleNotSupported() {
        Long value = 20130116221714L;
        Assertions.assertSame((Object)value, (Object)ConfigurationUtils.cloneIfPossible((Object)value));
    }

    @Test
    void testCloneIfPossibleNull() {
        Assertions.assertNull((Object)ConfigurationUtils.cloneIfPossible(null));
    }

    @Test
    void testCloneIfPossibleSupported() {
        XMLBuilderParametersImpl params = new XMLBuilderParametersImpl();
        params.setPublicID("testID");
        params.setSchemaValidation(true);
        XMLBuilderParametersImpl clone = (XMLBuilderParametersImpl)ConfigurationUtils.cloneIfPossible((Object)params);
        Assertions.assertNotSame((Object)params, (Object)clone);
        Map map = clone.getParameters();
        for (Map.Entry e : params.getParameters().entrySet()) {
            if (((String)e.getKey()).startsWith("config-")) continue;
            Assertions.assertEquals(e.getValue(), map.get(e.getKey()), (String)("Wrong value for field " + (String)e.getKey()));
        }
    }

    @Test
    void testCloneSynchronizerClone() {
        CloneableSynchronizer sync = new CloneableSynchronizer(false);
        CloneableSynchronizer sync2 = (CloneableSynchronizer)ConfigurationUtils.cloneSynchronizer((Synchronizer)sync);
        Assertions.assertTrue((boolean)sync2.isCloned());
    }

    @Test
    void testCloneSynchronizerFailed() {
        NonCloneableSynchronizer synchronizer = new NonCloneableSynchronizer();
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ConfigurationUtils.cloneSynchronizer((Synchronizer)synchronizer));
    }

    @Test
    void testCloneSynchronizerNewInstance() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        SynchronizerTestImpl sync2 = (SynchronizerTestImpl)ConfigurationUtils.cloneSynchronizer((Synchronizer)sync);
        Assertions.assertNotNull((Object)sync2);
        Assertions.assertNotSame((Object)sync, (Object)sync2);
    }

    @Test
    void testCloneSynchronizerNoOp() {
        Assertions.assertSame((Object)NoOpSynchronizer.INSTANCE, (Object)ConfigurationUtils.cloneSynchronizer((Synchronizer)NoOpSynchronizer.INSTANCE));
    }

    @Test
    void testCloneSynchronizerNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtils.cloneSynchronizer(null));
    }

    @Test
    void testConvertHierarchicalToHierarchical() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        Assertions.assertSame((Object)conf, (Object)ConfigurationUtils.convertToHierarchical((Configuration)conf));
    }

    @Test
    void testConvertHierarchicalToHierarchicalEngine() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        Assertions.assertSame((Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, (ExpressionEngine)engine));
        Assertions.assertSame((Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    void testConvertHierarchicalToHierarchicalNullEngine() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        hc.setExpressionEngine((ExpressionEngine)engine);
        Assertions.assertSame((Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, null));
        Assertions.assertSame((Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    void testConvertNullToHierarchical() {
        Assertions.assertNull((Object)ConfigurationUtils.convertToHierarchical(null));
    }

    @Test
    void testConvertToHierarchical() {
        BaseConfiguration conf = new BaseConfiguration();
        for (int i = 0; i < 10; ++i) {
            conf.addProperty("test" + i, (Object)("value" + i));
            conf.addProperty("test.list", (Object)("item" + i));
        }
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertEquals((Object)conf.getProperty(key), (Object)hc.getProperty(key), (String)("Wrong value for key " + key));
        }
    }

    @Test
    void testConvertToHierarchicalDelimiters() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        conf.addProperty("test.key", (Object)"1\\,2\\,3");
        Assertions.assertEquals((Object)"1,2,3", (Object)conf.getString("test.key"));
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Assertions.assertEquals((Object)"1,2,3", (Object)hc.getString("test.key"));
    }

    @Test
    void testConvertToHierarchicalEngine() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("test(a)", (Object)Boolean.TRUE);
        conf.addProperty("test(b)", (Object)Boolean.FALSE);
        DefaultExpressionEngine engine = new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setIndexStart("[").setIndexEnd("]").create());
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf, (ExpressionEngine)engine);
        Assertions.assertTrue((boolean)hc.getBoolean("test(a)"));
        Assertions.assertFalse((boolean)hc.getBoolean("test(b)"));
    }

    @Test
    void testConvertToHierarchicalMultiValues() {
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("test", (Object)"1,2,3");
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)config);
        Assertions.assertEquals((int)1, (int)hc.getInt("test(0)"));
        Assertions.assertEquals((int)2, (int)hc.getInt("test(1)"));
        Assertions.assertEquals((int)3, (int)hc.getInt("test(2)"));
    }

    @Test
    void testConvertToHierarchicalOrderOfProperties() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("x.y.z", (Object)true);
        config.addProperty("x.y", (Object)true);
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)config);
        ImmutableNode rootNode = (ImmutableNode)hc.getNodeModel().getNodeHandler().getRootNode();
        ImmutableNode nodeX = (ImmutableNode)rootNode.getChildren().get(0);
        Assertions.assertEquals((int)1, (int)nodeX.getChildren().size());
    }

    @Test
    void testCopy() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.copy((Configuration)conf1, (Configuration)conf2);
        Assertions.assertEquals((Object)"value1", (Object)conf2.getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)conf2.getProperty("key2"));
    }

    @Test
    void testEnableRuntimeExceptions() {
        PropertiesConfiguration config = new PropertiesConfiguration(){

            protected void addPropertyDirect(String key, Object value) {
                this.fireError(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, key, value, new RuntimeException("A faked exception!"));
            }
        };
        config.clearErrorListeners();
        ConfigurationUtils.enableRuntimeExceptions((Configuration)config);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> config.addProperty("test", (Object)"testValue"));
    }

    @Test
    void testEnableRuntimeExceptionsInvalid() {
        Configuration c = (Configuration)Mockito.mock(Configuration.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtils.enableRuntimeExceptions((Configuration)c));
    }

    @Test
    void testEnableRuntimeExceptionsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationUtils.enableRuntimeExceptions(null));
    }

    @Test
    void testLoadClassCCLNotFound() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException(name);
            }
        });
        Assertions.assertEquals((Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    void testLoadClassCCLNull() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(null);
        Assertions.assertEquals((Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    void testLoadClassFromCCL() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Assertions.assertEquals((Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    void testLoadClassNoExFound() {
        Assertions.assertEquals((Object)CLS_NAME, (Object)ConfigurationUtils.loadClassNoEx((String)CLS_NAME).getName());
    }

    @Test
    void testLoadClassNoExNotFound() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ConfigurationUtils.loadClassNoEx((String)"a non existing class!"));
    }

    @Test
    void testLoadClassNotFound() {
        Assertions.assertThrows(ClassNotFoundException.class, () -> ConfigurationUtils.loadClass((String)"a non existing class!"));
    }

    @Test
    void testToString() {
        BaseConfiguration config = new BaseConfiguration();
        String lineSeparator = System.lineSeparator();
        Assertions.assertEquals((Object)"", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("one", (Object)"1");
        Assertions.assertEquals((Object)"one=1", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("two", (Object)"2");
        Assertions.assertEquals((Object)("one=1" + lineSeparator + "two=2"), (Object)ConfigurationUtils.toString((Configuration)config));
        config.clearProperty("one");
        Assertions.assertEquals((Object)"two=2", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("one", (Object)"1");
        Assertions.assertEquals((Object)("two=2" + lineSeparator + "one=1"), (Object)ConfigurationUtils.toString((Configuration)config));
    }

    private static /* synthetic */ void lambda$testCloneConfigurationNotSupported$1(Configuration myNonCloneableConfig) throws Throwable {
        ConfigurationUtils.cloneConfiguration((Configuration)myNonCloneableConfig);
    }

    private static final class CloneableSynchronizer
    extends NonCloneableSynchronizer
    implements Cloneable {
        private final boolean cloned;

        public CloneableSynchronizer(boolean clone) {
            this.cloned = clone;
        }

        public Object clone() {
            return new CloneableSynchronizer(true);
        }

        public boolean isCloned() {
            return this.cloned;
        }
    }

    private static class NonCloneableSynchronizer
    extends SynchronizerTestImpl {
        private NonCloneableSynchronizer() {
        }
    }
}

