/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.convert;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.convert.ValueTransformer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDefaultListDelimiterHandler {
    private DefaultListDelimiterHandler handler;

    private void checkSplit(String value, boolean trim, String ... expectedElements) {
        Collection elems = this.handler.split(value, trim);
        Assertions.assertIterableEquals(Arrays.asList(expectedElements), (Iterable)elems);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.handler = new DefaultListDelimiterHandler(',');
    }

    @Test
    public void testEscapeIntegerList() {
        ValueTransformer trans = ListDelimiterHandler.NOOP_TRANSFORMER;
        List<Integer> data = Arrays.asList(1, 2, 3, 4);
        Assertions.assertEquals((Object)"1,2,3,4", (Object)this.handler.escapeList(data, trans));
    }

    @Test
    public void testEscapeList() {
        ValueTransformer trans = value -> String.valueOf(value) + "_trans";
        List<String> data = Arrays.asList("simple", "Hello,world!", "\\,\\", "end");
        Assertions.assertEquals((Object)"simple_trans,Hello\\,world!_trans,\\\\\\,\\\\_trans,end_trans", (Object)this.handler.escapeList(data, trans));
    }

    @Test
    public void testEscapeStringBackslash() {
        Assertions.assertEquals((Object)"C:\\\\Temp\\\\", (Object)this.handler.escapeString("C:\\Temp\\"));
    }

    @Test
    public void testEscapeStringListDelimiter() {
        Assertions.assertEquals((Object)"3\\,1415", (Object)this.handler.escapeString("3,1415"));
    }

    @Test
    public void testEscapeStringListDelimiterAndBackslash() {
        Assertions.assertEquals((Object)"C:\\\\Temp\\\\\\,\\\\\\\\Share\\,/root", (Object)this.handler.escapeString("C:\\Temp\\,\\\\Share,/root"));
    }

    @Test
    public void testEscapeStringNoSpecialCharacter() {
        Assertions.assertEquals((Object)"test", (Object)this.handler.escapeString("test"));
    }

    @Test
    public void testEscapeWithTransformer() {
        ValueTransformer trans = (ValueTransformer)Mockito.mock(ValueTransformer.class);
        Mockito.when((Object)trans.transformValue((Object)"a\\,b")).thenReturn((Object)"ok");
        Assertions.assertEquals((Object)"ok", (Object)this.handler.escape((Object)"a,b", trans));
        ((ValueTransformer)Mockito.verify((Object)trans)).transformValue((Object)"a\\,b");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{trans});
    }

    @Test
    public void testSplitEscapeBackslash() {
        this.checkSplit("C:\\\\Temp\\\\", true, "C:\\Temp\\");
    }

    @Test
    public void testSplitEscapeLineDelimiter() {
        this.checkSplit("3\\,1415", true, "3,1415");
    }

    @Test
    public void testSplitEscapeListDelimiterAndBackslashes() {
        this.checkSplit("C:\\\\Temp\\\\\\,\\\\\\\\Share\\\\,/root", false, "C:\\Temp\\,\\\\Share\\", "/root");
    }

    @Test
    public void testSplitList() {
        this.checkSplit("a, b,c   ,   d", true, "a", "b", "c", "d");
    }

    @Test
    public void testSplitNoTrim() {
        this.checkSplit("a , b,  c  ,d", false, "a ", " b", "  c  ", "d");
    }

    @Test
    public void testSplitSingleElement() {
        this.checkSplit("test", true, "test");
    }

    @Test
    public void testSplitUnexpectedEscape() {
        this.checkSplit("\\x, \\,y, \\", true, "\\x", ",y", "\\");
    }
}

