package org.apache.cayenne.testdo.relationships_activity.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import java.util.Map;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.DateProperty;
import org.apache.cayenne.exp.property.MapProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.relationships_activity.ActivityResult;

/**
 * Class _Activity was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Activity extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final StringProperty<String> ACTIVITY_ID_PK_PROPERTY = PropertyFactory.createString(ExpressionFactory.dbPathExp("ACTIVITY_ID"), String.class);
    public static final String ACTIVITY_ID_PK_COLUMN = "ACTIVITY_ID";

    public static final DateProperty<Date> APPOINTMENT_DATE = PropertyFactory.createDate("appointmentDate", Date.class);
    public static final NumericProperty<Integer> APPOINTMENT_NO = PropertyFactory.createNumeric("appointmentNo", Integer.class);
    public static final MapProperty<String, ActivityResult> RESULTS = PropertyFactory.createMap("results", String.class, ActivityResult.class);

    protected Date appointmentDate;
    protected int appointmentNo;

    protected Object results;

    public void setAppointmentDate(Date appointmentDate) {
        beforePropertyWrite("appointmentDate", this.appointmentDate, appointmentDate);
        this.appointmentDate = appointmentDate;
    }

    public Date getAppointmentDate() {
        beforePropertyRead("appointmentDate");
        return this.appointmentDate;
    }

    public void setAppointmentNo(int appointmentNo) {
        beforePropertyWrite("appointmentNo", this.appointmentNo, appointmentNo);
        this.appointmentNo = appointmentNo;
    }

    public int getAppointmentNo() {
        beforePropertyRead("appointmentNo");
        return this.appointmentNo;
    }

    public void addToResults(ActivityResult obj) {
        addToManyTarget("results", obj, true);
    }

    public void removeFromResults(ActivityResult obj) {
        removeToManyTarget("results", obj, true);
    }

    @SuppressWarnings("unchecked")
    public Map<String, ActivityResult> getResults() {
        return (Map<String, ActivityResult>)readProperty("results");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "appointmentDate":
                return this.appointmentDate;
            case "appointmentNo":
                return this.appointmentNo;
            case "results":
                return this.results;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "appointmentDate":
                this.appointmentDate = (Date)val;
                break;
            case "appointmentNo":
                this.appointmentNo = val == null ? 0 : (int)val;
                break;
            case "results":
                this.results = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.appointmentDate);
        out.writeInt(this.appointmentNo);
        out.writeObject(this.results);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.appointmentDate = (Date)in.readObject();
        this.appointmentNo = in.readInt();
        this.results = in.readObject();
    }

}
