/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataComponentSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class ValidationMetadata
extends MetadataComponent {
    public static final IMetadataComponentSerializer serializer = new ValidationMetadataSerializer();
    public final String partitioner;
    public final double bloomFilterFPChance;

    public ValidationMetadata(String partitioner, double bloomFilterFPChance) {
        this.partitioner = partitioner;
        this.bloomFilterFPChance = bloomFilterFPChance;
    }

    @Override
    public MetadataType getType() {
        return MetadataType.VALIDATION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMetadata that = (ValidationMetadata)o;
        return Double.compare(that.bloomFilterFPChance, this.bloomFilterFPChance) == 0 && this.partitioner.equals(that.partitioner);
    }

    public int hashCode() {
        int result = this.partitioner.hashCode();
        long temp = Double.doubleToLongBits(this.bloomFilterFPChance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static class ValidationMetadataSerializer
    implements IMetadataComponentSerializer<ValidationMetadata> {
        @Override
        public int serializedSize(Version version, ValidationMetadata component) throws IOException {
            return TypeSizes.sizeof(component.partitioner) + 8;
        }

        @Override
        public void serialize(Version version, ValidationMetadata component, DataOutputPlus out) throws IOException {
            out.writeUTF(component.partitioner);
            out.writeDouble(component.bloomFilterFPChance);
        }

        @Override
        public ValidationMetadata deserialize(Version version, DataInputPlus in) throws IOException {
            return new ValidationMetadata(in.readUTF(), in.readDouble());
        }
    }
}

