/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.concrete;

import com.googlecode.concurrenttrees.common.CharSequences;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeDefault;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeLeafWithValue;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeNonLeafNullValue;
import com.googlecode.concurrenttrees.radix.node.concrete.bytearray.ByteArrayNodeNonLeafVoidValue;
import com.googlecode.concurrenttrees.radix.node.concrete.voidvalue.VoidValue;
import com.googlecode.concurrenttrees.radix.node.util.NodeUtil;
import java.util.List;

public class DefaultByteArrayNodeFactory
implements NodeFactory {
    @Override
    public Node createNode(CharSequence edgeCharacters, Object value, List<Node> childNodes, boolean isRoot) {
        if (edgeCharacters == null) {
            throw new IllegalStateException("The edgeCharacters argument was null");
        }
        if (!isRoot && edgeCharacters.length() == 0) {
            throw new IllegalStateException("Invalid edge characters for non-root node: " + CharSequences.toString(edgeCharacters));
        }
        if (childNodes == null) {
            throw new IllegalStateException("The childNodes argument was null");
        }
        NodeUtil.ensureNoDuplicateEdges(childNodes);
        if (childNodes.isEmpty()) {
            if (value instanceof VoidValue) {
                return new ByteArrayNodeLeafVoidValue(edgeCharacters);
            }
            if (value != null) {
                return new ByteArrayNodeLeafWithValue(edgeCharacters, value);
            }
            return new ByteArrayNodeLeafNullValue(edgeCharacters);
        }
        if (value instanceof VoidValue) {
            return new ByteArrayNodeNonLeafVoidValue(edgeCharacters, childNodes);
        }
        if (value == null) {
            return new ByteArrayNodeNonLeafNullValue(edgeCharacters, childNodes);
        }
        return new ByteArrayNodeDefault(edgeCharacters, value, childNodes);
    }
}

