/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class Int64Serializer
implements IVersionedSerializer<Long> {
    public static final Int64Serializer serializer = new Int64Serializer();

    @Override
    public void serialize(Long t, DataOutputPlus out, int version) throws IOException {
        out.writeLong(t);
    }

    @Override
    public Long deserialize(DataInputPlus in, int version) throws IOException {
        return in.readLong();
    }

    @Override
    public long serializedSize(Long t, int version) {
        return TypeSizes.sizeof(t);
    }
}

