/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import org.apache.cassandra.schema.Difference;

public class Diff<T extends Iterable, S> {
    public final T created;
    public final T dropped;
    public final ImmutableCollection<Altered<S>> altered;

    Diff(T created, T dropped, ImmutableCollection<Altered<S>> altered) {
        this.created = created;
        this.dropped = dropped;
        this.altered = altered;
    }

    boolean isEmpty() {
        return Iterables.isEmpty(this.created) && Iterables.isEmpty(this.dropped) && Iterables.isEmpty(this.altered);
    }

    Iterable<Altered<S>> altered(Difference kind) {
        return Iterables.filter(this.altered, a -> a.kind == kind);
    }

    public String toString() {
        return "Diff{created=" + this.created + ", dropped=" + this.dropped + ", altered=" + this.altered + "}";
    }

    public static final class Altered<T> {
        public final T before;
        public final T after;
        public final Difference kind;

        Altered(T before, T after, Difference kind) {
            this.before = before;
            this.after = after;
            this.kind = kind;
        }

        public String toString() {
            return String.format("%s -> %s (%s)", new Object[]{this.before, this.after, this.kind});
        }
    }
}

