/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public abstract class AbstractMetrics {
    public static final String TYPE = "StorageAttachedIndex";
    protected final String keyspace;
    protected final String table;
    private final String index;
    private final String scope;
    protected final List<CassandraMetricsRegistry.MetricName> tracked = new ArrayList<CassandraMetricsRegistry.MetricName>();

    AbstractMetrics(IndexIdentifier indexIdentifier, String scope) {
        this(indexIdentifier.keyspaceName, indexIdentifier.tableName, indexIdentifier.indexName, scope);
    }

    AbstractMetrics(String keyspace, String table, String scope) {
        this(keyspace, table, null, scope);
    }

    AbstractMetrics(String keyspace, String table, String index, String scope) {
        assert (keyspace != null && table != null) : "SAI metrics must include keyspace and table";
        this.keyspace = keyspace;
        this.table = table;
        this.index = index;
        this.scope = scope;
    }

    public void release() {
        this.tracked.forEach(CassandraMetricsRegistry.Metrics::remove);
        this.tracked.clear();
    }

    protected CassandraMetricsRegistry.MetricName createMetricName(String name) {
        return this.createMetricName(name, this.scope);
    }

    protected CassandraMetricsRegistry.MetricName createMetricName(String name, String scope) {
        String metricScope = this.keyspace + "." + this.table;
        if (this.index != null) {
            metricScope = metricScope + "." + this.index;
        }
        metricScope = metricScope + "." + scope;
        CassandraMetricsRegistry.MetricName metricName = new CassandraMetricsRegistry.MetricName("org.apache.cassandra.metrics", TYPE, name, metricScope, this.createMBeanName(name, scope));
        this.tracked.add(metricName);
        return metricName;
    }

    private String createMBeanName(String name, String scope) {
        StringBuilder builder = new StringBuilder();
        builder.append("org.apache.cassandra.metrics");
        builder.append(":type=").append(TYPE);
        builder.append(',').append("keyspace=").append(this.keyspace);
        builder.append(',').append("table=").append(this.table);
        if (this.index != null) {
            builder.append(',').append("index=").append(this.index);
        }
        builder.append(',').append("scope=").append(scope);
        builder.append(',').append("name=").append(name);
        return builder.toString();
    }
}

