/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.AbstractClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSet;

public class ClusteringIndexNamesFilter
extends AbstractClusteringIndexFilter {
    static final ClusteringIndexFilter.InternalDeserializer deserializer = new NamesDeserializer();
    private final NavigableSet<Clustering<?>> clusterings;
    private final NavigableSet<Clustering<?>> clusteringsInQueryOrder;

    public ClusteringIndexNamesFilter(NavigableSet<Clustering<?>> clusterings, boolean reversed) {
        super(reversed);
        assert (!clusterings.contains(Clustering.STATIC_CLUSTERING));
        this.clusterings = clusterings;
        this.clusteringsInQueryOrder = reversed ? clusterings.descendingSet() : clusterings;
    }

    public NavigableSet<Clustering<?>> requestedRows() {
        return this.clusterings;
    }

    @Override
    public boolean selectsAllPartition() {
        return this.clusterings.isEmpty();
    }

    @Override
    public boolean selects(Clustering<?> clustering) {
        return this.clusterings.contains(clustering);
    }

    @Override
    public ClusteringIndexNamesFilter forPaging(ClusteringComparator comparator, Clustering<?> lastReturned, boolean inclusive) {
        NavigableSet<Clustering<?>> newClusterings = this.reversed ? this.clusterings.headSet(lastReturned, inclusive) : this.clusterings.tailSet(lastReturned, inclusive);
        return new ClusteringIndexNamesFilter(newClusterings, this.reversed);
    }

    @Override
    public boolean isFullyCoveredBy(CachedPartition partition) {
        if (partition.isEmpty()) {
            return false;
        }
        return this.clusterings.comparator().compare(this.clusterings.last(), partition.lastRow().clustering()) <= 0;
    }

    @Override
    public boolean isHeadFilter() {
        return false;
    }

    @Override
    public UnfilteredRowIterator filterNotIndexed(final ColumnFilter columnFilter, final UnfilteredRowIterator iterator) {
        class FilterNotIndexed
        extends Transformation {
            FilterNotIndexed() {
            }

            @Override
            public Row applyToStatic(Row row) {
                return columnFilter.fetchedColumns().statics.isEmpty() ? null : row.filter(columnFilter, iterator.metadata());
            }

            @Override
            public Row applyToRow(Row row) {
                return ClusteringIndexNamesFilter.this.clusterings.contains(row.clustering()) ? row.filter(columnFilter, iterator.metadata()) : null;
            }
        }
        return Transformation.apply(iterator, new FilterNotIndexed());
    }

    @Override
    public Slices getSlices(TableMetadata metadata) {
        Slices.Builder builder = new Slices.Builder(metadata.comparator, this.clusteringsInQueryOrder.size());
        for (Clustering<?> clustering : this.clusteringsInQueryOrder) {
            builder.add(Slice.make(clustering));
        }
        return builder.build();
    }

    @Override
    public UnfilteredRowIterator getUnfilteredRowIterator(ColumnFilter columnFilter, Partition partition) {
        return partition.unfilteredIterator(columnFilter, this.clusteringsInQueryOrder, this.isReversed());
    }

    @Override
    public boolean intersects(ClusteringComparator comparator, Slice slice) {
        for (Clustering<?> clustering : this.clusterings) {
            if (!slice.includes(comparator, clustering)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString(TableMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("names(");
        int i = 0;
        for (Clustering<?> clustering : this.clusterings) {
            sb.append(i++ == 0 ? "" : ", ").append(clustering.toString(metadata));
        }
        if (this.reversed) {
            sb.append(", reversed");
        }
        return sb.append(')').toString();
    }

    @Override
    public String toCQLString(TableMetadata metadata, RowFilter rowFilter) {
        if (metadata.clusteringColumns().isEmpty() || this.clusterings.isEmpty()) {
            return rowFilter.toCQLString();
        }
        boolean isSingleColumn = metadata.clusteringColumns().size() == 1;
        boolean isSingleClustering = this.clusterings.size() == 1;
        StringBuilder sb = new StringBuilder();
        sb.append(isSingleColumn ? "" : Character.valueOf('(')).append(ColumnMetadata.toCQLString(metadata.clusteringColumns())).append(isSingleColumn ? "" : Character.valueOf(')'));
        sb.append(isSingleClustering ? " = " : " IN (");
        int i = 0;
        for (Clustering<?> clustering : this.clusterings) {
            sb.append(i++ == 0 ? "" : ", ").append(isSingleColumn ? "" : Character.valueOf('(')).append(clustering.toCQLString(metadata)).append(isSingleColumn ? "" : Character.valueOf(')'));
            for (int j = 0; j < clustering.size(); ++j) {
                rowFilter = rowFilter.without((ColumnMetadata)metadata.clusteringColumns().get(j), Operator.EQ, clustering.bufferAt(j));
            }
        }
        sb.append(isSingleClustering ? "" : ")");
        if (!rowFilter.isEmpty()) {
            sb.append(" AND ").append(rowFilter.toCQLString());
        }
        this.appendOrderByToCQLString(metadata, sb);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteringIndexNamesFilter that = (ClusteringIndexNamesFilter)o;
        return Objects.equals(this.clusterings, that.clusterings) && Objects.equals(this.reversed, that.reversed);
    }

    public int hashCode() {
        return Objects.hash(this.clusterings, this.reversed);
    }

    @Override
    public ClusteringIndexFilter.Kind kind() {
        return ClusteringIndexFilter.Kind.NAMES;
    }

    @Override
    protected void serializeInternal(DataOutputPlus out, int version) throws IOException {
        ClusteringComparator comparator = (ClusteringComparator)this.clusterings.comparator();
        out.writeUnsignedVInt32(this.clusterings.size());
        for (Clustering<?> clustering : this.clusterings) {
            Clustering.serializer.serialize(clustering, out, version, comparator.subtypes());
        }
    }

    @Override
    protected long serializedSizeInternal(int version) {
        ClusteringComparator comparator = (ClusteringComparator)this.clusterings.comparator();
        long size = TypeSizes.sizeofUnsignedVInt(this.clusterings.size());
        for (Clustering<?> clustering : this.clusterings) {
            size += Clustering.serializer.serializedSize(clustering, version, comparator.subtypes());
        }
        return size;
    }

    private static class NamesDeserializer
    implements ClusteringIndexFilter.InternalDeserializer {
        private NamesDeserializer() {
        }

        @Override
        public ClusteringIndexFilter deserialize(DataInputPlus in, int version, TableMetadata metadata, boolean reversed) throws IOException {
            ClusteringComparator comparator = metadata.comparator;
            int size = in.readUnsignedVInt32();
            try (BTree.FastBuilder<Clustering<byte[]>> builder = BTree.fastBuilder();){
                for (int i = 0; i < size; ++i) {
                    builder.add(Clustering.serializer.deserialize(in, version, comparator.subtypes()));
                }
                BTreeSet<Clusterable> clusterings = BTreeSet.wrap(builder.build(), comparator);
                ClusteringIndexNamesFilter clusteringIndexNamesFilter = new ClusteringIndexNamesFilter(clusterings, reversed);
                return clusteringIndexNamesFilter;
            }
        }
    }
}

