/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogService;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;

public class GroupCommitLogService
extends AbstractCommitLogService {
    public GroupCommitLogService(CommitLog commitLog) {
        super(commitLog, "GROUP-COMMIT-LOG-WRITER", (int)DatabaseDescriptor.getCommitLogSyncGroupWindow());
    }

    @Override
    protected void maybeWaitForSync(CommitLogSegment.Allocation alloc) {
        this.pending.incrementAndGet();
        alloc.awaitDiskSync(this.commitLog.metrics.waitingOnCommit);
        this.pending.decrementAndGet();
    }
}

