/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Provide access to PyTorch TorchServe servers to run inference with PyTorch
 * models remotely
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface TorchServeEndpointBuilderFactory {

    /**
     * Builder for endpoint for the TorchServe component.
     */
    public interface TorchServeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTorchServeEndpointBuilder advanced() {
            return (AdvancedTorchServeEndpointBuilder) this;
        }

        /**
         * The name of model.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelName the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder modelName(String modelName) {
            doSetProperty("modelName", modelName);
            return this;
        }
        /**
         * The version of model.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param modelVersion the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder modelVersion(String modelVersion) {
            doSetProperty("modelVersion", modelVersion);
            return this;
        }
        /**
         * The address of the inference API endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: inference
         * 
         * @param inferenceAddress the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder inferenceAddress(String inferenceAddress) {
            doSetProperty("inferenceAddress", inferenceAddress);
            return this;
        }
        /**
         * The port of the inference API endpoint.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8080
         * Group: inference
         * 
         * @param inferencePort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder inferencePort(int inferencePort) {
            doSetProperty("inferencePort", inferencePort);
            return this;
        }
        /**
         * The port of the inference API endpoint.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8080
         * Group: inference
         * 
         * @param inferencePort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder inferencePort(String inferencePort) {
            doSetProperty("inferencePort", inferencePort);
            return this;
        }
        /**
         * The maximum number of items to return for the list operation. When
         * this value is present, TorchServe does not return more than the
         * specified number of items, but it might return fewer. This value is
         * optional. If you include a value, it must be between 1 and 1000,
         * inclusive. If you do not include a value, it defaults to 100.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 100
         * Group: management
         * 
         * @param listLimit the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder listLimit(int listLimit) {
            doSetProperty("listLimit", listLimit);
            return this;
        }
        /**
         * The maximum number of items to return for the list operation. When
         * this value is present, TorchServe does not return more than the
         * specified number of items, but it might return fewer. This value is
         * optional. If you include a value, it must be between 1 and 1000,
         * inclusive. If you do not include a value, it defaults to 100.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 100
         * Group: management
         * 
         * @param listLimit the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder listLimit(String listLimit) {
            doSetProperty("listLimit", listLimit);
            return this;
        }
        /**
         * The token to retrieve the next set of results for the list operation.
         * TorchServe provides the token when the response from a previous call
         * has more results than the maximum page size.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: management
         * 
         * @param listNextPageToken the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder listNextPageToken(String listNextPageToken) {
            doSetProperty("listNextPageToken", listNextPageToken);
            return this;
        }
        /**
         * The address of the management API endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: management
         * 
         * @param managementAddress the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder managementAddress(String managementAddress) {
            doSetProperty("managementAddress", managementAddress);
            return this;
        }
        /**
         * The port of the management API endpoint.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8081
         * Group: management
         * 
         * @param managementPort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder managementPort(int managementPort) {
            doSetProperty("managementPort", managementPort);
            return this;
        }
        /**
         * The port of the management API endpoint.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8081
         * Group: management
         * 
         * @param managementPort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder managementPort(String managementPort) {
            doSetProperty("managementPort", managementPort);
            return this;
        }
        /**
         * Additional options for the register operation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.torchserve.client.model.RegisterOptions</code> type.
         * 
         * Group: management
         * 
         * @param registerOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder registerOptions(org.apache.camel.component.torchserve.client.model.RegisterOptions registerOptions) {
            doSetProperty("registerOptions", registerOptions);
            return this;
        }
        /**
         * Additional options for the register operation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.torchserve.client.model.RegisterOptions</code> type.
         * 
         * Group: management
         * 
         * @param registerOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder registerOptions(String registerOptions) {
            doSetProperty("registerOptions", registerOptions);
            return this;
        }
        /**
         * Additional options for the scale-worker operation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions</code> type.
         * 
         * Group: management
         * 
         * @param scaleWorkerOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder scaleWorkerOptions(org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions scaleWorkerOptions) {
            doSetProperty("scaleWorkerOptions", scaleWorkerOptions);
            return this;
        }
        /**
         * Additional options for the scale-worker operation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions</code> type.
         * 
         * Group: management
         * 
         * @param scaleWorkerOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder scaleWorkerOptions(String scaleWorkerOptions) {
            doSetProperty("scaleWorkerOptions", scaleWorkerOptions);
            return this;
        }
        /**
         * Additional options for the unregister operation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.torchserve.client.model.UnregisterOptions</code> type.
         * 
         * Group: management
         * 
         * @param unregisterOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder unregisterOptions(org.apache.camel.component.torchserve.client.model.UnregisterOptions unregisterOptions) {
            doSetProperty("unregisterOptions", unregisterOptions);
            return this;
        }
        /**
         * Additional options for the unregister operation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.torchserve.client.model.UnregisterOptions</code> type.
         * 
         * Group: management
         * 
         * @param unregisterOptions the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder unregisterOptions(String unregisterOptions) {
            doSetProperty("unregisterOptions", unregisterOptions);
            return this;
        }
        /**
         * Model archive download url, support local file or HTTP(s) protocol.
         * For S3, consider using pre-signed url.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: management
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * The address of the metrics API endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: metrics
         * 
         * @param metricsAddress the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder metricsAddress(String metricsAddress) {
            doSetProperty("metricsAddress", metricsAddress);
            return this;
        }
        /**
         * Names of metrics to filter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: metrics
         * 
         * @param metricsName the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder metricsName(String metricsName) {
            doSetProperty("metricsName", metricsName);
            return this;
        }
        /**
         * The port of the metrics API endpoint.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8082
         * Group: metrics
         * 
         * @param metricsPort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder metricsPort(int metricsPort) {
            doSetProperty("metricsPort", metricsPort);
            return this;
        }
        /**
         * The port of the metrics API endpoint.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8082
         * Group: metrics
         * 
         * @param metricsPort the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder metricsPort(String metricsPort) {
            doSetProperty("metricsPort", metricsPort);
            return this;
        }
        /**
         * The token authorization key for accessing the inference API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param inferenceKey the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder inferenceKey(String inferenceKey) {
            doSetProperty("inferenceKey", inferenceKey);
            return this;
        }
        /**
         * The token authorization key for accessing the management API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param managementKey the value to set
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder managementKey(String managementKey) {
            doSetProperty("managementKey", managementKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the TorchServe component.
     */
    public interface AdvancedTorchServeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default TorchServeEndpointBuilder basic() {
            return (TorchServeEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTorchServeEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTorchServeEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface TorchServeBuilders {
        /**
         * TorchServe (camel-torchserve)
         * Provide access to PyTorch TorchServe servers to run inference with
         * PyTorch models remotely
         * 
         * Category: ai
         * Since: 4.9
         * Maven coordinates: org.apache.camel:camel-torchserve
         * 
         * @return the dsl builder for the headers' name.
         */
        default TorchServeHeaderNameBuilder torchserve() {
            return TorchServeHeaderNameBuilder.INSTANCE;
        }
        /**
         * TorchServe (camel-torchserve)
         * Provide access to PyTorch TorchServe servers to run inference with
         * PyTorch models remotely
         * 
         * Category: ai
         * Since: 4.9
         * Maven coordinates: org.apache.camel:camel-torchserve
         * 
         * Syntax: <code>torchserve:api/operation</code>
         * 
         * Path parameter: api (required)
         * The TorchServe API
         * There are 3 enums and the value can be one of: inference, management,
         * metrics
         * 
         * Path parameter: operation (required)
         * The API operation
         * There are 10 enums and the value can be one of: ping, predictions,
         * explanations, register, scale-worker, describe, unregister, list,
         * set-default, metrics
         * 
         * @param path api/operation
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder torchserve(String path) {
            return TorchServeEndpointBuilderFactory.endpointBuilder("torchserve", path);
        }
        /**
         * TorchServe (camel-torchserve)
         * Provide access to PyTorch TorchServe servers to run inference with
         * PyTorch models remotely
         * 
         * Category: ai
         * Since: 4.9
         * Maven coordinates: org.apache.camel:camel-torchserve
         * 
         * Syntax: <code>torchserve:api/operation</code>
         * 
         * Path parameter: api (required)
         * The TorchServe API
         * There are 3 enums and the value can be one of: inference, management,
         * metrics
         * 
         * Path parameter: operation (required)
         * The API operation
         * There are 10 enums and the value can be one of: ping, predictions,
         * explanations, register, scale-worker, describe, unregister, list,
         * set-default, metrics
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path api/operation
         * @return the dsl builder
         */
        default TorchServeEndpointBuilder torchserve(String componentName, String path) {
            return TorchServeEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the TorchServe component.
     */
    public static class TorchServeHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final TorchServeHeaderNameBuilder INSTANCE = new TorchServeHeaderNameBuilder();

        /**
         * The name of model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeModelName}.
         */
        public String torchServeModelName() {
            return "CamelTorchServeModelName";
        }
        /**
         * The version of model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeModelVersion}.
         */
        public String torchServeModelVersion() {
            return "CamelTorchServeModelVersion";
        }
        /**
         * Model archive download url, support local file or HTTP(s) protocol.
         * For S3, consider using pre-signed url.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeUrl}.
         */
        public String torchServeUrl() {
            return "CamelTorchServeUrl";
        }
        /**
         * Additional options for the register operation.
         * 
         * The option is a: {@code
         * org.apache.camel.component.torchserve.client.model.RegisterOptions}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeRegisterOptions}.
         */
        public String torchServeRegisterOptions() {
            return "CamelTorchServeRegisterOptions";
        }
        /**
         * Additional options for the scale-worker operation.
         * 
         * The option is a: {@code
         * org.apache.camel.component.torchserve.client.model.ScaleWorkerOptions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeScaleWorkerOptions}.
         */
        public String torchServeScaleWorkerOptions() {
            return "CamelTorchServeScaleWorkerOptions";
        }
        /**
         * Additional options for the unregister operation.
         * 
         * The option is a: {@code
         * org.apache.camel.component.torchserve.client.model.UnregisterOptions}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeUnrsegisterOptions}.
         */
        public String torchServeUnrsegisterOptions() {
            return "CamelTorchServeUnrsegisterOptions";
        }
        /**
         * The maximum number of items to return for the list operation. When
         * this value is present, TorchServe does not return more than the
         * specified number of items, but it might return fewer. This value is
         * optional. If you include a value, it must be between 1 and 1000,
         * inclusive. If you do not include a value, it defaults to 100.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeListLimit}.
         */
        public String torchServeListLimit() {
            return "CamelTorchServeListLimit";
        }
        /**
         * The token to retrieve the next set of results for the list operation.
         * TorchServe provides the token when the response from a previous call
         * has more results than the maximum page size.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeListNextPageToken}.
         */
        public String torchServeListNextPageToken() {
            return "CamelTorchServeListNextPageToken";
        }
        /**
         * Names of metrics to filter.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code TorchServeMetricsName}.
         */
        public String torchServeMetricsName() {
            return "CamelTorchServeMetricsName";
        }
    }
    static TorchServeEndpointBuilder endpointBuilder(String componentName, String path) {
        class TorchServeEndpointBuilderImpl extends AbstractEndpointBuilder implements TorchServeEndpointBuilder, AdvancedTorchServeEndpointBuilder {
            public TorchServeEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new TorchServeEndpointBuilderImpl(path);
    }
}