/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.builder;

import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.impl.builder.BuilderImpl;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilderSupport;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.builder.CustomBuilderManager;
import org.apache.axiom.om.impl.common.builder.Detachable;
import org.apache.axiom.om.impl.intf.AxiomDocument;

public class OMXMLParserWrapperImpl
implements OMXMLParserWrapper,
CustomBuilderSupport {
    private final BuilderImpl builder;
    private final Detachable detachable;
    private final CustomBuilderManager customBuilderManager = new CustomBuilderManager();

    public OMXMLParserWrapperImpl(BuilderImpl builder, Detachable detachable) {
        this.builder = builder;
        this.detachable = detachable;
        builder.setFacade(this);
        builder.addListener(this.customBuilderManager);
    }

    public final void registerCustomBuilder(CustomBuilder.Selector selector, CustomBuilder customBuilder) {
        this.customBuilderManager.register(selector, customBuilder);
    }

    public final boolean isCompleted() {
        return this.builder.isCompleted();
    }

    public final OMDocument getDocument() {
        try {
            return (AxiomDocument)this.builder.getDocument();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final OMElement getDocumentElement() {
        return this.getDocumentElement(false);
    }

    public final OMElement getDocumentElement(boolean discardDocument) {
        try {
            OMDocument document = this.getDocument();
            OMElement element = document.getOMDocumentElement();
            if (discardDocument) {
                element.detach();
                ((AxiomDocument)document).coreDiscard(false);
            }
            return element;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void close() {
        this.builder.close();
    }

    public final void detach() throws OMException {
        if (this.detachable != null) {
            this.detachable.detach();
        } else {
            try {
                while (!this.builder.isCompleted()) {
                    this.builder.next();
                }
            }
            catch (CoreModelException ex) {
                throw AxiomExceptionTranslator.translate(ex);
            }
        }
    }
}

