/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.receivers;

import java.util.Map;
import org.apache.axis2.corba.exceptions.CorbaInvocationException;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.receivers.CorbaInvoker;
import org.apache.axis2.corba.receivers.Invoker;
import org.apache.axis2.corba.receivers.InvokerFactory;
import org.omg.CORBA.Object;

public class CorbaInvokerFactory
implements InvokerFactory {
    private Map interfaces;

    public CorbaInvokerFactory(IDL idl) {
        this.interfaces = idl.getInterfaces();
    }

    @Override
    public Invoker newInvoker(String interfaceName, String operationName, Object object) throws CorbaInvocationException {
        Interface intf = (Interface)this.interfaces.get(interfaceName);
        if (intf == null) {
            throw new CorbaInvocationException("Interface " + interfaceName + " not found");
        }
        Map operations = intf.getOperationsMap();
        if (operations == null || operations.isEmpty()) {
            throw new CorbaInvocationException("Interface " + interfaceName + " does not have operations");
        }
        Operation operation = (Operation)operations.get(operationName);
        if (operation == null) {
            throw new CorbaInvocationException("Operation " + operationName + " not found in interface " + interfaceName);
        }
        return new CorbaInvoker(operation, intf, object);
    }
}

