#!/usr/bin/env bash
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

main() {
    touch curl_output.txt
    for wheel in "$@"
    do
        echo "==== Uploading $wheel"
        local response_code=$(curl \
                                  --silent \
                                  -o curl_output.txt \
                                  -w '%{http_code}' \
                                  -F "package=@${wheel}" \
                                  https://${GEMFURY_PUSH_TOKEN}@push.fury.io/arrow-adbc-nightlies/)
        cat curl_output.txt
        if [[ $response_code -eq 409 ]]; then
            # Ignore the failure, since we build 'none' wheels, we may have duplicate wheels across pipelines
            true
        elif [[ $response_code -ge 300 ]]; then
            exit 1
        fi
    done
}

main "$@"
