/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.ant.antunit.AntUnitExecutionNotifier;
import org.apache.ant.antunit.AssertionFailedException;
import org.apache.ant.antunit.junit3.AntUnitSuite;
import org.apache.ant.antunit.junit3.AntUnitTestCase;
import org.junit.internal.runners.InitializationError;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class AntUnitSuiteRunner
extends Runner
implements Filterable,
Sortable {
    private final AntUnitSuite junit3Suite;
    private final Map targetDescriptions = new HashMap();
    private final List targetsOrder = new LinkedList();

    private AntUnitSuiteRunner(AntUnitSuite suite, Class junitTestClass) throws InitializationError {
        this.junit3Suite = suite;
        if (suite.hasAntInitError()) {
            throw new InitializationError(new Throwable[]{suite.getAntInitialisationException()});
        }
        Enumeration tests = suite.tests();
        while (tests.hasMoreElements()) {
            TestCase nextTc = (TestCase)tests.nextElement();
            AntUnitTestCase tc = (AntUnitTestCase)nextTc;
            Description tc_desc = Description.createTestDescription((Class)junitTestClass, (String)tc.getName());
            this.targetDescriptions.put(tc.getTarget(), tc_desc);
            this.targetsOrder.add(tc.getTarget());
        }
    }

    public AntUnitSuiteRunner(Class testCaseClass) throws InitializationError {
        this(AntUnitSuiteRunner.getJUnit3AntSuite(testCaseClass), testCaseClass);
    }

    private static AntUnitSuite getJUnit3AntSuite(Class testCaseClass) throws InitializationError {
        try {
            Method suiteMethod = testCaseClass.getMethod("suite", new Class[0]);
            if (!Modifier.isStatic(suiteMethod.getModifiers())) {
                throw new InitializationError("suite method must be static");
            }
            Object suite = suiteMethod.invoke(null, new Object[0]);
            if (suite == null) {
                throw new InitializationError("suite method can not return null");
            }
            if (!(suite instanceof AntUnitSuite)) {
                throw new InitializationError("suite method must return an AntUnitSuite");
            }
            return (AntUnitSuite)((Object)suite);
        }
        catch (NoSuchMethodException e) {
            throw new InitializationError(new Throwable[]{e});
        }
        catch (IllegalAccessException e) {
            throw new InitializationError(new Throwable[]{e});
        }
        catch (InvocationTargetException e) {
            throw new InitializationError(new Throwable[]{e});
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator iter = this.targetDescriptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            if (!filter.shouldRun((Description)mapEntry.getValue())) {
                iter.remove();
            }
            this.targetsOrder.remove(mapEntry.getKey());
        }
    }

    public void sort(final Sorter sorter) {
        Collections.sort(this.targetsOrder, new Comparator(){

            public int compare(Object target1, Object target2) {
                Description d2 = (Description)AntUnitSuiteRunner.this.targetDescriptions.get(target2);
                Description d1 = (Description)AntUnitSuiteRunner.this.targetDescriptions.get(target1);
                return sorter.compare(d1, d2);
            }
        });
    }

    public Description getDescription() {
        Description r = Description.createSuiteDescription((String)this.junit3Suite.getName(), (Annotation[])new Annotation[0]);
        Collection childDesc = this.targetDescriptions.values();
        Iterator iterator = childDesc.iterator();
        while (iterator.hasNext()) {
            Description desc = (Description)iterator.next();
            r.addChild(desc);
        }
        return r;
    }

    public void run(final RunNotifier junitNotifier) {
        LinkedList targetList = new LinkedList(this.targetDescriptions.keySet());
        AntUnitExecutionNotifier antUnitNotifier = new AntUnitExecutionNotifier(){

            public void fireStartTest(String targetName) {
                junitNotifier.fireTestStarted(this.getDescription(targetName));
            }

            public void fireEndTest(String targetName) {
                junitNotifier.fireTestFinished(this.getDescription(targetName));
            }

            public void fireError(String targetName, Throwable t) {
                Failure failure = new Failure(this.getDescription(targetName), t);
                junitNotifier.fireTestFailure(failure);
            }

            public void fireFail(String targetName, AssertionFailedException ae) {
                Failure failure = new Failure(this.getDescription(targetName), (Throwable)((Object)ae));
                junitNotifier.fireTestFailure(failure);
            }

            private Description getDescription(String targetName) {
                return (Description)AntUnitSuiteRunner.this.targetDescriptions.get(targetName);
            }
        };
        this.junit3Suite.runInContainer(targetList, antUnitNotifier);
    }
}

