/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class DefaultCompactionStrategy
extends CompactionStrategy {
    @Override
    public boolean shouldCompact(MajorCompactionRequest request) {
        CompactionPlan plan = this.getCompactionPlan(request);
        return plan != null && !plan.inputFiles.isEmpty();
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        CompactionPlan result = new CompactionPlan();
        List<StoredTabletFile> toCompact = this.findMapFilesToCompact(request);
        if (toCompact == null || toCompact.isEmpty()) {
            return result;
        }
        result.inputFiles.addAll(toCompact);
        return result;
    }

    private List<StoredTabletFile> findMapFilesToCompact(MajorCompactionRequest request) {
        MajorCompactionReason reason = request.getReason();
        if (reason == MajorCompactionReason.USER) {
            return new ArrayList<StoredTabletFile>(request.getFiles().keySet());
        }
        if (reason == MajorCompactionReason.CHOP) {
            return new ArrayList<StoredTabletFile>(request.getFiles().keySet());
        }
        if (request.getFiles().size() <= 1) {
            return null;
        }
        double ratio = Double.parseDouble(request.getTableConfig(Property.TABLE_MAJC_RATIO.getKey()));
        int maxFilesToCompact = Integer.parseInt(request.getTableConfig(Property.TSERV_MAJC_THREAD_MAXOPEN.getKey()));
        int maxFilesPerTablet = request.getMaxFilesPerTablet();
        int minFilesToCompact = 0;
        if (request.getFiles().size() > maxFilesPerTablet) {
            minFilesToCompact = request.getFiles().size() - maxFilesPerTablet + 1;
        }
        minFilesToCompact = Math.min(minFilesToCompact, maxFilesToCompact);
        SizeWindow all = new SizeWindow(request.getFiles());
        List<StoredTabletFile> files = null;
        SizeWindow window = all.tail(maxFilesToCompact);
        while (window.size() > 1 && files == null) {
            if ((double)window.topSize() * ratio <= (double)window.sum()) {
                files = window.getFiles();
            }
            window.pop();
        }
        if (files == null || files.size() < minFilesToCompact) {
            window = all.tail(maxFilesToCompact);
            files = null;
            while (window.slideUp() && files == null) {
                if (!((double)window.topSize() * ratio <= (double)window.sum())) continue;
                files = window.getFiles();
            }
        }
        if (files != null && files.size() < minFilesToCompact || files == null && minFilesToCompact > 0) {
            files = all.tail(minFilesToCompact).getFiles();
        }
        return files;
    }

    @VisibleForTesting
    static class SizeWindow {
        List<CompactionFile> files;
        long sum = 0L;
        int first;
        int last;

        SizeWindow() {
        }

        SizeWindow(Map<StoredTabletFile, DataFileValue> allFiles) {
            this.files = new ArrayList<CompactionFile>();
            for (Map.Entry<StoredTabletFile, DataFileValue> entry : allFiles.entrySet()) {
                this.files.add(new CompactionFile(entry.getKey(), entry.getValue().getSize()));
            }
            this.files.sort(Comparator.comparingLong(CompactionFile::getSize).thenComparing(CompactionFile::getFile).reversed());
            for (CompactionFile file : this.files) {
                this.sum += file.size;
            }
            this.first = 0;
            this.last = this.files.size();
        }

        void pop() {
            if (this.first >= this.last) {
                throw new IllegalStateException("Can not pop");
            }
            this.sum -= this.files.get((int)this.first).size;
            ++this.first;
        }

        long topSize() {
            return this.files.get((int)this.first).size;
        }

        boolean slideUp() {
            if (this.first == 0) {
                return false;
            }
            --this.first;
            --this.last;
            this.sum += this.files.get((int)this.first).size;
            this.sum -= this.files.get((int)this.last).size;
            return true;
        }

        SizeWindow tail(int windowSize) {
            Preconditions.checkArgument((windowSize > 0 ? 1 : 0) != 0);
            SizeWindow sub = new SizeWindow();
            sub.files = this.files;
            sub.first = Math.max(this.last - windowSize, this.first);
            sub.last = this.last;
            sub.sum = 0L;
            for (int i = sub.first; i < sub.last; ++i) {
                sub.sum += this.files.get((int)i).size;
            }
            return sub;
        }

        long sum() {
            return this.sum;
        }

        int size() {
            return this.last - this.first;
        }

        public List<StoredTabletFile> getFiles() {
            ArrayList<StoredTabletFile> windowFiles = new ArrayList<StoredTabletFile>(this.size());
            for (int i = this.first; i < this.last; ++i) {
                windowFiles.add(this.files.get((int)i).file);
            }
            return windowFiles;
        }

        public String toString() {
            return "size:" + this.size() + " sum:" + this.sum() + " first:" + this.first + " last:" + this.last + " topSize:" + this.topSize();
        }
    }

    private static class CompactionFile {
        public StoredTabletFile file;
        public long size;

        public CompactionFile(StoredTabletFile file, long size) {
            this.file = file;
            this.size = size;
        }

        long getSize() {
            return this.size;
        }

        TabletFile getFile() {
            return this.file;
        }
    }
}

