/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.Dimen;
import nts.base.Glue;
import nts.base.Num;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.InpTokChecker;
import nts.command.Primitive;
import nts.command.ScanToksChecker;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.Log;
import nts.io.Loggable;

public abstract class Prim
extends Command
implements Primitive {
    public static final int ADVANCE = 0;
    public static final int MULTIPLY = 1;
    public static final int DIVIDE = 2;
    public static final int INTP_MAX_REG_CODE = CommandBase.newIntParam();
    public static final int INTP_MAX_FILE_CODE = CommandBase.newIntParam();
    public static final int INTP_MAX_CHAR_CODE = CommandBase.newIntParam();
    private String name;

    public final String getName() {
        return this.name;
    }

    public final Command getCommand() {
        return this;
    }

    public final void addOn(Log log) {
        log.addEsc(this.name);
    }

    public final String toString() {
        return "@" + this.name;
    }

    protected static Num performFor(Num val, int operation) {
        CommandBase.scanKeyword("by");
        int i = CommandBase.scanInt();
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(i);
                    break;
                }
                case 1: {
                    val = val.times(i);
                    break;
                }
                case 2: {
                    val = val.over(i);
                    break;
                }
            }
        }
        catch (ArithmeticException e) {
            val = Num.ZERO;
            CommandBase.error("ArithOverflow");
        }
        return val;
    }

    protected static Dimen performFor(Dimen val, int operation) {
        CommandBase.scanKeyword("by");
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(CommandBase.scanDimen());
                    break;
                }
                case 1: {
                    val = val.times(CommandBase.scanInt());
                    break;
                }
                case 2: {
                    val = val.over(CommandBase.scanInt());
                    break;
                }
            }
        }
        catch (ArithmeticException e) {
            val = Dimen.ZERO;
            CommandBase.error("ArithOverflow");
        }
        return val;
    }

    protected static Glue performFor(Glue val, int operation, boolean mu) {
        CommandBase.scanKeyword("by");
        try {
            switch (operation) {
                case 0: {
                    val = val.plus(CommandBase.scanGlue(mu));
                    break;
                }
                case 1: {
                    val = val.times(CommandBase.scanInt());
                    break;
                }
                case 2: {
                    val = val.over(CommandBase.scanInt());
                    break;
                }
            }
        }
        catch (ArithmeticException e) {
            val = Glue.ZERO;
            CommandBase.error("ArithOverflow");
        }
        return val;
    }

    public static int scanAnyCode(int par, String err) {
        int max = CommandBase.getConfig().getIntParam(par);
        int i = CommandBase.scanInt();
        if (i < 0 || i > max) {
            CommandBase.error(err, CommandBase.num(i), CommandBase.num(0), CommandBase.num(max));
            return 0;
        }
        return i;
    }

    public static int scanRegisterCode() {
        return Prim.scanAnyCode(INTP_MAX_REG_CODE, "BadRegister");
    }

    public static int scanFileCode() {
        return Prim.scanAnyCode(INTP_MAX_FILE_CODE, "BadFileNum");
    }

    public static int scanCharacterCode() {
        return Prim.scanAnyCode(INTP_MAX_CHAR_CODE, "BadCharCode");
    }

    public static TokenList scanTokenList(Loggable src, boolean xpand) {
        TokenList.Buffer buf = new TokenList.Buffer(30);
        InpTokChecker savedChk = CommandBase.setTokenChecker(new ScanToksChecker("OuterInToks", "EOFinToks", "text", buf, src));
        CommandBase.scanLeftBrace();
        int balance = 1;
        while (true) {
            Token tok;
            if ((tok = Prim.nextScannedToken(xpand, buf)) == null) {
                continue;
            }
            if (tok.matchLeftBrace()) {
                ++balance;
            } else if (tok.matchRightBrace() && --balance == 0) break;
            buf.append(tok);
        }
        CommandBase.setTokenChecker(savedChk);
        return buf.toTokenList();
    }

    public static Token nextScannedToken(boolean xpand, TokenList.Buffer buf) {
        return xpand ? CommandBase.nextExpToken(buf) : CommandBase.nextRawToken();
    }

    protected Prim(String name) {
        this.name = name;
    }
}

