/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public TeeOutputStream(OutputStream ... outputStreams) {
        this.streams = outputStreams;
    }

    public void write(int b) throws IOException {
        for (OutputStream ostream : this.streams) {
            ostream.write(b);
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        for (OutputStream ostream : this.streams) {
            ostream.write(b, offset, length);
        }
    }

    public void flush() throws IOException {
        for (OutputStream ostream : this.streams) {
            ostream.flush();
        }
    }

    public void close() throws IOException {
        for (OutputStream ostream : this.streams) {
            this.forceClose(ostream);
        }
    }

    private void forceClose(OutputStream ostream) {
        try {
            ostream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

