# gc_random.m4 serial 1
# Copyright (C) 2004 Simon Josefsson
#
# This file is free software, distributed under the terms of the GNU
# General Public License.  As a special exception to the GNU General
# Public License, this file may be distributed as part of a program
# that contains a configuration script generated by Autoconf, under
# the same distribution terms as the rest of that program.

# Usage: GC_RANDOM
AC_DEFUN([GC_RANDOM],
[
  AC_REQUIRE([AC_CANONICAL_TARGET])

  # Devices with randomness.
  # FIXME: Are these the best defaults?
  case "${target}" in
    *-openbsd*)
	NAME_OF_RANDOM_DEVICE="/dev/srandom"
	NAME_OF_PSEUDO_RANDOM_DEVICE="/dev/prandom"
	NAME_OF_NONCE_DEVICE="/dev/urandom"
        ;;

    *-netbsd*)
	NAME_OF_RANDOM_DEVICE="/dev/srandom"
	NAME_OF_PSEUDO_RANDOM_DEVICE="/dev/urandom"
	NAME_OF_NONCE_DEVICE="/dev/urandom"
        ;;

    *-solaris* | *-irix* | *-dec-osf* )
	NAME_OF_RANDOM_DEVICE="/dev/random"
	NAME_OF_PSEUDO_RANDOM_DEVICE="/dev/random"
	NAME_OF_NONCE_DEVICE="/dev/random"
        ;;

    *)
	NAME_OF_RANDOM_DEVICE="/dev/random"
	NAME_OF_PSEUDO_RANDOM_DEVICE="/dev/urandom"
	NAME_OF_NONCE_DEVICE="/dev/urandom"
        ;;
  esac

  AC_MSG_CHECKING([device with (strong) random data...])
  AC_ARG_ENABLE(random-device,
	AC_HELP_STRING([--enable-random-device],
		[device with (strong) randomness (for Nettle)]),
	NAME_OF_RANDOM_DEVICE=$enableval)
  AC_MSG_RESULT($NAME_OF_RANDOM_DEVICE)

  AC_MSG_CHECKING([device with pseudo random data...])
  AC_ARG_ENABLE(pseudo-random-device,
	AC_HELP_STRING([--enable-pseudo-random-device],
		[device with pseudo randomness (for Nettle)]),
	NAME_OF_PSEUDO_RANDOM_DEVICE=$enableval)
  AC_MSG_RESULT($NAME_OF_PSEUDO_RANDOM_DEVICE)

  AC_MSG_CHECKING([device with unpredictable data for nonces...])
  AC_ARG_ENABLE(nonce-device,
	AC_HELP_STRING([--enable-nonce-device],
		[device with unpredictable nonces (for Nettle)]),
	NAME_OF_NONCE_DEVICE=$enableval)
  AC_MSG_RESULT($NAME_OF_NONCE_DEVICE)

  AC_CHECK_FILE($NAME_OF_RANDOM_DEVICE,, AC_MSG_ERROR([[
*** Device for (strong) random data $NAME_OF_RANDOM_DEVICE does not exist
]]))
  AC_CHECK_FILE($NAME_OF_PSEUDO_RANDOM_DEVICE,, AC_MSG_ERROR([[
*** Device for pseudo-random data $NAME_OF_PSEUDO_RANDOM_DEVICE does not exist
]]))
  AC_CHECK_FILE($NAME_OF_NONCE_DEVICE,, AC_MSG_ERROR([[
*** Device for unpredictable nonces $NAME_OF_NONCE_DEVICE does not exist
]]))

  # FIXME: Open+read 42 bytes+close twice and compare data.  Should differ.

  AC_DEFINE_UNQUOTED(NAME_OF_RANDOM_DEVICE, "$NAME_OF_RANDOM_DEVICE",
                   [defined to the name of the (strong) random device])
  AC_DEFINE_UNQUOTED(NAME_OF_PSEUDO_RANDOM_DEVICE,
			 "$NAME_OF_PSEUDO_RANDOM_DEVICE",
                   [defined to the name of the pseudo random device])
  AC_DEFINE_UNQUOTED(NAME_OF_NONCE_DEVICE, "$NAME_OF_NONCE_DEVICE",
                   [defined to the name of the unpredictable nonce device])
])
