/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.cipher;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.cipher.IBlockCipherSpi;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseCipher
implements IBlockCipher,
IBlockCipherSpi {
    protected String name;
    protected int defaultBlockSize;
    protected int defaultKeySize;
    protected int currentBlockSize;
    protected transient Object currentKey;
    protected Object lock;

    private /* synthetic */ void finit$() {
        this.lock = new Object();
    }

    protected BaseCipher(String name, int defaultBlockSize, int defaultKeySize) {
        this.finit$();
        this.name = name;
        this.defaultBlockSize = defaultBlockSize;
        this.defaultKeySize = defaultKeySize;
    }

    public abstract Object clone();

    public String name() {
        StringBuffer sb = new StringBuffer(this.name).append('-');
        if (this.currentKey == null) {
            sb.append(String.valueOf(8 * this.defaultBlockSize));
        } else {
            sb.append(String.valueOf(8 * this.currentBlockSize));
        }
        return sb.toString();
    }

    public int defaultBlockSize() {
        return this.defaultBlockSize;
    }

    public int defaultKeySize() {
        return this.defaultKeySize;
    }

    public void init(Map attributes) throws InvalidKeyException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.currentKey != null) {
                    throw new IllegalStateException();
                }
                Integer bs = (Integer)attributes.get("gnu.crypto.cipher.block.size");
                if (bs == null) {
                    if (this.currentBlockSize == 0) {
                        this.currentBlockSize = this.defaultBlockSize;
                    }
                } else {
                    this.currentBlockSize = bs;
                    boolean ok = false;
                    Iterator it = this.blockSizes();
                    while (it.hasNext() && !(ok = this.currentBlockSize == (Integer)it.next())) {
                    }
                    if (!ok) {
                        throw new IllegalArgumentException("gnu.crypto.cipher.block.size");
                    }
                }
                byte[] k = (byte[])attributes.get("gnu.crypto.cipher.key.material");
                this.currentKey = this.makeKey(k, this.currentBlockSize);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public int currentBlockSize() {
        if (this.currentKey == null) {
            throw new IllegalStateException();
        }
        return this.currentBlockSize;
    }

    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.currentKey = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void encryptBlock(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.currentKey == null) {
                    throw new IllegalStateException();
                }
                this.encrypt(in, inOffset, out, outOffset, this.currentKey, this.currentBlockSize);
            }
            finally {
                Object var6_6 = null;
            }
            return;
        }
    }

    public void decryptBlock(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.currentKey == null) {
                    throw new IllegalStateException();
                }
                this.decrypt(in, inOffset, out, outOffset, this.currentKey, this.currentBlockSize);
            }
            finally {
                Object var6_6 = null;
            }
            return;
        }
    }

    public boolean selfTest() {
        Iterator kit = this.keySizes();
        while (kit.hasNext()) {
            int ks = (Integer)kit.next();
            Iterator bit = this.blockSizes();
            while (bit.hasNext()) {
                if (this.testSymmetry(ks, (Integer)bit.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean testSymmetry(int ks, int bs) {
        try {
            int i;
            byte[] kb = new byte[ks];
            byte[] pt = new byte[bs];
            byte[] ct = new byte[bs];
            byte[] cpt = new byte[bs];
            for (i = 0; i < ks; ++i) {
                kb[i] = (byte)i;
            }
            for (i = 0; i < bs; ++i) {
                pt[i] = (byte)i;
            }
            Object k = this.makeKey(kb, bs);
            this.encrypt(pt, 0, ct, 0, k, bs);
            this.decrypt(ct, 0, cpt, 0, k, bs);
            return Arrays.equals(pt, cpt);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }

    protected boolean testKat(byte[] kb, byte[] ct) {
        return this.testKat(kb, ct, new byte[ct.length]);
    }

    protected boolean testKat(byte[] kb, byte[] ct, byte[] pt) {
        try {
            int bs = pt.length;
            byte[] t = new byte[bs];
            Object k = this.makeKey(kb, bs);
            this.encrypt(pt, 0, t, 0, k, bs);
            if (!Arrays.equals(t, ct)) {
                return false;
            }
            this.decrypt(t, 0, t, 0, k, bs);
            return Arrays.equals(t, pt);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }
}

