/*
 * Decompiled with CFR 0.152.
 */
package test.sig.rsa;

import gnu.crypto.sig.rsa.GnuRSAPrivateKey;
import gnu.crypto.sig.rsa.GnuRSAPublicKey;
import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.sig.rsa.RSAKeyPairRawCodec;
import gnu.crypto.sig.rsa.RSAPSSSignature;
import gnu.crypto.sig.rsa.RSAPSSSignatureRawCodec;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfRSACodec
extends TestCase {
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private RSAPublicKey pubK;
    private RSAPrivateKey secK;
    static /* synthetic */ Class class$test$sig$rsa$TestOfRSACodec;

    public TestOfRSACodec(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfRSACodec.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$sig$rsa$TestOfRSACodec == null ? (class$test$sig$rsa$TestOfRSACodec = TestOfRSACodec.class$("test.sig.rsa.TestOfRSACodec")) : class$test$sig$rsa$TestOfRSACodec);
    }

    public void testKeyPairRawCodec() {
        byte[] pk1;
        try {
            pk1 = ((GnuRSAPublicKey)this.pubK).getEncoded(0);
            Assert.fail((String)"Succeeded with unknown format ID");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"Recognised unknown format ID", (boolean)true);
        }
        pk1 = ((GnuRSAPublicKey)this.pubK).getEncoded(1);
        byte[] pk2 = ((GnuRSAPrivateKey)this.secK).getEncoded(1);
        RSAKeyPairRawCodec codec = new RSAKeyPairRawCodec();
        PublicKey newPubK = codec.decodePublicKey(pk1);
        PrivateKey newSecK = codec.decodePrivateKey(pk2);
        Assert.assertTrue((String)"RSA public key Raw encoder/decoder test", (boolean)this.pubK.equals(newPubK));
        Assert.assertTrue((String)"RSA private key Raw encoder/decoder test", (boolean)this.secK.equals(newSecK));
    }

    public void testSignatureRawCodec() {
        RSAPSSSignature alice = new RSAPSSSignature();
        RSAPSSSignature bob = (RSAPSSSignature)alice.clone();
        byte[] message = "1 if by land, 2 if by sea...".getBytes();
        HashMap<String, Key> map = new HashMap<String, Key>();
        map.put("gnu.crypto.sig.private.key", this.secK);
        alice.setupSign(map);
        alice.update(message, 0, message.length);
        Object signature = alice.sign();
        RSAPSSSignatureRawCodec codec = new RSAPSSSignatureRawCodec();
        byte[] encodedSignature = codec.encodeSignature(signature);
        Object decodedSignature = codec.decodeSignature(encodedSignature);
        map.put("gnu.crypto.sig.public.key", this.pubK);
        bob.setupVerify(map);
        bob.update(message, 0, message.length);
        Assert.assertTrue((String)"RSA-PSS signature Raw encoder/decoder test", (boolean)bob.verify(decodedSignature));
    }

    protected void setUp() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("gnu.crypto.rsa.L", new Integer(1024));
        this.kpg.setup(map);
        KeyPair kp = this.kpg.generate();
        this.pubK = (RSAPublicKey)kp.getPublic();
        this.secK = (RSAPrivateKey)kp.getPrivate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

