/*
 * Decompiled with CFR 0.152.
 */
package test.jce;

import gnu.crypto.jce.GnuCrypto;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfProvider
extends TestCase {
    static /* synthetic */ Class class$test$jce$TestOfProvider;

    public TestOfProvider(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfProvider.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$jce$TestOfProvider == null ? (class$test$jce$TestOfProvider = TestOfProvider.class$("test.jce.TestOfProvider")) : class$test$jce$TestOfProvider);
    }

    public void testProviderName() {
        Provider us = Security.getProvider("GNU-CRYPTO");
        Assert.assertTrue((String)"testProviderName()", (boolean)"GNU-CRYPTO".equals(us.getName()));
    }

    public void testSha() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA", "GNU-CRYPTO");
            Assert.assertNotNull((String)"testSha()", (Object)md);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            Assert.fail((String)"testSha()");
        }
    }

    public void testWhirlpool() {
        try {
            MessageDigest md = MessageDigest.getInstance("Whirlpool", "GNU-CRYPTO");
            Assert.assertNotNull((String)"testWhirlpool()", (Object)md);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            Assert.fail((String)"testWhirlpool()");
        }
    }

    public void testShaPRNG() {
        try {
            SecureRandom rnd = SecureRandom.getInstance("SHA1PRNG", "GNU-CRYPTO");
            Assert.assertNotNull((String)"testShaPRNG()", (Object)rnd);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            Assert.fail((String)"testShaPRNG()");
        }
    }

    public void testWhirlpoolPRNG() {
        try {
            SecureRandom rnd = SecureRandom.getInstance("WHIRLPOOLPRNG", "GNU-CRYPTO");
            Assert.assertNotNull((String)"testWhirlpoolPRNG()", (Object)rnd);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            Assert.fail((String)"testWhirlpoolPRNG()");
        }
    }

    public void testGNUSecureRandoms() {
        Iterator it = GnuCrypto.getSecureRandomNames().iterator();
        while (it.hasNext()) {
            String rand = (String)it.next();
            try {
                SecureRandom algorithm = null;
                algorithm = SecureRandom.getInstance(rand, "GNU-CRYPTO");
                Assert.assertNotNull((String)("getInstance(" + String.valueOf(rand) + ")"), (Object)algorithm);
            }
            catch (NoSuchProviderException x) {
                Assert.fail((String)("getInstance(" + String.valueOf(rand) + "): " + String.valueOf(x)));
            }
            catch (NoSuchAlgorithmException x) {
                Assert.fail((String)("getInstance(" + String.valueOf(rand) + "): " + String.valueOf(x)));
            }
        }
    }

    protected void setUp() {
        Security.addProvider((Provider)new GnuCrypto());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

