dnl aclocal.m4 generated automatically by aclocal 1.4a

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
dnl We require 2.13 because we rely on SHELL being computed by configure.
AC_PREREQ([2.13])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
dnl Set install_sh for make dist
install_sh="$missing_dir/install-sh"
test -f "$install_sh" || install_sh="$missing_dir/install.sh"
AC_SUBST(install_sh)
dnl We check for tar when the user configures the end package.
dnl This is sad, since we only need this for "dist".  However,
dnl there's no other good way to do it.  We prefer GNU tar if
dnl we can find it.  If we can't find a tar, it doesn't really matter.
AC_CHECK_PROGS(AMTAR, gnutar gtar tar)
dnl We need awk for the "check" target.  The system "awk" is bad on
dnl some platforms.
AC_REQUIRE([AC_PROG_AWK])
AMTARFLAGS=
if test -n "$AMTAR"; then
  if $SHELL -c "$AMTAR --version" > /dev/null 2>&1; then
    dnl We have GNU tar.
    AMTARFLAGS=o
  fi
fi
AC_SUBST(AMTARFLAGS)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

AC_DEFUN(md_SWARM_INSTALLER,
[changequote(,)
install_prog=`echo $INSTALL | sed 's,.*/\([^/ ][^/ ]*\).*,\1,'`
install_prog_args=`echo $INSTALL | sed 's,.* \(.*\),\1,'`
install_data_args=`echo $INSTALL_DATA | sed 's,[^ ]* \(.*\),\1,'`
changequote([,])

SWARM_INSTALL=$install_prog
if test $install_prog = install-sh; then
  SWARM_INSTALL_PROGRAM='${swarm_bindir}'"/$install_prog $install_prog_args"
  SWARM_INSTALL_DATA_='${swarm_bindir}'"/$install_prog $install_prog_args $install_data_args"
else
  SWARM_INSTALL_PROGRAM=$INSTALL_PROGRAM
  SWARM_INSTALL_DATA_=$INSTALL_DATA
fi
AC_SUBST(SWARM_INSTALL)
AC_SUBST(SWARM_INSTALL_PROGRAM)
dnl avoid automake naming convention
AC_SUBST(SWARM_INSTALL_DATA_)
])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])


# serial 36 AC_PROG_LIBTOOL
AC_DEFUN(AC_PROG_LIBTOOL,
[AC_REQUIRE([AC_LIBTOOL_SETUP])dnl

# Save cache, so that ltconfig can load it
AC_CACHE_SAVE

# Actually configure libtool.  ac_aux_dir is where install-sh is found.
CC="$CC" CFLAGS="$CFLAGS" CPPFLAGS="$CPPFLAGS" \
LD="$LD" LDFLAGS="$LDFLAGS" LIBS="$LIBS" LN_S="$LN_S" \
NM="$NM" RANLIB="$RANLIB" DLLTOOL="$DLLTOOL" AS="$AS" \
${CONFIG_SHELL-/bin/sh} $ac_aux_dir/ltconfig --no-reexec \
$libtool_flags --no-verify $ac_aux_dir/ltmain.sh $host \
|| AC_MSG_ERROR([libtool configure failed])

# Reload cache, that may have been modified by ltconfig
AC_CACHE_LOAD

# This can be used to rebuild libtool when needed
LIBTOOL_DEPS="$ac_aux_dir/ltconfig $ac_aux_dir/ltmain.sh"

# Always use our own libtool.
LIBTOOL='$(SHELL) $(top_builddir)/libtool'
AC_SUBST(LIBTOOL)dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

AC_DEFUN(AC_LIBTOOL_SETUP,
[AC_PREREQ(2.13)dnl
AC_REQUIRE([AC_ENABLE_SHARED])dnl
AC_REQUIRE([AC_ENABLE_STATIC])dnl
AC_REQUIRE([AC_ENABLE_FAST_INSTALL])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
AC_REQUIRE([AC_PROG_RANLIB])dnl
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_PROG_LD])dnl
AC_REQUIRE([AC_PROG_NM])dnl
AC_REQUIRE([AC_PROG_LN_S])dnl
dnl

# Check for any special flags to pass to ltconfig.
libtool_flags="--cache-file=$cache_file"
test "$enable_shared" = no && libtool_flags="$libtool_flags --disable-shared"
test "$enable_static" = no && libtool_flags="$libtool_flags --disable-static"
test "$enable_fast_install" = no && libtool_flags="$libtool_flags --disable-fast-install"
test "$ac_cv_prog_gcc" = yes && libtool_flags="$libtool_flags --with-gcc"
test "$ac_cv_prog_gnu_ld" = yes && libtool_flags="$libtool_flags --with-gnu-ld"
test x"$lt_dlopen" = xyes && libtool_flags="$libtool_flags --enable-dlopen"
test x"$silent" = xyes && libtool_flags="$libtool_flags --silent"

# Some flags need to be propagated to the compiler or linker for good
# libtool support.
case "$host" in
*-*-irix6*)
  # Find out which ABI we are using.
  echo '[#]line __oline__ "configure"' > conftest.$ac_ext
  if AC_TRY_EVAL(ac_compile); then
    case "`/usr/bin/file conftest.o`" in
    *32-bit*)
      LD="${LD-ld} -32"
      ;;
    *N32*)
      LD="${LD-ld} -n32"
      ;;
    *64-bit*)
      LD="${LD-ld} -64"
      ;;
    esac
  fi
  rm -rf conftest*
  ;;

*-*-sco3.2v5*)
  # On SCO OpenServer 5, we need -belf to get full-featured binaries.
  SAVE_CFLAGS="$CFLAGS"
  CFLAGS="$CFLAGS -belf"
  AC_CACHE_CHECK([whether the C compiler needs -belf], lt_cv_cc_needs_belf,
    [AC_TRY_LINK([],[],[lt_cv_cc_needs_belf=yes],[lt_cv_cc_needs_belf=no])])
  if test x"$lt_cv_cc_needs_belf" != x"yes"; then
    # this is probably gcc 2.8.0, egcs 1.0 or newer; no need for -belf
    CFLAGS="$SAVE_CFLAGS"
  fi
  ;;

*-*-cygwin*)
  AC_CHECK_TOOL(DLLTOOL, dlltool, false)
  AC_CHECK_TOOL(AS, as, false)
  ;;

esac

# enable the --disable-libtool-lock switch

AC_ARG_ENABLE(libtool-lock,
[  --disable-libtool-lock  force libtool not to do file locking],
need_locks=$enableval,
need_locks=yes)

if test x"$need_locks" = xno; then
  libtool_flags="$libtool_flags --disable-lock"
fi
])

# AC_LIBTOOL_DLOPEN - enable checks for dlopen support
AC_DEFUN(AC_LIBTOOL_DLOPEN, [lt_dlopen=yes])

# AC_ENABLE_SHARED - implement the --enable-shared flag
# Usage: AC_ENABLE_SHARED[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_SHARED,
[define([AC_ENABLE_SHARED_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(shared,
changequote(<<, >>)dnl
<<  --enable-shared[=PKGS]  build shared libraries [default=>>AC_ENABLE_SHARED_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_shared=yes ;;
no) enable_shared=no ;;
*)
  enable_shared=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_shared=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_shared=AC_ENABLE_SHARED_DEFAULT)dnl
])

# AC_DISABLE_SHARED - set the default shared flag to --disable-shared
AC_DEFUN(AC_DISABLE_SHARED,
[AC_ENABLE_SHARED(no)])

# AC_ENABLE_STATIC - implement the --enable-static flag
# Usage: AC_ENABLE_STATIC[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_STATIC,
[define([AC_ENABLE_STATIC_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(static,
changequote(<<, >>)dnl
<<  --enable-static[=PKGS]  build static libraries [default=>>AC_ENABLE_STATIC_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_static=yes ;;
no) enable_static=no ;;
*)
  enable_static=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_static=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_static=AC_ENABLE_STATIC_DEFAULT)dnl
])

# AC_DISABLE_STATIC - set the default static flag to --disable-static
AC_DEFUN(AC_DISABLE_STATIC,
[AC_ENABLE_STATIC(no)])


# AC_ENABLE_FAST_INSTALL - implement the --enable-fast-install flag
# Usage: AC_ENABLE_FAST_INSTALL[(DEFAULT)]
#   Where DEFAULT is either `yes' or `no'.  If omitted, it defaults to
#   `yes'.
AC_DEFUN(AC_ENABLE_FAST_INSTALL,
[define([AC_ENABLE_FAST_INSTALL_DEFAULT], ifelse($1, no, no, yes))dnl
AC_ARG_ENABLE(fast-install,
changequote(<<, >>)dnl
<<  --enable-fast-install[=PKGS]  optimize for fast installation [default=>>AC_ENABLE_FAST_INSTALL_DEFAULT],
changequote([, ])dnl
[p=${PACKAGE-default}
case "$enableval" in
yes) enable_fast_install=yes ;;
no) enable_fast_install=no ;;
*)
  enable_fast_install=no
  # Look at the argument we got.  We use all the common list separators.
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:,"
  for pkg in $enableval; do
    if test "X$pkg" = "X$p"; then
      enable_fast_install=yes
    fi
  done
  IFS="$ac_save_ifs"
  ;;
esac],
enable_fast_install=AC_ENABLE_FAST_INSTALL_DEFAULT)dnl
])

# AC_ENABLE_FAST_INSTALL - set the default to --disable-fast-install
AC_DEFUN(AC_DISABLE_FAST_INSTALL,
[AC_ENABLE_FAST_INSTALL(no)])


# AC_PROG_LD - find the path to the GNU or non-GNU linker
AC_DEFUN(AC_PROG_LD,
[AC_ARG_WITH(gnu-ld,
[  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]],
test "$withval" = no || with_gnu_ld=yes, with_gnu_ld=no)
AC_REQUIRE([AC_PROG_CC])dnl
AC_REQUIRE([AC_CANONICAL_HOST])dnl
AC_REQUIRE([AC_CANONICAL_BUILD])dnl
ac_prog=ld
if test "$ac_cv_prog_gcc" = yes; then
  # Check if gcc -print-prog-name=ld gives a path.
  AC_MSG_CHECKING([for ld used by GCC])
  ac_prog=`($CC -print-prog-name=ld) 2>&5`
  case "$ac_prog" in
    # Accept absolute paths.
changequote(,)dnl
    [\\/]* | [A-Za-z]:[\\/]*)
      re_direlt='/[^/][^/]*/\.\./'
changequote([,])dnl
      # Canonicalize the path of ld
      ac_prog=`echo $ac_prog| sed 's%\\\\%/%g'`
      while echo $ac_prog | grep "$re_direlt" > /dev/null 2>&1; do
	ac_prog=`echo $ac_prog| sed "s%$re_direlt%/%"`
      done
      test -z "$LD" && LD="$ac_prog"
      ;;
  "")
    # If it fails, then pretend we aren't using GCC.
    ac_prog=ld
    ;;
  *)
    # If it is relative, then search for the first ld in PATH.
    with_gnu_ld=unknown
    ;;
  esac
elif test "$with_gnu_ld" = yes; then
  AC_MSG_CHECKING([for GNU ld])
else
  AC_MSG_CHECKING([for non-GNU ld])
fi
AC_CACHE_VAL(ac_cv_path_LD,
[if test -z "$LD"; then
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH; do
    test -z "$ac_dir" && ac_dir=.
    if test -f "$ac_dir/$ac_prog" || test -f "$ac_dir/$ac_prog$ac_exeext"; then
      ac_cv_path_LD="$ac_dir/$ac_prog"
      # Check to see if the program is GNU ld.  I'd rather use --version,
      # but apparently some GNU ld's only accept -v.
      # Break only if it was the GNU/non-GNU ld that we prefer.
      if "$ac_cv_path_LD" -v 2>&1 < /dev/null | egrep '(GNU|with BFD)' > /dev/null; then
	test "$with_gnu_ld" != no && break
      else
	test "$with_gnu_ld" != yes && break
      fi
    fi
  done
  IFS="$ac_save_ifs"
else
  ac_cv_path_LD="$LD" # Let the user override the test with a path.
fi])
LD="$ac_cv_path_LD"
if test -n "$LD"; then
  AC_MSG_RESULT($LD)
else
  AC_MSG_RESULT(no)
fi
test -z "$LD" && AC_MSG_ERROR([no acceptable ld found in \$PATH])
AC_SUBST(LD)
AC_PROG_LD_GNU
])

AC_DEFUN(AC_PROG_LD_GNU,
[AC_CACHE_CHECK([if the linker ($LD) is GNU ld], ac_cv_prog_gnu_ld,
[# I'd rather use --version here, but apparently some GNU ld's only accept -v.
if $LD -v 2>&1 </dev/null | egrep '(GNU|with BFD)' 1>&5; then
  ac_cv_prog_gnu_ld=yes
else
  ac_cv_prog_gnu_ld=no
fi])
])

# AC_PROG_NM - find the path to a BSD-compatible name lister
AC_DEFUN(AC_PROG_NM,
[AC_MSG_CHECKING([for BSD-compatible nm])
AC_CACHE_VAL(ac_cv_path_NM,
[if test -n "$NM"; then
  # Let the user override the test.
  ac_cv_path_NM="$NM"
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}${PATH_SEPARATOR-:}"
  for ac_dir in $PATH /usr/ccs/bin /usr/ucb /bin; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/nm || test -f $ac_dir/nm$ac_exeext ; then
      # Check to see if the nm accepts a BSD-compat flag.
      # Adding the `sed 1q' prevents false positives on HP-UX, which says:
      #   nm: unknown option "B" ignored
      if ($ac_dir/nm -B /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -B"
	break
      elif ($ac_dir/nm -p /dev/null 2>&1 | sed '1q'; exit 0) | egrep /dev/null >/dev/null; then
	ac_cv_path_NM="$ac_dir/nm -p"
	break
      else
	ac_cv_path_NM=${ac_cv_path_NM="$ac_dir/nm"} # keep the first match, but
	continue # so that we can try to find one that supports BSD flags
      fi
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_NM" && ac_cv_path_NM=nm
fi])
NM="$ac_cv_path_NM"
AC_MSG_RESULT([$NM])
AC_SUBST(NM)
])

# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$host" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
])

# AC_LIBLTDL_CONVENIENCE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl convenience library, adds --enable-ltdl-convenience to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
AC_DEFUN(AC_LIBLTDL_CONVENIENCE, [
  case "$enable_ltdl_convenience" in
  no) AC_MSG_ERROR([this package needs a convenience libltdl]) ;;
  "") enable_ltdl_convenience=yes
      ac_configure_args="$ac_configure_args --enable-ltdl-convenience" ;;
  esac
  LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdlc.la
])

# AC_LIBLTDL_INSTALLABLE[(dir)] - sets LIBLTDL to the link flags for
# the libltdl installable library, and adds --enable-ltdl-install to
# the configure arguments.  Note that LIBLTDL is not AC_SUBSTed, nor
# is AC_CONFIG_SUBDIRS called.  If DIR is not provided, it is assumed
# to be `${top_builddir}/libltdl'.  Make sure you start DIR with
# '${top_builddir}/' (note the single quotes!) if your package is not
# flat, and, if you're not using automake, define top_builddir as
# appropriate in the Makefiles.
# In the future, this macro may have to be called after AC_PROG_LIBTOOL.
AC_DEFUN(AC_LIBLTDL_INSTALLABLE, [
  AC_CHECK_LIB(ltdl, main,
  [test x"$enable_ltdl_install" != xyes && enable_ltdl_install=no],
  [if test x"$enable_ltdl_install" = xno; then
     AC_MSG_WARN([libltdl not installed, but installation disabled])
   else
     enable_ltdl_install=yes
   fi
  ])
  if test x"$enable_ltdl_install" = x"yes"; then
    ac_configure_args="$ac_configure_args --enable-ltdl-install"
    LIBLTDL=ifelse($#,1,$1,['${top_builddir}/libltdl'])/libltdl.la
  else
    ac_configure_args="$ac_configure_args --enable-ltdl-install=no"
    LIBLTDL="-lltdl"
  fi
])

dnl old names
AC_DEFUN(AM_PROG_LIBTOOL, [indir([AC_PROG_LIBTOOL])])dnl
AC_DEFUN(AM_ENABLE_SHARED, [indir([AC_ENABLE_SHARED], $@)])dnl
AC_DEFUN(AM_ENABLE_STATIC, [indir([AC_ENABLE_STATIC], $@)])dnl
AC_DEFUN(AM_DISABLE_SHARED, [indir([AC_DISABLE_SHARED], $@)])dnl
AC_DEFUN(AM_DISABLE_STATIC, [indir([AC_DISABLE_STATIC], $@)])dnl
AC_DEFUN(AM_PROG_LD, [indir([AC_PROG_LD])])dnl
AC_DEFUN(AM_PROG_NM, [indir([AC_PROG_NM])])dnl

AC_DEFUN(md_CHECK_GUILIBS,
[AC_MSG_CHECKING(for GUI libs)
AC_TRY_COMPILE([#ifdef __CYGWIN__
#error
#endif],[],
GUILIBS="-lX11 ${X_EXTRA_LIBS}",
GUILIBS='-luser32 -lgdi32')
AC_MSG_RESULT($GUILIBS)
AC_SUBST(GUILIBS)
])

AC_DEFUN(md_CHECK_EXESUFFIX,
[AC_MSG_CHECKING(for executable suffix)
AC_TRY_COMPILE([#ifdef __CYGWIN__
#error
#endif
],[],
EXESUFFIX='',
EXESUFFIX=.exe)
if test -z "$EXESUFFIX" ; then
AC_MSG_RESULT(none)
else
AC_MSG_RESULT($EXESUFFIX)
fi
AC_SUBST(EXESUFFIX)
])

AC_DEFUN(md_FIND_XPM,
[test -z "$xpmlibdir" && xpmlibdir=$x_libraries
found=no
for name in $xpmlibname Xpm; do
  md_FIND_LIB(xpm,$name,,1)
  if test -n "$_ldflags" ; then
    xpmlibname=$name
    found=yes
    break
  fi
done
gnuwin32=no
if test $found = yes; then
  XPMLDFLAGS=$_ldflags
  XPMLIB=-l$xpmlibname
else
AC_TRY_COMPILE([#ifdef __CYGWIN__
#error
#endif],[],,gnuwin32=yes)
  if test $gnuwin32 = yes; then
    XPMLDFLAGS=''
    XPMLIB=''
  else
    AC_MSG_ERROR(Please use --with-xpmlibdir to specify location of XPM.)
  fi
fi

AC_SUBST(xpmlibdir)
AC_SUBST(xpmincludedir)
AC_SUBST(XPMLDFLAGS)
AC_SUBST(XPMLIB)

test -z "$xpmincludedir" && xpmincludedir="$x_includes"
if test "$xpmincludedir" = "$x_includes"; then
  XPMINCLUDES=''
else
  XPMINCLUDES='-I${xpmincludedir}'
fi
AC_SUBST(XPMINCLUDES)

if test "$gnuwin32" = no; then

last_cppflags=$CPPFLAGS
test -n "$xpmincludedir" && CPPFLAGS="-I$xpmincludedir $CPPFLAGS"
AC_MSG_CHECKING(for X11/xpm.h)
AC_TRY_COMPILE([#include <X11/xpm.h>],[],have_x11_xpm_h=yes,have_x11_xpm_h=no)
if test $have_x11_xpm_h = yes; then
  AC_DEFINE(HAVE_X11_XPM_H)
  AC_MSG_RESULT(yes)
else 
  AC_MSG_RESULT(no)
  AC_MSG_CHECKING(for xpm.h)
  AC_TRY_COMPILE([#include <xpm.h>],[],have_xpm_h=yes,have_xpm_h=no)
  if test $have_xpm_h = yes; then
    AC_DEFINE(HAVE_XPM_H)
    AC_MSG_RESULT(yes)
  else
    AC_MSG_ERROR(Cannot find xpm.h)
  fi
fi
CPPFLAGS=$last_cppflags

fi
])

AC_DEFUN(md_STRUCT_XPM_ALLOCPIXELS,
[last_cppflags=$CPPFLAGS
test -n "$xpmincludedir" && CPPFLAGS="-I$xpmincludedir $CPPFLAGS"
AC_MSG_CHECKING(for nalloc_pixels in XpmAttributes)
AC_TRY_COMPILE([#ifdef HAVE_X11_XPM_H 
#include <X11/xpm.h>
#elif defined(HAVE_XPM_H)
#include <xpm.h>
#else
#error
#endif], 
[XpmAttributes attr; attr.nalloc_pixels = 0;],
AC_MSG_RESULT(yes)
AC_DEFINE(HAVE_XPM_ALLOCPIXELS),
AC_MSG_RESULT(no))
CPPFLAGS=$last_cppflags
])


AC_DEFUN(md_FIND_LIB,
[libname=$2
if test -z "$libname" ; then
  libname=$1
fi
AC_MSG_CHECKING(directory of lib${libname})
_libdir="$$1libdir"
if test "$$1dir" != no ; then
test -z "$_libdir" && _libdir=$$1dir/lib
for dir in $3 $_libdir $defaultdir/lib /usr/lib /usr/local/lib; do
  expand_dir=`eval echo $dir`
  for suffix in .so .sl .a; do
    if test -r $expand_dir/lib${libname}${suffix} ; then
      $1libdir=$dir
      break
    else
      $1libdir=''
    fi
  done
  test -z "$$1libdir" || break
done
fi
if test -z "$$1libdir"; then
  AC_MSG_RESULT(no)    
  if test -z "$4"; then
    AC_MSG_ERROR(Please use --with-$1dir to specify location of $1.)
  fi
else
  AC_MSG_RESULT($$1libdir)
fi
if test -n "$$1libdir" ; then
  if test $suffix = .so || test $suffix = .sl ; then
    _ldflags="-L\${$1libdir} -R \${$1libdir}"
  else
    _ldflags='-L${$1libdir}'
  fi
else
  _ldflags=''
fi
])

AC_DEFUN(md_FIND_INCLUDE,
[test -n "$$1includedir" || $1includedir=$$1dir/include
AC_MSG_CHECKING(directory of $1.h)
for dir in $$1includedir /usr/include /usr/local/include; do
 expand_dir=`eval echo $dir`
 if test -r $expand_dir/$1.h ; then
    $1includedir=$dir
    break
  else
    $1includedir=''
  fi
done
if test -n "$$1includedir"; then
  AC_MSG_RESULT($$1includedir)
else
  AC_MSG_RESULT(no)
  AC_MSG_ERROR(Please use --with-$1includedir to specify location of $1.h)
fi
expand_dir=`eval echo $$1includedir`
if test "$expand_dir" = /usr/include; then
  _includes=''
else
  _includes='-I${$1includedir}'
fi
])

dnl Locate the Tcl/Tk include files
dnl A hybrid of BLT's approach of looking in lots of places and, if
dnl that fails, just believing what "echo [info library] | tclsh" says.
dnl We play a bit of a trick here piping commands into tclsh
dnl Extra set of brackets hides the Tcl brackets from autoconf m4.
dnl
dnl First, if tclsh is around execute it to make a guess as to where Tcl
dnl is installed, and also to find out if we're using tcl > 7.3.
AC_DEFUN(md_FIND_TCL,dnl
[lastPATH=$PATH
if test -n "$with_tcldir" ; then               
  PATH=${with_tcldir}/bin:$PATH
fi
AC_CHECK_PROG(tclsh82_found, tclsh8.2, yes, no)
if test $tclsh82_found = no ; then
  AC_CHECK_PROG(tclsh81_found, tclsh8.1, yes, no)
  if test $tclsh81_found = no ; then
    AC_CHECK_PROG(tclsh80_found, tclsh8.0, yes, no)
    if test $tclsh80_found = no ; then
      AC_CHECK_PROG(tclsh_found, tclsh, yes, no)
    fi
  fi
fi
changequote(<,>)dnl
tclLibrary=''
if test $tclsh82_found = yes; then
  tclLibrary=`echo "puts [info library]" | tclsh8.2`
elif test $tclsh81_found = yes; then
  tclLibrary=`echo "puts [info library]" | tclsh8.1`
elif test $tclsh80_found = yes; then
    tclLibrary=`echo "puts [info library]" | tclsh8.0`
else
  if test $tclsh_found = yes; then
    tclLibrary=`echo "puts [info library]" | tclsh`
  fi
fi
PATH=$lastPATH
changequote([,])dnl
if test -n "$tclLibrary"; then
  tclInstalledDir=`dirname "$tclLibrary"`
  tclInstalledDir=`dirname "$tclInstalledDir"`
fi

# Second, if TCL_LIBRARY or TK_LIBRARY are set, work from there.
if test -n "$TCL_LIBRARY"; then
  USER_TCL_INCLUDE=`dirname $TCL_LIBRARY`
  USER_TCL_INCLUDE=`dirname $USER_TCL_INCLUDE`/include
  USER_TCL_LIB=`dirname $TCL_LIBRARY`
else
  USER_TCL_INCLUDE=""
  USER_TCL_LIB=""
fi
if test -n "$TK_LIBRARY"; then
  USER_TK_INCLUDE=`dirname $TK_LIBRARY`
  USER_TK_INCLUDE=`dirname $USER_TK_INCLUDE`/include
  USER_TK_LIB=`dirname $TK_LIBRARY`
else
  USER_TK_INCLUDE=""
  USER_TK_LIB=""
fi
])

AC_DEFUN(md_FIND_TCL_HEADERS,dnl
[
# define INCPLACES to be those directories where tcl.h and tk.h could be.
# We look in lots of "standard" places as well as where [info version]
# tells us to look. Note that this list is both for tcl.h and tk.h: they
# are often installed in the same directory.

INCPLACES=" \
        $defaultdir/include $defaultdir/include/tcl $defaultdir/include/tk \
        \${CYGFS}include /Cygnus/cygwin-b20/include \
        /usr/local/include /usr/local/include/tcl /usr/local/include/tk \
        /usr/include /usr/include/tcl /usr/include/tk \
        $x_includes $x_includes/tcl $x_includes/tk \
        ../tcl8.1 ../tcl8.0 ../tcl7.6 ../tcl7.5 ../tcl7.4 \
        ../tk8.1 ../tk8.0 ../tk4.2 ../tk4.1 ../tk4.0"
if test -n "$tclInstalledDir"; then
  INCPLACES="$tclInstalledDir/include $INCPLACES"
fi
INCPLACES="$USER_TCL_INCLUDE $USER_TK_INCLUDE $INCPLACES"

AC_MSG_CHECKING(directory of tcl.h)
for dir in $tclincludedir "$TCL_INCLUDE_DIR" $INCPLACES; do
  expand_dir=`eval echo $dir`
  if test -r $expand_dir/tcl.h; then
    tclincludedir=$dir
    break
  fi
done

if test -n "$tclincludedir"; then
  AC_MSG_RESULT($tclincludedir)
  if test "$tclincludedir" = "/usr/include" ; then
    TCLINCLUDES=""
  else
    TCLINCLUDES='-I${tclincludedir}'
  fi
else
  AC_MSG_RESULT(no)
fi
AC_SUBST(tclincludedir)
AC_SUBST(TCLINCLUDES)
])dnl

AC_DEFUN(md_FIND_TCL_LIBRARIES,dnl
[changequote(<,>)dnl
LIBPLACES="$defaultdir/lib $defaultdir/lib/tcl $defaultdir/lib/tk \
        \${CYGFS}H-i586-cygwin32/lib \
        /Cygnus/cygwin-b20/H-i586-cygwin32/lib \
	/usr/local/lib /usr/local/lib/tcl /usr/local/lib/tk \
	/usr/lib /usr/lib/tcl /usr/lib/tk \
	$x_libraries $x_libraries/tcl $x_libraries/tk \
	../tcl8.1 ../tcl8.0 ../tcl7.6 ../tcl7.5 ../tcl7.4 \
	../tk8.1 ../tk8.0 ../tk4.2 ../tk4.1 ../tk4.0"

if test -n "$tclInstalledDir"; then
  LIBPLACES="$tclInstalledDir/lib $LIBPLACES"
fi
LIBPLACES="$USER_TCL_LIB $USER_TK_LIB $LIBPLACES"
LIBPLACES="`dirname $tclincludedir`/lib $LIBPLACES"

AC_MSG_CHECKING(directory and version of libtcl)
for dir in $tcllibdir "$TCL_LIB_DIR" $LIBPLACES; do
  tcllibdir=''
  expand_dir=`eval echo $dir`
  for suffix in .so .sl .a; do
    if test -n "$tcllibname"; then
      if test -r $expand_dir/lib${tcllibname}${suffix} ; then
        tcllibdir=$dir
        break
      fi
    else
      for version in 82 8.2 81 8.1 80 8.0 76 7.6 7.5 7.4 ''; do
        if test -r $expand_dir/libtcl${version}${suffix}; then
          tcllibdir=$dir  
          tcllibname=tcl$version
          break
        fi        
      done
    fi
    test -z "$tcllibdir" || break
  done
  test -z "$tcllibdir" || break
done

if test -n "$tcllibdir" ; then
  AC_MSG_RESULT(<$tcllibdir, $tcllibname>)
  if test "$tcllibdir" = "/usr/lib" ; then
    TCLLDFLAGS=''
    TCLLIB="-l$tcllibname"
  else
    if test $suffix = .so || test $suffix = .sl; then
      TCLLDFLAGS="-L\${tcllibdir} -R \${tcllibdir}"
    else
      TCLLDFLAGS='-L${tcllibdir}'
    fi
    TCLLIB=-l$tcllibname
  fi
else
  AC_MSG_RESULT(no)
fi
changequote([,])dnl
AC_SUBST(TCLLIB)
AC_SUBST(TCLLDFLAGS)
AC_SUBST(tcllibdir)
])dnl

AC_DEFUN(md_FIND_TK_HEADERS,
[POTENTIALINCDIR=`dirname $tclincludedir`
POTENTIALINCDIR=`dirname $POTENTIALINCDIR`
INCPLACES="$INCPLACES \
	$tclincludedir \ 
        $POTENTIALINCDIR/tk8.1/include \
	$POTENTIALINCDIR/tk8.0/include \
	$POTENTIALINCDIR/tk4.2/include \
	$POTENTIALINCDIR/tk4.1/include \
	$POTENTIALINCDIR/tk4.0/include \
	$POTENTIALINCDIR/tk/include"
if test -n "$tclInstalledDir"; then
  INCPLACES="$tclInstalledDir/include $INCPLACES"
fi
AC_MSG_CHECKING(directory of tk.h)
for dir in $tkincludedir "$TK_INCLUDE_DIR" $INCPLACES; do
  expand_dir=`eval echo $dir`
  if test -r $expand_dir/tk.h; then
    tkincludedir=$dir
    break
  fi
done
if test -n "$tkincludedir"; then
  AC_MSG_RESULT($tkincludedir)
  if test "$tkincludedir" = "/usr/include" ; then
    TKINCLUDES=""
  else
    TKINCLUDES='-I${tkincludedir}'
  fi
else
  AC_MSG_RESULT(no)
fi
AC_SUBST(tkincludedir)
AC_SUBST(TKINCLUDES)
])

AC_DEFUN(md_FIND_TK_LIBRARIES,
[changequote(<,>)dnl
POTENTIALLIBDIR=`dirname $tcllibdir`
POTENTIALLIBDIR=`dirname $POTENTIALLIBDIR`
LIBPLACES="`dirname $tkincludedir`/lib $tcllibdir $POTENTIALLIBDIR/tk/lib \
        $POTENTIALLIBDIR/tk8.1/lib \
	$POTENTIALLIBDIR/tk8.0/lib \
	$POTENTIALLIBDIR/tk4.2/lib \
	$POTENTIALLIBDIR/tk4.1/lib \
	$POTENTIALLIBDIR/tk4.0/lib \
	$LIBPLACES"
if test -n "$tclInstalledDir"; then
  LIBPLACES="$tclInstalledDir/lib $LIBPLACES"
fi
AC_MSG_CHECKING(directory and version of libtk)
for dir in $tklibdir "$TK_LIB_DIR" $LIBPLACES; do
  tklibdir=''
  expand_dir=`eval echo $dir`
  for suffix in .so .sl .a; do
    if test -n "$tklibname" ; then
      if test -r $expand_dir/lib${tklibname}${suffix} ; then
        tklibdir=$dir
        break
      fi
    else
      for version in 82 8.2 81 8.1 80 8.0 42 4.2 4.1 4.0 ''; do
        if test -r $expand_dir/libtk${version}${suffix}; then
          tklibdir=$dir
          tklibname=tk${version}
          break
        fi
      done
    fi
    test -z "$tklibdir" || break
  done
  test -z "$tklibdir" || break
done

if test -n "$tklibdir" ; then
  AC_MSG_RESULT(<$tklibdir, $tklibname>)
  if test "$tklibdir" = "/usr/lib" ; then
    TKLDFLAGS=''
    TKLIB=-l$tklibname
  else
    if test $suffix = .so || test $suffix = .sl ; then
      TKLDFLAGS="-L\${tklibdir} -R \${tklibdir}"
    else
      TKLDFLAGS='-L${tklibdir}'
    fi
    TKLIB=-l$tklibname
  fi
else
  AC_MSG_RESULT(no)
fi
changequote([,])dnl
AC_SUBST(TKLDFLAGS)
AC_SUBST(TKLIB)
AC_SUBST(tklibdir)
])

AC_DEFUN(md_FIND_TCLTK_SCRIPTS,
[_configfile=`eval echo "$$1libdir/$1Config.sh"`
if test -z "$$1scriptdir" ; then
  _version=`sed -n "s/^translit($1,a-z,A-Z)_VERSION='\(.*\)'/\1/p" $_configfile 2>/dev/null`
  _prefix=`sed -n "s/^translit($1,a-z,A-Z)_PREFIX='\(.*\)'/\1/p" $_configfile 2>/dev/null`
  $1scriptdir=$_prefix/lib/$1$_version
  if test ! -d "$$1scriptdir" ; then
    $1scriptdir=$_prefix/share/$1$_version
  fi
fi
])

AC_DEFUN(md_FIND_TCL_SCRIPTS,
md_FIND_TCLTK_SCRIPTS(tcl)
[if test ! -r $tclscriptdir/init.tcl ; then
  AC_MSG_ERROR(Please use --with-tclscriptdir to specify location of init.tcl)
fi
])

AC_DEFUN(md_FIND_TK_SCRIPTS,
md_FIND_TCLTK_SCRIPTS(tk)
[if test ! -r $tkscriptdir/tk.tcl ; then
  AC_MSG_ERROR(Please use --with-tkscriptdir to specify location of tk.tcl)
fi
])


AC_DEFUN(md_FIND_BLT,
[test -z "$bltdir" && bltdir=$defaultdir
found=no
for name in $bltlibname BLT24 BLT8.0 BLT80 BLT; do
  md_FIND_LIB(blt,$name,$bltdir/lib/shared,1)
  if test -n "$_ldflags" ; then
    bltlibname=$name
    found=yes
    break
  fi
done
if test $found = no; then
  AC_MSG_ERROR(Please use --with-bltdir to specify location of BLT.)
fi

BLTLDFLAGS=$_ldflags
BLTLIB=-l$bltlibname
AC_SUBST(bltlibdir)
AC_SUBST(bltdir)
AC_SUBST(BLTLDFLAGS)
AC_SUBST(BLTLIB)
])

AC_DEFUN(md_CHECK_TCLTK_LIBINC_VERSION_MATCH,
[_configfile=`eval echo "$$1libdir/$1Config.sh"`
_upper=translit($1,a-z,A-Z)
_version=`sed -n "s/^${_upper}_VERSION='\(.*\)'/\1/p" $_configfile 2>/dev/null`
_patchlevel=`sed -n "s/^${_upper}_PATCH_LEVEL='\(.*\)'/\1/p" $_configfile 2>/dev/null`
_lversionpl=${_version}${_patchlevel}
path=`eval echo $$1includedir/$1.h`
_iversionpl=`sed -n "s/#define ${_upper}_PATCH_LEVEL.*\"\(.*\)\"/\1/p" < $path`
if test "$_lversionpl" != "$_iversionpl" || test -z "$_lversionpl" || test -z "$_iversionpl"; then
  AC_MSG_ERROR($1 include and $1Config.sh file version mismatch \"$_lversionpl\" != \"$_iversionpl\")
fi
])
AC_DEFUN(md_FIND_FFI,
[USE_FFCALL=0
if test -n "$with_ffidir" && test "$with_ffidir" != no; then
  case $target_cpu in
    i?86|sparc)
      AC_MSG_WARN(Ignoring --with-ffidir: libffi is known to be less reliable than avcall on this platform.)
      with_ffidir=no
      ;;
    *)
      ffidir=$with_ffidir 
      ;;
  esac
else
  if test -n "$with_ffcalldir" ; then
    ffidir=$with_ffcalldir
    USE_FFCALL=1
  fi
fi

if test -n "$ffidir" ; then
  if test $USE_FFCALL = 0; then
    if test "$with_ffidir" != no ; then
      test -n "$ffidir" || ffidir=$defaultdir
      FFILDFLAGS=''
      AC_MSG_CHECKING(directory of libffi)
      for dir in $ffidir /usr ; do
        ffidir_expand=`eval echo $dir`
        if test -f $ffidir_expand/lib/libffi.so ; then
          FFILDFLAGS="-L\${ffilibdir} -R \${ffilibdir}"
          AC_MSG_RESULT($dir/lib/libffi.so)
          break
        else
          if test -f $ffidir_expand/lib/libffi.a ; then
            FFILDFLAGS='-L${ffilibdir}'
            AC_MSG_RESULT($dir/lib/libffi.a)
            break
          fi
        fi
      done
      if test -z "$FFILDFLAGS" ; then
        AC_MSG_RESULT(no)    
      else
        ffidir=$dir
        AC_MSG_CHECKING(directory of libffi include)
        if test -f $ffidir_expand/include/ffi.h ; then
          AC_MSG_RESULT($ffidir/include)
          FFILIB=-lffi
        else
          AC_MSG_RESULT(no)
        fi
      fi
    fi
  else 
    if test "$with_ffcalldir" != no; then
      AC_DEFINE(USE_AVCALL)
      FFILIB=-lavcall
      test -n "$ffidir" || ffidir=$defaultdir
      ffidir_expand=`eval echo $ffidir`
      AC_MSG_CHECKING(directory of libavcall.a)
      if test -f $ffidir_expand/lib/libavcall.a ; then
        FFILDFLAGS='-L${ffilibdir}'
        AC_MSG_RESULT($ffidir/lib)
      else
        AC_MSG_RESULT(no)    
        AC_MSG_ERROR(Please use --with-ffcalldir to specify location of avcall library.)
      fi
      AC_MSG_CHECKING(directory of avcall include)
      if test -f $ffidir_expand/include/avcall.h ; then
        AC_MSG_RESULT($ffidir/include)
      else
      AC_MSG_RESULT(no)
        AC_MSG_ERROR(Please use --with-ffcalldir to specify locatin of avcall header file.) 
      fi
    fi
  fi
fi
if test -n "$FFILIB"; then
  ffilibdir=$ffidir/lib
  if test $ffidir_expand = /usr; then
    FFIINCLUDES=''
  else
    FFIINCLUDES='-I${ffidir}/include'
  fi
  AM_CONDITIONAL(USEBUILTINAVCALL, false)
else
  AC_DEFINE(USE_AVCALL)
  ffidir=
  ffilibdir=
  FFIINCLUDES='-I$(top_builddir)/avcall'
  FFILDFLAGS=
  FFILIB="\$(top_builddir)/avcall/avcall.lo"
  if test "$host_os" = cygwin; then
    FFILIB="\$(top_builddir)/avcall/avcall-i386-msvc.lo ${FFILIB}"
  fi
  AM_CONDITIONAL(USEBUILTINAVCALL, true)
fi
AC_SUBST(ffidir)
AC_SUBST(ffilibdir)
AC_SUBST(FFIINCLUDES)
AC_SUBST(FFILDFLAGS)
AC_SUBST(FFILIB)
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

AC_DEFUN(md_FIND_ZLIB,
[test -z "$zlibdir" && zlibdir=$defaultdir
md_FIND_INCLUDE(zlib)
md_FIND_LIB(zlib,z)
ZLIBINCLUDES=$_includes
ZLIBLDFLAGS=$_ldflags
AC_SUBST(zliblibdir)
AC_SUBST(zlibincludedir)
AC_SUBST(ZLIBINCLUDES)
AC_SUBST(ZLIBLDFLAGS)
])

AC_DEFUN(md_FIND_PNG,
[test -z "$pngdir" && pngdir=$defaultdir
md_FIND_INCLUDE(png)
md_FIND_LIB(png)
PNGINCLUDES=$_includes
PNGLDFLAGS=$_ldflags
AC_SUBST(pngincludedir)
AC_SUBST(pnglibdir)
AC_SUBST(PNGINCLUDES)
AC_SUBST(PNGLDFLAGS)
])

AC_DEFUN(md_FIND_HDF5,
[test -z "$hdf5dir" && hdf5dir=$defaultdir
md_FIND_LIB(hdf5,,,1)
if test -n "$hdf5libdir" ; then
  md_FIND_INCLUDE(hdf5)
  HDF5INCLUDES=$_includes
  HDF5LDFLAGS=$_ldflags
  HDF5LIB=-lhdf5
  AC_DEFINE(HAVE_HDF5)
else
  HDF5INCLUDES=''
  HDF5LDFLAGS=''
  HDF5LIB=''
fi
AC_SUBST(hdf5libdir)
AC_SUBST(hdf5includedir)
AC_SUBST(HDF5LIB)
AC_SUBST(HDF5INCLUDES)
AC_SUBST(HDF5LDFLAGS)
])

AC_DEFUN(md_CHECK_LINKFLAGS,
[AC_MSG_CHECKING(for special linkflags)
AC_TRY_COMPILE([#ifdef __CYGWIN__
#error
#endif
],[],
EXTRALDFLAGS="",
EXTRALDFLAGS=["-mwindows -Wl,--defsym,_WinMainCRTStartup=_mainCRTStartup"])
if test -z "$EXTRALDFLAGS" ; then
  AC_MSG_RESULT(none)
else
  AC_MSG_RESULT($EXTRALDFLAGS)
fi
AC_SUBST(EXTRALDFLAGS)
])

AC_DEFUN(md_CHECK_INLINING,
[AC_MSG_CHECKING(for GCC inlining bug)
AC_TRY_RUN([inline void
fuzz (double __y)
{
  long long int __p = __y;
  if (__p == 0)
    return;
  if (__p < 0)
    __p = 0;
}
int
main ()
{
  double nodedy[2];
  fuzz (0.5);
  exit (0);
}
],AC_MSG_RESULT(no),
AC_MSG_RESULT(yes)
CFLAGS="$CFLAGS -fno-inline",AC_MSG_RESULT(guessing no))])

AC_DEFUN(md_CHECK_WARNFLAGS,
[lastCFLAGS=$CFLAGS

AC_MSG_CHECKING(how to avoid implicit int return warning)
CFLAGS_NOWARN_IMPLICIT_INT=-Wno-implicit-int
CFLAGS="-Wall -Werror $CFLAGS_NOWARN_IMPLICIT_INT $CFLAGS"
AC_TRY_COMPILE([extern foobar ();],[],[],CFLAGS_NOWARN_IMPLICIT_INT=-Wno-implicit)
AC_MSG_RESULT($CFLAGS_NOWARN_IMPLICIT_INT)
AC_SUBST(CFLAGS_NOWARN_IMPLICIT_INT)

CFLAGS=$lastCFLAGS
AC_MSG_CHECKING(how to avoid unknown pragma warning)
CFLAGS_NOWARN_UNKNOWN_PRAGMAS=-Wno-unknown-pragmas
CFLAGS="-Wall -Werror $CFLAGS_NOWARN_UNKNOWN_PRAGMAS"
AC_TRY_COMPILE([#pragma ident],[],[],CFLAGS_NOWARN_UNKNOWN_PRAGMAS="")
AC_MSG_RESULT($CFLAGS_NOWARN_UNKNOWN_PRAGMAS)
AC_SUBST(CFLAGS_NOWARN_UNKNOWN_PRAGMAS)

CFLAGS=$lastCFLAGS
])
AC_DEFUN(md_CHECK_NEXTSTEP,
[AC_TRY_CPP([#ifdef NeXT
#error
#endif
], NON_NeXT_EXTRA_OBJS='HashTable.lo List.lo', NON_NeXT_EXTRA_OBJS='')
AC_SUBST(NON_NeXT_EXTRA_OBJS)])
AC_DEFUN(md_CHECK_POINTER_FMT,
AC_MSG_CHECKING(for 0x prefix from %p)
AC_TRY_RUN([
#include <stdio.h>

main ()
{
  changequote(<,>)dnl
  char buf[16];

  sprintf (buf, "%p", &buf);

  exit (!(buf[0] == '0' && buf[1] == 'x'));
  changequote([,])dnl
}
],
AC_DEFINE(PTRHEXFMT, "%p") AC_MSG_RESULT(yes),
AC_DEFINE(PTRHEXFMT, "0x%p") AC_MSG_RESULT(no),
AC_DEFINE(PTRHEXFMT, "0x%p") AC_MSG_RESULT(guessing no)))



AC_DEFUN(md_CHECK_BUILTIN_APPLY,
AC_MSG_CHECKING(for working __builtin_apply)
AC_TRY_RUN([
void *buf;
int exit_code = 0;

void callme (void)
{
  buf = __builtin_apply_args ();
  exit_code = 0;
}


main ()
{
  callme ();
  exit_code = 1;
  __builtin_apply (callme, buf, 0);
  exit (exit_code);
}
],
AC_MSG_RESULT(yes),
AC_DEFINE(BUGGY_BUILTIN_APPLY) AC_MSG_RESULT(no),
AC_MSG_RESULT(guessing yes)
))
AC_DEFUN(md_CHECK_SIZES,
[AC_CHECK_SIZEOF(int, 4)
AC_CHECK_SIZEOF(long, 4)
AC_CHECK_SIZEOF(void *, 4)
if test $ac_cv_sizeof_int = $ac_cv_sizeof_void_p; then
  AC_DEFINE(PTRINT, int)
  AC_DEFINE(PTRUINT, unsigned)
  AC_DEFINE(PTRINTFMT, "%d")
  AC_DEFINE(PTRUINTFMT, "%u")
elif test $ac_cv_sizeof_long = $ac_cv_sizeof_void_p; then
  AC_DEFINE(PTRINT, long)
  AC_DEFINE(PTRUINT, unsigned long)
  AC_DEFINE(PTRINTFMT, "%ld")
  AC_DEFINE(PTRUINTFMT, "%lu")
else
  AC_MSG_ERROR(Neither int nor long have the size of void *)
fi])

AC_DEFUN(md_CHECK_long_long_printf,
[AC_MSG_CHECKING(how to print long long)
AC_CACHE_VAL(swarm_cv_printf_ll_fmt,
for swarm_cv_printf_ll_fmt in l L q ll unknown; do
AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
main ()
{
  char *s = malloc (128);
  long long x = (long long) 1048576 * (long long) 1048576;

  sprintf (s,"%${swarm_cv_printf_ll_fmt}d",x);
  exit (strcmp (s, "1099511627776"));
}
],
break,,break)
done)
AC_MSG_RESULT(%${swarm_cv_printf_ll_fmt}d and %${swarm_cv_printf_ll_fmt}u)
if test "$swarm_cv_printf_ll_fmt" != unknown; then
AC_DEFINE_UNQUOTED(LLFMT,"$swarm_cv_printf_ll_fmt")
fi
AC_CHECK_SIZEOF(long, 4)
AC_CHECK_SIZEOF(long long, 8)
])

AC_DEFUN(md_CHECK_ARGP,
[AC_CHECK_HEADERS(argp.h)
if test $ac_cv_header_argp_h = no; then
  ARGP_H=argp.h
else
  ARGP_H=
fi
AC_SUBST(ARGP_H)
AC_CHECK_FUNCS(argp_parse,,LIBOBJS="$LIBOBJS argp-ba.lo argp-eexst.lo argp-fmtstream.lo argp-fs-xinl.lo argp-help.lo argp-parse.lo argp-pv.lo argp-pvh.lo argp-xinl.lo getopt1.lo getopt.lo")
])


AC_DEFUN(md_CHECK_PATH_SYNTAX,
[if test "$host_os" = cygwin; then
  PATHSEP=";"
  PATHDELIM='\'
  PATHEXPR='"$(shell cygpath -w $<)"'
  top_dossrcdir=`cygpath -w $srcdir`
else
  PATHSEP=:
  PATHDELIM=/
  PATHEXPR='$<'
  top_dossrcdir=$srcdir
fi
AC_SUBST(top_dossrcdir)
AC_SUBST(PATHSEP)
AC_SUBST(PATHDELIM)
AC_SUBST(PATHEXPR)
])

AC_DEFUN(vj_FIND_JDK,
[if test -z "$jdkdir" ; then
  test -n "$JAVAC" || AC_PATH_PROG(JAVAC, javac, missing)
  if test $JAVAC != missing; then
    changequote(,)
    jdkdir=`echo $JAVAC | sed -e 's/\/javac$//' -e 's/\/[^/][^/]*$//'`
    changequote([,])
  fi
fi
AC_MSG_CHECKING(for JDK)
test -z "$jdkdir" && jdkdir=no
if test $jdkdir = no; then
  AC_MSG_RESULT(no)
  jdkdir=
  JAVASTUBS=
  JAVASWARMSCRIPTS=
else
  expand_jdkdir=`eval echo $jdkdir`
  USEDOSCLASSPATH=no
  if test $expand_jdkdir = /usr && test -d /usr/include/java; then
    jdkincludedir=$jdkdir/include/java
    expand_jdkincludedir=$expand_jdkdir/include/java
  else
    jdkincludedir=$jdkdir/include
    expand_jdkincludedir=$expand_jdkdir/include
  fi
  JAVASWARM_LIB_NAME=javaswarm
  if test -f $expand_jdkincludedir/jni.h; then
    JAVAINCLUDES="-I$jdkincludedir"
    if test -f $expand_jdkincludedir/linux/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/linux"
      if test -d ${expand_jdkdir}/bin/i386/native_threads; then
	threads=native
        proc=i386
      elif test -d ${expand_jdkdir}/bin/linux/native_threads; then # IBMJDK
	threads=native
        proc=linux
      elif test -d ${expand_jdkdir}/bin/ppc/native_threads; then
        threads=native
        proc=ppc
      elif test -d ${expand_jdkdir}/bin/ppc/green_threads; then
        threads=green
        proc=ppc
        extra_JAVAENV="_JVM_THREADS_TYPE=green_threads"
      elif test -d ${expand_jdkdir}/bin/i386/green_threads; then
        threads=green
        proc=i386
      else
        AC_MSG_ERROR([Can't find threads])
      fi
    elif test -f $expand_jdkincludedir/solaris/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/solaris"
      if test -d ${jdkdir}/bin/sparc/native_threads; then
	threads=native
      elif test -d ${jdkdir}/bin/sparc/green_threads; then
        threads=green
      else
        AC_MSG_ERROR([Can't find threads])
      fi
      proc=sparc
    elif test -f $expand_jdkincludedir/alpha/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/alpha"
      JAVALIBS='${jdkdir}/shlib'
      threads=native
      proc=alpha
    elif test -f $expand_jdkincludedir/hp-ux/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/hp-ux"
      if test -d ${expand_jdkdir}/lib/PA_RISC/native_threads; then
        threads=native
      else
        threads=green
      fi
      proc=PA_RISC
      LD_LIBRARY_PATH_VARNAME=SHLIB_PATH
    elif test -f $expand_jdkincludedir/winnt/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/winnt"
      JAVALIBS=no
      JAVACMD='${jdkdir}/bin/java'
    elif test -f $expand_jdkincludedir/win32/jni_md.h; then
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/win32"
      JAVALIBS=no
      JAVACMD='${jdkdir}/bin/java'
    else
      JAVAINCLUDES="$JAVAINCLUDES -I$jdkincludedir/genunix"
      JAVACMD='${jdkdir}/bin/java'
      threads=green
      proc=$target_cpu
    fi
    if test "$JAVALIBS" = no; then
      JAVALIBS=
    else
      if test -z "$JAVALIBS"; then
        if test -d "${expand_jdkdir}/jre/lib/${proc}"; then
          if test -d "${expand_jdkdir}/jre/lib/${proc}/${threads}_threads"; then
            JAVALIBS="\${jdkdir}/jre/lib/${proc}/${threads}_threads"
          fi
          if test -d "${expand_jdkdir}/jre/lib/${proc}/classic"; then
            JAVALIBS="${JAVALIBS}:\${jdkdir}/jre/lib/${proc}/classic"
          fi
          JAVALIBS="${JAVALIBS}:\${jdkdir}/jre/lib/${proc}"
        elif test -d "${expand_jdkdir}/lib/${proc}/${threads}_threads"; then
          JAVALIBS="\${jdkdir}/lib/${proc}/${threads}_threads"
        else
          AC_MSG_ERROR([Cannot find JDK library])
        fi
      fi
    fi
    test -n "$JAVACMD" || JAVACMD="\${jdkdir}/bin/${proc}/${threads}_threads/java"
    if test -f ${expand_jdkdir}/jre/lib/rt.jar; then
      JAVACLASSES=${jdkdir}/jre/lib/rt.jar
    else
      JAVACLASSES=${jdkdir}/lib/classes.zip
    fi
    if test "$host_os" = cygwin; then
      JAVACLASSESARG="`cygpath -w ${JAVACLASSES}`"
      JAVAENV=
      javac_default=${jdkdir}/bin/javac
      USEDOSCLASSPATH=yes
      JAVASWARM_DLL_ENTRY='__cygwin_noncygwin_dll_entry@12'
    else
      test -n "$LD_LIBRARY_PATH_VARNAME" || LD_LIBRARY_PATH_VARNAME=LD_LIBRARY_PATH
      JAVAENV="$LD_LIBRARY_PATH_VARNAME=$JAVALIBS:\${$LD_LIBRARY_PATH_VARNAME}"
      javac_default='JAVA_HOME=${jdkdir} ${jdkdir}/bin/javac'
    fi
    JAVAENV="$extra_JAVAENV $JAVAENV"
    JAVA='${JAVAENV} ${JAVACMD}'
    JAVASTUBS_FUNCTION=java-run-all-unicode
    JAVALIBPREFIX=''
    JAVALIBPATH_VAR=
  elif test -f $expand_jdkincludedir/japhar/jni.h; then
    JAVAINCLUDES="-I$jdkincludedir/japhar"
    JAVACLASSES="`$jdkdir/bin/japhar-config info datadir`"
    JAVACMD='${jdkdir}/bin/japhar'
    JAVAENV=''
    JAVA='${JAVACMD}'
    JAVASTUBS_FUNCTION=java-run-all-unicode
    JAVALIBS='${jdkdir}/lib'
    javac_default='${jdkdir}/bin/javac'
    JAVALIBPREFIX=japhar_
    JAVALIBPATH_VAR=
  elif test -f $expand_jdkincludedir/kaffe/jni.h ; then
    JAVAINCLUDES="-I$jdkincludedir/kaffe"
    JAVASWARM_LIB_NAME=kaffeswarm
    kaffe_prefix=`sed -n 's/^prefix="\(.*\)"/\1/p' < $expand_jdkdir/bin/kaffe`
    kaffe_datadir=`sed -n 's/: ${KAFFE_CLASSDIR="\(.*\)"}/\1/p' < $expand_jdkdir/bin/kaffe`
    jdkdatadir=`eval echo \`echo $kaffe_datadir | sed  's/\${prefix}/$kaffe_prefix/'\``
    JAVACLASSES="${jdkdatadir}/Klasses.jar"

    if test "$host_os" = cygwin; then
      JAVACLASSESARG="`cygpath -w ${jdkdatadir}/Klasses.jar`"
      # we can assume SWARMROOT will be set in Windows environment --
      # recover the symbolic path representation from datadir.
      jdkdatadir=`echo $jdkdatadir | sed "s,$SWARMROOT,\\${SWARMROOT},g"`
      USEDOSCLASSPATH=yes
      # ${jdkdir}/lib/kaffe is included so that .la file can be found
      JAVALIBS="${jdkdir}/bin:${jdkdir}/lib/kaffe"
      JAVALIBSARG="`cygpath -w ${expand_jdkdir}/bin`;`cygpath -w ${expand_jdkdir}/lib/kaffe`"
      JAVASWARM_LIB_NAME=libkaffeswarm
      JAVASWARM_DLL_ENTRY='__cygwin_dll_entry@12'
    else
      JAVALIBS='${jdkdir}/lib/kaffe'
      JAVALIBSARG=$JAVALIBS
    fi
    AC_DEFINE(HAVE_KAFFE)
    JAVASTUBS_FUNCTION=java-run-all-literal
    if test -x "${expand_jdkdir}/libexec/Kaffe"; then
      JAVACMD='${jdkdir}/libexec/Kaffe'
    elif test -x "${expand_jdkdir}/lib/kaffe/Kaffe"; then
      JAVACMD='${jdkdir}/lib/kaffe/Kaffe'
    elif test -x "${expand_jdkdir}/lib/kaffe/bin/Kaffe"; then
      JAVACMD='${jdkdir}/lib/kaffe/bin/Kaffe'
    else
      AC_MSG_ERROR([Cannot find Kaffe executable])
    fi
    JAVAENV=''
    JAVA='KAFFELIBRARYPATH="${JAVALIBSARG}" ${JAVACMD}'
    javac_default='${jdkdir}/bin/javac'
    JAVALIBPREFIX=
    JAVALIBPATH_VAR=KAFFELIBRARYPATH
  else
    AC_MSG_ERROR([Please use --with-jdkdir to specify location of JDK.])
  fi
  AC_MSG_RESULT($jdkdir)
  AC_DEFINE(HAVE_JDK)
  JAVASTUBS=stubs
  JAVASWARMSCRIPTS="javaswarm javacswarm"
  AC_SUBST(JAVASWARM_DLL_ENTRY)
  AC_SUBST(JAVASWARM_LIB_NAME)
  JAVAC=${JAVAC-$javac_default}
fi 

AC_SUBST(JAVASTUBS)
AC_SUBST(JAVASTUBS_FUNCTION)
AC_SUBST(JAVAINCLUDES)
AC_SUBST(JAVALIBS)
test -n "$JAVALIBSARG" || JAVALIBSARG=$JAVALIBS
AC_SUBST(JAVALIBSARG)
AC_SUBST(JAVALIBPREFIX)
test -n "$JAVALIBPATH_VAR" || JAVALIBPATH_VAR="_JAVASWARM_LIBPATH"
AC_SUBST(JAVALIBPATH_VAR)
AC_SUBST(JAVASWARMSCRIPTS)
AC_SUBST(JAVACLASSES)
test -n "$JAVACLASSESARG" || JAVACLASSESARG=$JAVACLASSES
AC_SUBST(JAVACLASSESARG)
AC_SUBST(USEDOSCLASSPATH)
AC_SUBST(JAVACMD)
AC_SUBST(JAVAENV)
AC_SUBST(JAVA)
if test -n "$JAR"; then
  jar_home=`echo $JAR | sed 's/\/bin\/jar$//'`
  JAR="JAVA_HOME=${jar_home} $JAR"
else
  JAR='JAVA_HOME=${jdkdir} ${jdkdir}/bin/jar'
fi
if test -n "$JAR_CLASSPATH" ; then
  JAR="CLASSPATH=$JAR_CLASSPATH $JAR"
fi
AC_SUBST(JAR)
AC_SUBST(jdkdir)
])

AC_DEFUN(md_CHECK_JNI_H,
[last_cppflags=$CPPFLAGS
CPPFLAGS="$JAVAINCLUDES $CPPFLAGS"
AC_TRY_COMPILE([#include <jni.h>],[],jni_h_works=yes,jni_h_works=no)
CPPFLAGS=$last_cppflags
if test $jni_h_works = no; then
  AC_CHECK_SIZEOF(int, 4)
  AC_CHECK_SIZEOF(long, 4)
  AC_CHECK_SIZEOF(long long, 8)
  if test $ac_cv_sizeof_int = 8; then
    AC_DEFINE(INT64, int)
  elif test $ac_cv_sizeof_long = 8; then
    AC_DEFINE(INT64, long)
  elif test $ac_cv_sizeof_long_long = 8; then
    AC_DEFINE(INT64, long long)
  else
    AC_MSG_ERROR(Cannot find 8 byte integer for jni.h)
  fi
  CPPFLAGS="$JAVAINCLUDES $CPPFLAGS"
  AC_TRY_COMPILE([#define __int64 INT64
#include <jni.h>],[],AC_DEFINE(JNI_H_NEEDS_INT64))
  CPPFLAGS=$last_cppflags
fi
])


AC_DEFUN(md_CHECK_DLL,
[AC_MSG_CHECKING(for DLL options)
AC_TRY_COMPILE([#ifdef __CYGWIN__
#error
#endif
],[],
[EXPORT_EXTERN=extern
EXPORT_EXTERNDEF=
IMPORT_EXTERN=extern
USEDLL=no
AC_MSG_RESULT(using plain extern)],
[USEDLL=yes
EXPORT_EXTERN="extern __attribute__ ((dllexport))"
EXPORT_EXTERNDEF="__attribute__ ((dllexport))"
IMPORT_EXTERN="extern __attribute__ ((dllimport))"
AC_MSG_RESULT(using dllimport and dllexport)
])
AC_DEFINE_UNQUOTED(EXPORT_EXTERN,$EXPORT_EXTERN)
AC_DEFINE_UNQUOTED(EXPORT_EXTERNDEF,$EXPORT_EXTERNDEF)
AC_DEFINE_UNQUOTED(IMPORT_EXTERN,$IMPORT_EXTERN)
AC_PATH_PROG(DLLWRAP, dllwrap)
AC_SUBST(USEDLL)
AM_CONDITIONAL(USEDLL, test $USEDLL = yes)
])

