import javax.swing.JFrame;
import java.awt.image.MemoryImageSource;
import java.awt.Image;
import java.awt.Color;
import java.awt.Graphics;
import swarm.Globals;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.HashMap;
public class SwarmRaster extends JFrame {
    public Image image = null;
    public MemoryImageSource imgsrc = null;
    public int pixelWidth = 0;
    public int pixelHeight = 0;
    public ArrayList objects = null;
    public int zoomFactor = 1;
    public int logicalWidth = 0;
    public int logicalHeight = 0;
    private HashMap locationMatrix = null;

    int[] pxlBuff;

    public SwarmRaster(String title) {
        setTitle(title);
    }

    public SwarmRaster(String title, int width, int height, int zf) {
        setTitle(title);
        setZoomFactor(zf);
        setSize(width,height);
    }

    public Object setZoomFactor(int zf) {
        zoomFactor = zf;
        return this;
    }

    public void setSize(int width, int height) {
        logicalWidth = width;
        logicalHeight = height;
        pixelWidth = zoomFactor*logicalWidth;
        pixelHeight = zoomFactor*logicalHeight;

        super.setSize(pixelWidth,pixelHeight);
        pxlBuff = new int[pixelWidth*pixelHeight];
        clearPixels();
        imgsrc = new MemoryImageSource(pixelWidth,pixelHeight,
                                       pxlBuff, 0, pixelWidth);
        imgsrc.setAnimated(true);
        image = createImage(imgsrc);
        show();
        objects = new ArrayList(logicalWidth*logicalHeight);
        locationMatrix = new HashMap(logicalWidth*logicalHeight);
    }

    public void clearPixels() {
        setPixelBuffer(Color.black);
    }

    public void setPixelBuffer(Color c) {
        for (int i=0;i<pixelWidth;i++)
            for (int j=0;j<pixelHeight;j++)
                pxlBuff[i*pixelWidth + j] = c.getRGB();
    }

    public void putObjectAt(Object o, Location l) {
        objects.add(o);
        locationMatrix.put(l,o);
    }

    public Object getObjectAt(Location l) {
        return locationMatrix.get(l);
    }

    public Object getObjectAt(int x, int y) {
        return getObjectAt(new Location(this,x,y));
    }

    public Object getLocationAt(int x, int y) {
        Location l = new Location(this,x,y);
        Prisoner p = (Prisoner)getObjectAt(l);
        if (p != null)
            return p.get_location();
        else return l;
    }

    public Object updateRaster() {
        Iterator ndx = locationMatrix.keySet().iterator();
        while(ndx.hasNext()) {
            Location l = (Location)ndx.next();
            setLogicalPixel(l.x,l.y,l.get_color());
        }
        imgsrc.newPixels(0, 0, pixelWidth, pixelHeight);
        return this;
    }

    public void setLogicalPixel(int lx, int ly, Color c) {
        int rectangleX = lx*zoomFactor;
        int rectangleY = ly*zoomFactor;
        int rectangleWidth = pixelWidth/logicalWidth;
        int rectangleHeight = pixelHeight/logicalHeight;
        for (int i=rectangleX;i<rectangleX+rectangleWidth;i++)
            for (int j=rectangleY;j<rectangleY+rectangleHeight;j++)
                pxlBuff[i*pixelWidth+j] = c.getRGB();
        //imgsrc.newPixels(rectangleX, rectangleY,
        //                 rectangleWidth, rectangleHeight);
    }

    public void paint(Graphics g) {
        g.drawImage(image,0,0,this);
    }

    public void drop() {
        objects.clear();
        locationMatrix.clear();
    }
}

