import java.util.HashMap;

import swarm.Selector;
import swarm.activity.Activity;
import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;

import swarm.SignatureNotFoundException;
import swarm.NonUniqueMethodSignatureException;

import swarm.defobj.Zone;
import swarm.objectbase.Swarm;
import swarm.simtoolsgui.GUISwarmImpl;
public class ObserverSwarm extends GUISwarmImpl {
    private ActionGroup displayActions = null;
    private Schedule displaySchedule = null;
    private ModelSwarm model = null;
    private StrategyGrapher graph = null;
    private SwarmRaster raster = null;
    public int displayFrequency = 1;
    public ObserverSwarm(Zone aZone) {
        super(aZone);
    }

    public Object buildObjects() {
        System.out.println("ObserverSwarm::buildObjects()");
        super.buildObjects();

        getControlPanel().setStateStopped();

        raster = new SwarmRaster("World");
        raster.setZoomFactor(8);

        model = new ModelSwarm(this, raster);
        model.buildObjects();

        graph = new StrategyGrapher("Number playing each strategy",
                                    model.get_types(),"Time","Number",
                                    75,1500);
        return this;
    }

    public Object buildActions() {
        System.out.println("ObserverSwarm::buildActions()");
        super.buildActions();
        model.buildActions();

        displayActions = new ActionGroupImpl(this);
        displaySchedule = new ScheduleImpl(this,displayFrequency);
        try {
            displayActions.createActionTo$message
                (raster,new Selector(raster.getClass(), "updateRaster",false));
            displayActions.createActionTo$message
                (graph, new Selector(graph.getClass(),
                                     "addPoints",false));
            displayActions.createActionTo$message
                (getActionCache(), new Selector(getActionCache().getClass(),
                                                "doTkEvents", true));
            
            displaySchedule.at$createAction(0,displayActions);
        } catch (SignatureNotFoundException e) {
            System.err.println("ObserverSwarm::buildActions() --Couldn't find method.");
            e.printStackTrace();
            System.exit(-1);
        } catch (NonUniqueMethodSignatureException e) {
            System.err.println("ObserverSwarm::buildActions() --NonUnique method.");
            e.printStackTrace();
            System.exit(-1);
        }

        return this;
    }

    public Activity activateIn(Swarm swarmContext) {
        super.activateIn(swarmContext);
        model.activateIn(this);
        displaySchedule.activateIn(this);
        return getActivity();
    }

    public void drop() {
        displayActions.drop();
        displaySchedule.drop();
        model.drop();
        graph.drop();
        raster.drop();
        super.drop();
    }
}
