import java.util.Iterator;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.HashSet;

import swarm.Globals;
import swarm.defobj.Zone;
import swarm.Selector;
import swarm.NonUniqueMethodSignatureException;
import swarm.SignatureNotFoundException;

import swarm.activity.Activity;
import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;

import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;

import java.awt.Color;

public class ModelSwarm extends SwarmImpl {
    private Payoffs payoffs = null;
    private ArrayList players = null;
    private HashSet strategies = null;
    private HashMap types = null;
    private ActionGroup modelActions = null;
    private Schedule modelSchedule = null;
    public int numTypes = 4;
    public int numSteps = 4;
    public int gridSize = 50;

    public SwarmRaster grid = null;

    public ModelSwarm(Zone aZone, SwarmRaster sr) {
        super(aZone);
        grid = sr;
        grid.setSize(gridSize,gridSize);
    }

    public Object buildObjects() {
	String strategies_name[]     = {"all-D","aTFT","TFT","all-C"};
	double  strategies_colors[][] = {{0.5,0.5,0.0},{0.0,0.0,1.0},{1.0,0.0,0.0},{0.9,0.6,0.5}};
	double strategies_ipq[][]    = {{1.0,0.0,0.0},{0.0,0.0,1.0},{1.0,1.0,0.0},{1.0,1.0,1.0}};

        System.out.println("ModelSwarm::buildObjects()");
        try {
            super.buildObjects();
            strategies = new HashSet(numTypes);
            types = new HashMap(numTypes);

	    for(int i=0;i<numTypes;i++) {

		Strategy s = (Strategy) Globals.env.lispAppArchiver.getObject("Strategy"+i);
		/*
		Strategy s = new Strategy(getZone());
		s.number= i;
		s.name  = strategies_name[i];
		s.red   = (float)strategies_colors[i][0];
		s.green = (float)strategies_colors[i][1];
		s.blue  = (float)strategies_colors[i][2];
		
		s.i     = strategies_ipq[i][0];
		s.p     = strategies_ipq[i][1];
		s.q     = strategies_ipq[i][2];
		*/
		s.color = new Color(s.red, s.blue, s.green);
		
		
		System.out.println("setting color to "+s.color);
		strategies.add(s);
		types.put(s,new HashSet(numTypes));
		

            }

            payoffs = new Payoffs();
            players = new ArrayList(gridSize*gridSize);

            int count = 0;
            Object[] strats = strategies.toArray();
            for(int y=0;y<gridSize;y++)
                for(int x=0;x<gridSize;x++) {

                    // Select strategy at random
                    int number = 
                        Globals.env.uniformIntRand.getIntegerWithMin$withMax
                        (0,numTypes-1);
                    Strategy strategy = (Strategy)strats[number];

                    // Create location
                    Location location = new Location(grid,x,y);
                    
                    // Create the player and assign chosen strategy
                    Prisoner prisoner = new Prisoner(payoffs, strategy, 
                                                     location, numSteps);
                    // Add player to list
                    players.add(count++,prisoner);

                    // Association location with prisoner
                    grid.putObjectAt(prisoner,location);
                }
        } catch (RuntimeException re) {
            System.err.println
                (re+" caught by ModelSwarm::buildObjects()");
            re.printStackTrace();
            System.exit(-1);
        }

        return this;
    }

    public Object buildActions() {
        System.out.println("ModelSwarm::buildActions()");
        super.buildActions();
        modelActions = new ActionGroupImpl(this);
        modelSchedule = new ScheduleImpl(this,1);
        try {
            modelActions.createActionTo$message
                (this, new Selector(getClass(),"playersReset",false));
            modelActions.createActionTo$message
                (this, new Selector(getClass(),"playersPlayNeighbors",false));
            modelActions.createActionTo$message
                (this, new Selector(getClass(),"playersMimicBest",false));
            modelActions.createActionTo$message
                (this, new Selector(getClass(),"update",false));
            modelSchedule.at$createAction(0,modelActions);
        } catch (SignatureNotFoundException e) {
            System.err.println("ModelSwarm::buildActions() -- Couldn't find method.");
            e.printStackTrace();
            System.exit(-1);
        } catch (NonUniqueMethodSignatureException e) {
            System.err.println("ModelSwarm::buildActions() -- NonUnique method.");
            e.printStackTrace();
            System.exit(-1);
        }
        return this;
    }
    
    public Activity activateIn(Swarm swarmContext) {
        super.activateIn(swarmContext);
        modelSchedule.activateIn(this);
        return getActivity();
    }

    public Object playersReset() {
        Iterator ndx = players.iterator();
        while (ndx.hasNext())
            ((Prisoner)ndx.next()).reset();
        return this;
    }
    public Object playersPlayNeighbors() {
        Iterator ndx = players.iterator();
        while (ndx.hasNext())
            ((Prisoner)ndx.next()).playNeighbors();
        return this;
    }
    public Object playersMimicBest() {
        Iterator ndx = players.iterator();
        while (ndx.hasNext())
            ((Prisoner)ndx.next()).mimicBest();
        return this;
    }

    public Object update() {
        Iterator ndx = types.keySet().iterator();
        while (ndx.hasNext()) ((HashSet)types.get(ndx.next())).clear();

        ndx = players.iterator();
        while (ndx.hasNext()) {
            Prisoner player = (Prisoner)ndx.next();
            Strategy key = player.get_strategy();
            HashSet strategyUsers = (HashSet)types.get(key);
            strategyUsers.add(player);
        }

        // Print out report
        System.out.print(Globals.env.getCurrentTime()+" ");
        ndx = types.keySet().iterator();
        while(ndx.hasNext()) {
            Strategy key = (Strategy)ndx.next();
            HashSet strategyUsers = (HashSet)types.get(key);
            System.out.print(key.name+": "+strategyUsers.size()+"  ");
        }
        System.out.println();

        return this;
    }

    public int get_gridSize() {
        return gridSize;
    }

    public HashSet get_strategies() {
        return strategies;
    }

    public HashMap get_types() {
        return types;
    }

    public ArrayList get_players() {
        return players;
    }
}
