import swarm.Selector;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.defobj.Zone;
import swarm.activity.Activity;
import cern.jet.random.Uniform;
import uchicago.src.sim.engine.*;
import uchicago.src.sim.space.*;
import uchicago.src.sim.util.SimUtilities;
import gui.DisplaySurface;
import gui.Object2DDisplay;
import gui.Value2DDisplay;
import gui.ColorMap;

public class HeatbugObserverSwarm extends SwarmImpl {
  Schedule displaySchedule;
  HeatbugModelSwarm modelSwarm;

  private DisplaySurface dsurf;

  public HeatbugObserverSwarm (Zone aZone) {
      super (aZone);
  }

  public Object buildObjects () {
    super.buildObjects ();

    modelSwarm = new HeatbugModelSwarm (getZone ());
    modelSwarm.buildObjects ();

    Object2DDisplay agentDisplay =
      new Object2DDisplay (modelSwarm.getWorld ());

    agentDisplay.setObjectList (modelSwarm.getHeatbugList ());

    // 64 shades of red
    ColorMap map = new ColorMap ();
    for (int i = 0; i < 64; i++)
      map.mapColor(i, i / 63.0, 0, 0);

    Value2DDisplay heatDisplay =
      new Value2DDisplay (modelSwarm.getSpace (), map);
    heatDisplay.setDisplayMapping(512, 0);

    dsurf = new DisplaySurface(heatDisplay.getSize(), "Heatbugs");
    dsurf.addDisplayable (heatDisplay, "Heat Space");
    dsurf.addDisplayableProbeable (agentDisplay, "Bugs");

    dsurf.display ();
    return this;
  }

  public Object updateDisplay () {
    dsurf.updateDisplay ();
    // dsurf.display ();
    return this;
  }

  public Object buildActions () {
    super.buildActions ();

    modelSwarm.buildActions ();
    displaySchedule = new ScheduleImpl (getZone (), 1);
    try {
      displaySchedule.at$createActionTo$message
        (0, this,
         new Selector (getClass (), "updateDisplay", false));
    } catch (Exception e) {
      e.printStackTrace (System.err);
    }
    return this;
  }

  public Activity activateIn (Swarm context) {
    super.activateIn (context);

    modelSwarm.activateIn (this);
    displaySchedule.activateIn (this);
    return getActivity ();
  }
}
