import java.util.Vector;
import java.util.ArrayList;

import uchicago.src.sim.space.*;
import cern.jet.random.Uniform;

import swarm.defobj.Zone;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.activity.ActionGroup;
import swarm.activity.ActionGroupImpl;
import swarm.activity.Activity;

import swarm.defobj.FCallImpl;
import swarm.defobj.FArgumentsImpl;
import swarm.Selector;

public class HeatbugModelSwarm extends SwarmImpl {
  public int numBugs = 100;
  public double evapRate = 0.99;
  public double diffusionConstant = 1.0;
  public int worldXSize = 80;
  public int worldYSize = 80;
  public int minIdealTemp = 17000;
  public int maxIdealTemp = 31000;
  public int minOutputHeat = 3000;
  public int maxOutputHeat = 10000;
  public float randomMoveProbability = 0.0f;

  public Schedule modelSchedule;
  public ArrayList heatbugList = new ArrayList();
  public Object2DTorus world;
  public HeatSpace space;

  public HeatbugModelSwarm (Zone aZone) {
    super (aZone);
  }

  public Object buildObjects () {
    space = new HeatSpace (diffusionConstant, evapRate,
                           worldXSize, worldYSize);
    world = new Object2DTorus (space.getSizeX (), space.getSizeY ());
    
    for (int i = 0; i < numBugs; i++) {
      int idealTemp =
        Uniform.staticNextIntFromTo (minIdealTemp, maxIdealTemp);
      int outputHeat =
        Uniform.staticNextIntFromTo (minOutputHeat, maxOutputHeat);
      int x, y;
      
      do {
        x = Uniform.staticNextIntFromTo (0, space.getSizeX () - 1);
        y = Uniform.staticNextIntFromTo (0, space.getSizeY () - 1);
      } while (world.getObjectAt (x, y) != null);
      
      Heatbug bug = new Heatbug (space, world, x, y, idealTemp, outputHeat,
                                 randomMoveProbability);
      world.putObjectAt (x, y, bug);
      heatbugList.add (bug);
    }
    return this;
  }

  public Object buildActions () {
    super.buildActions ();

    ActionGroup modelActions = new ActionGroupImpl (getZone ());

    try {
      modelActions.createActionTo$message
        (space, new Selector (space.getClass (), "diffuse", false));
      
      Heatbug proto = (Heatbug) heatbugList.get (0);
      Selector sel = 
        new Selector (proto.getClass (), "heatbugStep", false);

      modelActions.createFActionForEachHomogeneous$call
        (heatbugList,
         new FCallImpl (this, proto, sel,
                        new FArgumentsImpl (this, sel, true)));
    } catch (Exception e) {
      e.printStackTrace (System.err);
    }
    modelSchedule = new ScheduleImpl (getZone (), 1);
    modelSchedule.at$createAction (0, modelActions);
    return this;
  }

  public Activity activateIn (Swarm swarmContext) {
    super.activateIn (swarmContext);

    modelSchedule.activateIn (this);

    return getActivity ();
  }

  public ArrayList getHeatbugList () {
    return heatbugList;
  }
  public Discrete2DSpace getSpace () {
    return space;
  }
  public Object2DTorus getWorld () {
    return world;
  }
}
