// Paul Johnson  Dec. 28, 2000.  This class facilitates creation of
// a bar chart that is updated/repainted every time period.  The aim 
// is to minimize the amount of user-editing required. That is done by
// passing in all needed labels/collection/range information in the
// constructor.  Then, the method to update/redraw is called "update",
// as in the standard Swarm graph.


import java.util.Iterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayList;

import java.awt.Color;
import javax.swing.JFrame;

import swarm.Globals;

import ptolemy.plot.Plot;
public class RuleBarGraph extends Plot {
    private HashMap rules = null;
    private JFrame myFrame = null;
    public RuleBarGraph (String title, HashMap collection, 
                           String xLabel,
                           String yLabel, double xRange, double yRange) {
        myFrame = new JFrame();
        setTitle(title);
	 myFrame.setTitle(title);
        setCollection(collection);
        setXRange(0,xRange);
        setYRange(0,yRange);
        _xTop = (double)xRange;
        _yTop = (double)yRange;
        setMarksStyle("none");
        setXLabel(xLabel);
        setYLabel(yLabel);
        setButtons(true);
	setBars(.8,.2);

        //setPointsPersistence(1000);
        myFrame.setSize(400,300);
        myFrame.getContentPane().add(this);
        myFrame.show();
    }
    public synchronized void setCollection(HashMap collection) {
        rules = collection;
       //   int dataSetCount=0;
//          Iterator ndx = rules.keySet().iterator();
//          // rules are statically defined => we can do this once and for all
//          dataSets = new HashMap();
//          while (ndx.hasNext()) {
//              Strategy s = (Strategy)ndx.next();
//              dataSets.put(s,new Integer(dataSetCount));
//              addLegend(dataSetCount,s.name);
//              dataSetCount++;
	//        }
    }

    public synchronized Object update() {
        
        Iterator ndx = rules.keySet().iterator();
        boolean needRepaint = false;
       
	clear(0);
	clear(false);
	repaint();

        while (ndx.hasNext()) {
            Integer nextRuleID = (Integer)ndx.next();

	    int newPointX = nextRuleID.intValue();   
	    Rule aRule = (Rule) rules.get(nextRuleID);
	    double newPointY =  1.0*aRule.getTimesUsed()/(Globals.env.getCurrentTime()+1);
	
//  	    if (newPointX > _xTop+0.0) {
//                  setXRange(0,newPointX+5);
//                  needRepaint = true;
//              }


	
//  	    if (newPointY > _yTop+0.0) {
//  		setYRange(0,newPointY+5);
//  		needRepaint = true;
//              }
           
	    addPoint(0,newPointX,newPointY,false);
	   
	   
        }
        if (needRepaint)    repaint();

        return this;
    }

    public void drop() {
        rules.clear();
        myFrame.dispose();
    }
}







