import swarm.objectbase.SwarmImpl;
import swarm.objectbase.Swarm;
import swarm.defobj.Zone;
import swarm.space.Grid2d;
import swarm.gui.Raster;
import swarm.Globals;

import java.util.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Collections;
import java.util.HashMap;

public class Agent {
    int    ID;
    int    choice;
    int    memoryLen;
    int    numStrategies;
    int    numSamples;
    int    myStrategy;
    Rule bestActiveStrategy;
    HashMap rules;
    ArrayList activeStrategies;
    int numActive;
    int    totalAgents;
    double	d1, d2, d3, d4; // just for testing
    Bar theBar;
    ModelSwarm myModelSwarm;



    public Agent (int idnumber, HashMap list, int active){
	rules = list;
	numActive = active;
	ID = idnumber;
	this.numSamples = 1;
    }


    public void initStrats () {

	int i = 0;
	activeStrategies = new ArrayList(numActive);
	Integer x;

	//System.out.println(rules);

        List temp =  Arrays.asList(rules.keySet().toArray());
	 
	Collections.shuffle(temp);
       
	Iterator iterator = temp.iterator();
	Rule aRule = null;
	
	for (i=0; i<numActive; i++ ){
	    x = (Integer) temp.get(i);
  	    activeStrategies.add(rules.get(x));
  	}

	bestActiveStrategy = (Rule) activeStrategies.get(0);

//  	for (i=0; i<numActive; i++) {
//  	    Rule newRule = (Rule) activeStrategies.get(i);
//  	    System.out.println("Agent " + ID + "stratID: " + newRule.getID());
//  	}

	
    }



//////////////////////////////////////////////////////
// Agent makes a choice at random, then if it chooses
// to go, it tells the bar that.
// Note we take numSamples random variates, just to
// allow for timing tests.

    //This has been updated to randomly select from equally successful
    //strategies. It was in the Bar class before, I dunno why

    public Rule getBestActiveStrat () {
	int value;
	int count = 0;
	Rule[] equalGood = new Rule[numActive];
	Rule bestRule = null;

	Iterator iterator = activeStrategies.iterator();
	Rule aRule = null;
	
  	aRule = (Rule) iterator.next();
  	int bestNumSuccesses = aRule.getTimesSuccess();
	equalGood[0] = aRule;

  	while (iterator.hasNext()  ){
    	    aRule = (Rule) iterator.next();
  	    if ((value = aRule.getTimesSuccess()) > bestNumSuccesses)
  		{
  		    count= 0;
  		    bestNumSuccesses = value; 
  		    equalGood[0]=aRule;
  		}
  	    if (value == bestNumSuccesses)
  		{
  		    count ++;
  		    equalGood[count]=aRule;
  		}
  	}
	

	// System.out.println("Count for equalGood rules: " + count);
  	if (count == 0) bestRule =  equalGood[0];

  	if (count > 0) bestRule =  equalGood[Globals.env.uniformIntRand.getIntegerWithMin$withMax(0,count)];
	

	//bestRule = (Rule) activeStrategies.get(Globals.env.uniformIntRand.getIntegerWithMin$withMax(0,numActive-1));
	
	if (bestRule == null) System.exit(0);

	System.out.println("BestStrat method, Agent: " + ID + " best strategy is " + bestRule.getID() + " /" + count);

	
	bestActiveStrategy = bestRule;
	return bestActiveStrategy;
    }

    public int makeChoice (){
	int localchoice = 5;
  	Rule localBest;
	localBest = this.getBestActiveStrat();
  	localchoice = localBest.choose ();
	System.out.println("Model aClassVar is " + myModelSwarm.aClassVar);

	//choice = Globals.env.uniformIntRand.getIntegerWithMin$withMax (0,1);
	//System.out.println("Agent: " + ID + " best strategy is " + bestActiveStrat.getID() + "choice " + bestActiveStrat.choose() + "=" +  choice);

  	localBest.incTimesUsed();
	
  	if (localchoice == 1) { theBar.agentArriving(ID);}
	System.out.println("Agent rule in use: " + localBest.getID() + "pastchoice: " + choice + "New choice: " + localchoice );
	choice = localchoice; 
  	return localchoice;

    }

    public Rule getBestStrat (){
	return bestActiveStrategy;
    }


    public void updateStrategies (){
	;
    }


    public void sayHi() {
	System.out.println ("Hello, I'm agent " + ID);
    }

//  -(void) initStrats {
//    int i;
//    int arraySize;
//    arraySize=21;
//    if(numActive > 20) {
//      printf("!!!!!!!!Warning, More active strategies than exist.  How do I end");
//      printf(" program abnormally with an error?!!!!!!!!!!!\n");
//      printf("setting numActive to 5\n");
//      numActive = 5; 
//    }
//  	for(i=0; i< arraySize; i++) {
//  	  activeStrat[i] = 0;
//  	}
//          for(i=0; i<numActive; i++) {
//  	  myStrategy=[uniformIntRand getIntegerWithMin: 0 withMax: 20];
//  	  //set active strategies.
//  	  if(activeStrat[myStrategy] == 0) {
//  	    // printf("activate strategy %d ",myStrategy);
//  	    activeStrat[myStrategy]=1;
//  	  }else{
//  	    //If this strategy is already active, iterate until an unactive one
//  	    //is found.  !!!!!!numActive > 20 will send this while into
//  	    //an endless loop. 
//  	    while(activeStrat[myStrategy] == 1){
//  	      myStrategy--;
//  	      if(myStrategy <0) {myStrategy = 20;}
//              }
	   
//  	    activeStrat[myStrategy] = 1;
//  	  }
//  	}
	
      
//  }

//////////////////////////////////////////////////////////
// get/set methods

    public void setModelSwarm (ModelSwarm ms) { myModelSwarm = ms; }
    public int getID () { return ID;}
    public int getChoice () { return choice; }
    public int getMemoryLen () { return memoryLen;}
    public int getNumStrategies () { return numStrategies;}

    public void setTotalAgents (int x) { totalAgents = x; }
    public void setNumActive (int x) { numActive = x; }
    public void setMemoryLen (int m) { memoryLen = m ; }
    public void setNumStrategies (int s) { numStrategies = s;}
    public void setNumSamples (int s) { numSamples = s; }
    public void setTheBar (Bar  bar) { theBar = bar; }


}

