## Script (Python) "add_discussion"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=REQUEST,RESPONSE
##title=Adds FaqEntry to a FaqTopic
##

course_ssid = REQUEST['course_ssid']
title = REQUEST['title']
content = REQUEST['content']
faqlist= REQUEST['faqlist']
languageid = REQUEST['languageid']
username = REQUEST['username']


"""
	Calculating nodeid
"""

content_ssid = context.gnowql.getlatestVersion('Discussions')

content_info_dict = context.gnowql.getinfoFromSSID(content_ssid,'gbobjecttypes')
no_of_content = content_info_dict['instances']

if no_of_content == None:
   counter = 2
else:
   counter = len(no_of_content) + 2

content_nodeid='discussion' + str(counter)


"""
	Getting userid from the username
"""

uid = context.gnowql.getUserIdfromUsername(username)


"""
        Setting default values for title if it has not been specified
"""
if title == '':
   context.REQUEST.RESPONSE.redirect( context.portal_url() + '/'+ 'add_discussion_form?course_ssid='+course_ssid+'&msg=1' )

if content == ' ':
   content = "No Answer has been added to this FaqEntry."


dictParameters = {
		'nid':content_nodeid,
		'uid':uid,
		'status':'Public',
		'content':content,
		'title':[title],
		'description':'',
		'instanceof':['Discussions']
		}
context.gnowql.manageAddObject( dictParameters )

question_ssid = context.gnowql.getlatestVersion( content_nodeid )

dictParameters = {
		'uid':uid,
		'status':'Public',
		'subject1':question_ssid,
		'subject2':languageid,
		'relationtypes':'encodedin'
		 }

context.gnowql.manageAddRelation( dictParameters )

for faq in faqlist:
   dictParameters = {
                'uid':uid,
                'status':'Public',
                'subject1':faq,
                'subject2':question_ssid,
                'relationtypes':'references'
                 }

   context.gnowql.manageAddRelation( dictParameters )

datalist = context.unpickleComponent( course_ssid , 'discussion')
for faq in faqlist:
   datalist[0][faq].append(str(question_ssid))
context.pickleComponent( course_ssid , 'discussion' , datalist )
   
context.REQUEST.RESPONSE.redirect( context.portal_url() + '/refreshparent?courseid=' + str(course_ssid) + '&'+'page=discussview' )



