# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'

from genericTable import *
from set_checks import *
from gbroletypes import *
from gbcontent import *

class gbrelationtypes:
	
	def __init__( self, conString ):
		
		self.conn = psycopg2.connect(conString)
		self.cur = self.conn.cursor()
		self.nodetype = 'gbrelationtypes'

	def set( self, dictParameters, insname ):
		cur = self.cur
		nt=self.nodetype

		try:
			nid = dictParameters['nid']
			s = nid
			s = s.strip()
			print s
			wordlist = s.split()
			nid = ' '.join(wordlist)
		except:
			return "please enter nid"
		
	        uid = dictParameters['uid']
	        
		
		try:
			title = dictParameters['title']
		except:
			title = nid
		try:
			inversename = dictParameters['inversename']
		except:
			inversename =  []
		try:
			status = dictParameters['status']
		except:
			status = 'Public'

		try:
			content = dictParameters['content']
		except:
			content = ''

		try:
			description = dictParameters['description']
		except:
			description = ''

		
	        subtypes = []
	        subtypeof = []
		instanceof = []
		instances = []				   

		noofcommits = '0'
		noofchangesaftercommit = '0'
		history = [0]

		relations = []
		relationtypes = []
		attributes = []
		attributetypes = []

		

		try:
			transitive = dictParameters['transitive']
		except:
			transitive = 0
		try:
			reflexive = dictParameters['reflexive']
		except:
			reflexive = 0
		try:
			symmetry = dictParameters['symmetry']
		except:
			symmetry = 0

		
		nidtbl = tbl_nidinid( cur )
		inid = nidtbl.setval( nid, nt )
		if inid == 0:
			inid = nidtbl.getinid( nid, nt )
	
		inidtbl = tbl_inidssid( cur )
		ssid = inidtbl.setval_using_nid( nid, nt )
	
		""" uid and uri field is mandatory for objecttypes """
		mandatory_fields = ({'uid':uid})
		tra_ref_sym = ({'transitive':transitive, 'reflexive':reflexive, 'symmetry':symmetry})
		
		chk_ssid = ({'subtypes':subtypes, 'subtypeof':subtypeof, 'instanceof':instanceof, 'relations':relations, 'instances':instances, 'attributes':attributes, 'relationtypes':relationtypes, 'history':history, 'attributetypes':attributetypes})
	
		obj = def_set_checks()
		obj.manflds_chk(mandatory_fields)
		obj.tra_ref_sym(tra_ref_sym)
		status = obj.status(status)
		title = obj.title(title, nid)
		#obj.is_ssid_valid(chk_ssid, cur)

		try:
			role1 = dictParameters['role1']
			role1ssid = []
			if role1 <> []:
				for y in role1:
					try:
						r1ssid = int(str(obj.get_ssid_from_nid(y, cur)[-1]))
						print r1ssid
						role1ssid.append(r1ssid)
					except:
						return "Invalid Role1"
			else:
				return "Invalid Role One"
		except:
			return "Please Provide role1"

		try:
			role2 = dictParameters['role2']
			role2ssid = []
			if role2 <> []:
				for z in role2:
					try:
						r2ssid = int(str(obj.get_ssid_from_nid(z, cur)[-1]))
						print r2ssid
						role2ssid.append(r2ssid)
					except:
						return "Invalid Role2"
			else:
				return "Invalid Role Two"
		except:
			return "Please Provide role2"
		

		obj1 = gbroletypes(cur)
		roletypes = obj1.insert_rt({'role1':role1ssid, 'role2':role2ssid, 'card1':1, 'card2':1})
		
		print roletypes

		# creating list of networkfield

		listofnbhfield = []
		
		if role1ssid <> []:
			listofnbhfield.append('role1')
		if role2ssid <> []:
			listofnbhfield.append('role2')
		if relations <> []:
			listofnbhfield.append('relations')
		if relationtypes <> []:
			listofnbhfield.append('relationtypes')
		if attributes <> []:
			listofnbhfield.append('attributes')
		if attributetypes <> []:
			listofnbhfield.append('relations')
		if instanceof <> []:
			listofnbhfield.append('instanceof')
		if instances <> []:
			listofnbhfield.append('instances')
		if subtypeof <> []:
			listofnbhfield.append('subtypeof')
		if subtypes <> []:
			listofnbhfield.append('subtypes')

		# Calculating URI

		preuri = makeURI(nid, inid, nt, insname)
		print preuri
		
		insertionDict = {
		'status':status,
		'content':content,
		'inid': inid, 
		'subtypes':subtypes,
		'ssid': ssid, 
		'noofcommits':noofcommits,
		'subtypeof':subtypeof,
		'title':title,
		'uri':preuri,
		'relations':relations,
		'noofchangesaftercommit':noofchangesaftercommit,
		'instances':instances,
		'description':description,
		'attributes':attributes,
		'relationtypes':relationtypes,
		'history':history,
		'attributetypes':attributetypes,
		'uid':uid,
		'instanceof':instanceof,
		'roletypes':[roletypes],
		'isreflexive':reflexive,
		'issymmetrical':symmetry,
		'istransitive':transitive,
		'inversename':inversename
		}

		insertionDict = obj.insertionDict(insertionDict)

		""" to calculate fieldschanged, noofchangesaftercommit, changetype """
		fieldschanged = obj.fldschd(insertionDict, nt, nid, cur)
		
		modifications = obj.mod(fieldschanged)
		changetypes = obj.chgtyp(modifications)
	
		insertionDict.update({'fieldschanged':fieldschanged, 'noofchanges':modifications, 'changetype':changetypes})
	
		# obj.subjects_rettype(subjects, arity, nt)

		# do checking here of ssid, inid, nid, uid...

		print insertionDict
		
		s = storageSpec()

		gt = genericTable( cur, self.nodetype, s.dictTableNamesAndDefs[ self.nodetype ], s.dictTNamesFDefs[ self.nodetype ], 1 )
		gt.insert( insertionDict )

		# Setting NBH Props in respective nodes

		obj.set_nbh(ssid, listofnbhfield, cur)

		# creating snapshot at filesystem
		createURI(preuri, inid, ssid)

# 		# creating a pickle using the ssid
# 		dict=self.getNeighbourhood(nid,ssid)
# 		finaldict=dict[0]
# 		pickleobject(preuri,ssid,finaldict)


		print "Relation Type Added"
		self.conn.commit()
		self.conn.close()

# 	def getNeighbourhood( self, nid, ssid=0 ):
# 		"""
# 		"""
		
# 		sid = []
# 		queryResult = []
# 		cur = self.cur
# 		listofver = []
# 		dictofsnaps = {}
# 		listoffields=['ssid','inid','uid','noofchanges','fieldschanged','changetype','noofcommits','noofchangesaftercommit','history','gbtimestamp','inversename','istransitive','isreflexive','issymmetrical','status','uri','title','description','attributetypes','attributes','relationtypes','relations','subtypeof','subtypes','instanceof','instances','roletypes','mandatoryprops']
		
# 		obj = def_set_checks()

# 		if ssid == 0:
# 		   sid = obj.get_ssid_from_nid(nid, cur)
# 		else:
# 		   sid=[ssid]
		
# 		for x in sid:
# 			i = 0
# 			dictofsnaps = {}
# 			queryResult = cur.execute("select * from view_rt where ssid = " + str(x) + ";")
# 			queryResult = cur.fetchall()
# 			for y in listoffields:
# 			    dictofsnaps.update({y:queryResult[0][i]})
# 			    i=i+1

# 			print dictofsnaps
# 			listofver.append(dictofsnaps)

# 		return listofver


