# -*- coding: utf-8 -*-

#  parsing.py, Parsing the xml document

#  Copyright (C) 2007 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of <Program Name> is the Free Software Foundation Europe
#  (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__author__ = """Divya <divyas15@gmail.com>, Prasanta Kumar Baruah <prasanta.baruah@gmail.com>"""
__docformat__ = 'plaintext'

#! /usr/bin/env python

import xmlrpclib
import os, sys
import shutil
from xml.sax import make_parser
from xml.sax.handler import ContentHandler
from htm_mod import URLModification
from file_check import URLCheck

# Intializing global variables

# list_of_files =[]
lst = []
object_id = []
object_ref = []
resource_ref = []
sco_obj = []
I_count = 1
resource_list = []
dependency_list = []
dependency_files = []
course_Id = []
plone_objects=[]
plone_files = []
cour_structure = []
cour_schema = []
gnowsys_objects = []
Hashref_list = []
revised_HashrefList = []
files_lists = []
sequencing = []
controlMode = {}
sequencingRules = {}
limitConditions = {}
auxiliaryResources = {}
rollupRules = {}
objectives = {}
randomizationControls = {}
deliveryControls = {}
constrainedChoiceConsiderations = {}
rollupConsiderations = {}
preConditionRule = {}
postConditionRule = {}
exitConditionRule = {}
primaryObjective = {}
objective = {}
presentation = []

# Creating a class for parsing organization section of imsmanifest.xml file

class LO_instance(ContentHandler):
	"""
	Parse the Organizations section of the manifest file and collects all the LOs in the SCO
	Sequencing & Navigation Info are also collected
	"""

        def __init__(self, username, cour_counter, content_counter, gloss_counter, faqTop_counter, faqEnt_counter, links_counter):
	    """
	    initialize counter for different LOType with its respective count in DB & flags for elements of SCORM
	    """
	    
	    self.item_count = 0
            self.isOrganization = 0
            self.meta_count = 0
            self.istitle = 0
            self.ismetadata = 0
	    self.isItem = 0
	    self.course_counter = cour_counter
	    self.content_counter = content_counter
	    self.glossary_counter = gloss_counter
	    self.FaqTopics_counter = faqTop_counter
	    self.FaqEntries_counter = faqEnt_counter
	    self.link_counter = links_counter
	    self.courseId = ''
	    self.username = username
	    self.issequencing = 0
	    self.iscontrolMode = 0
	    self.issequencingRules = 0
	    self.islimitConditions = 0
	    self.isauxiliaryResources = 0
	    self.isrollupRules = 0
	    self.isobjectives = 0
	    self.israndomizationControls = 0
	    self.isdeliveryControls = 0
	    self.isconstrainedChoiceConsiderations = 0
	    self.isrollupConsiderations = 0
	    self.ispreConditionRule = 0
	    self.isexitConditionRule = 0
	    self.ispostConditionRule = 0
	    self.isruleCondition = 0
	    self.isruleAction = 0
	    self.isrollupRule = 0
	    self.isrollupCondition = 0
	    self.isrollupAction = 0
	    self.isprimaryObjective = 0
	    self.isobjective = 0
	    self.isminNormalizedMeasure = 0
	    self.ismapInfo = 0
	    self.ispresentation = 0
	    self.ishideLMSUI = 0
	    
	    
        def startElement(self, name, attrs):
	    """
	    Check for start elements of the manifest file & switch on their respective flags
	    """

	    elename = name.split(':')
	    print name
	    
	    if name == 'manifest':
		    print "inside manifest"
		    for i in range(len(lst)):
			    lst.pop()
		    for i in range(len(object_id)):
			    object_id.pop()
		    for i in range(len(object_ref)):
			    object_ref.pop()
		    for i in range(len(resource_ref)):
			    resource_ref.pop()
		    for i in range(len(sco_obj)):
			    sco_obj.pop()
		    for i in range(len(resource_list)):
			    resource_list.pop()
		    for i in range(len(dependency_list)):
			    dependency_list.pop()
		    for i in range(len(dependency_files)):
			    dependency_files.pop()
		    for i in range(len(course_Id)):
			    course_Id.pop()
		    for i in range(len(plone_objects)):
			    plone_objects.pop()
		    for i in range(len(plone_files)):
			    plone_files.pop()
		    
		    for i in range(len(cour_structure)):
			    cour_structure.pop()
		    for i in range(len(cour_schema)):
			    cour_schema.pop()
		    for i in range(len(gnowsys_objects)):
			    gnowsys_objects.pop()
		    for i in range(len(Hashref_list)):
			    Hashref_list.pop()
		    for i in range(len(revised_HashrefList)):
			    revised_HashrefList.pop()
		    for i in range(len(files_lists)):
			    files_lists.pop()
			    
	    

            if name == 'organization':
	        print "Organization"
	        self.isOrganization = 1
                self.course = attrs.get('identifier',"")
		#self.cour_id = 'sco_'+str(con.getProperty('object'))
		print self.course


            if name == 'item':
	        print "inside Item"
		self.isItem = 1
		if self.item_count == 0:
			#Generate the courseID
			self.courseId = "course" + str(self.course_counter)
			course_Id.append(self.courseId)
			print self.courseId
			print "Before adding the object"
                         
                        LO_list = [self.courseId, self.title]
                        plone_objects.append(LO_list)
			gnowsys_objects.append(LO_list)
			gnowsys_objects[-1].append('Courses')
						 
			sco_obj.append(self.courseId)
			
			deflt = []
			deflt.append(self.courseId)
			deflt.append('0')
                        cour_structure.append(deflt)
                self.item_count += 1
                self.identifier = attrs.get('identifier',"")
		print attrs.get('identifierref',"")
		if attrs.get('identifierref',"")=='' :
			self.identifierref = 'NULL'
                else:
			self.identifierref = attrs.get('identifierref',"")
		print self.identifierref

            if name == 'title':
	        print "inside title"
                self.istitle = 1
                self.title = ""

            if name == 'metadata':
	        print "inside metadata"
                self.meta_count +=1
                self.ismetadata = 1
                self.metadata = ""

	    #Sequencing Elements & Navigation Elements hereforth
	    if elename[-1] == 'sequencing':
		    self.issequencing = 1
		    sequencing.append({'item':sco_obj[-1]})

	    if elename[-1] == 'controlMode':
		    self.iscontrolMode = 1
		    self.controlMode_choice = attrs.get('choice',"")
		    self.controlMode_choiceExit = attrs.get('choiceExit',"")
		    self.controlMode_flow = attrs.get('flow',"")
		    self.controlMode_forwardOnly = attrs.get('forwardOnly',"")
		    self.controlMode_useCurrentAttemptObjectiveInfo = attrs.get('useCurrentAttemptObjectiveInfo',"")

	    if elename[-1] == 'sequencingRules':
		    self.issequencingRules = 1

	    if elename[-1] == 'preConditionRule':
		    self.ispreConditionRule = 1
		    self.ruleCondition_referencedObjective = ""
		    self.ruleCondition_measureThreshold = ""
		    self.ruleCondition_operator = ""
		    self.ruleCondition_condition = ""
		    self.ruleAction_action = ""

	    if elename[-1] == 'exitConditionRule':
		    self.isexitConditionRule = 1
		    self.ruleCondition_referencedObjective = ""
		    self.ruleCondition_measureThreshold = ""
		    self.ruleCondition_operator = ""
		    self.ruleCondition_condition = ""
		    self.ruleAction_action = ""

	    if elename[-1] == 'postConditionRule':
		    self.ispostConditionRule = 1
		    self.ruleCondition_referencedObjective = ""
		    self.ruleCondition_measureThreshold = ""
		    self.ruleCondition_operator = ""
		    self.ruleCondition_condition = ""
		    self.ruleAction_action = ""

	    if elename[-1] == 'ruleCondition':
		    self.isruleCondition = 1
		    self.ruleCondition_referencedObjective = attrs.get('referencedObjective',"")
		    self.ruleCondition_measureThreshold = attrs.get('measureThreshold',"")
		    self.ruleCondition_operator = attrs.get('operator',"")
		    self.ruleCondition_condition = attrs.get('condition',"")

	    if elename[-1] == 'ruleAction':
		    self.isruleAction = 1
		    self.ruleAction_action = attrs.get('action',"")

	    if elename[-1] == 'limitConditions':
		    self.islimitConditions = 1
		    self.limitConditions_attemptLimit = attrs.get('attemptLimit',"")
		    self.limitConditions_attemptAbsoluteDurationLimit = attrs.get('attemptAbsoluteDurationLimit',"")

	    if elename[-1] == 'auxiliaryResources':
		    self.isauxiliaryResources = 1

	    if elename[-1] == 'rollupRules':
		    self.isrollupRules = 1
		    self.rollupRules_rollupObjectiveSatisfied = attrs.get('rollupObjectiveSatisfied',"")
		    self.rollupRules_rollupProgressCompletion = attrs.get('rollupProgressCompletion',"")
		    self.rollupRules_objectiveMeasureWeight = attrs.get('objectiveMeasureWeight',"")
		    self.rollupRule_childActivitySet = ''
		    self.rollupRule_minimumCount = ''
		    self.rollupRule_minimumPercent = ''
		    self.rollupCondition_operator = ''
		    self.rollupCondition_condition = ''
		    self.rollupAction_action = ''

	    if elename[-1] == 'rollupRule':
		    self.isrollupRule = 1
		    self.rollupRule_childActivitySet = attrs.get('childActivitySet',"")
		    self.rollupRule_minimumCount = attrs.get('minimumCount',"")
		    self.rollupRule_minimumPercent = attrs.get('minimumPercent',"")

	    if elename[-1] == 'rollupCondition':
		    self.isrollupCondition = 1
		    self.rollupCondition_operator = attrs.get('operator',"")
		    self.rollupCondition_condition = attrs.get('condition',"")

	    if elename[-1] == 'rollupAction':
		    self.isrollupAction = 1
		    self.rollupAction_action = attrs.get('action',"")

	    if elename[-1] == 'objectives':
		    self.isobjectives = 1

	    if elename[-1] == 'primaryObjective':
		    self.isprimaryObjective = 1
		    self.primaryObjective_satisfiedByMeasure = attrs.get('satisfiedByMeasure',"")
		    self.primaryObjective_objectiveID = attrs.get('objectiveID',"")
		    self.primaryObjective_minNormalizedMeasure = ""
		    self.mapInfo_targetObjectiveID = ""
		    self.mapInfo_readSatisfiedStatus = ""
		    self.mapInfo_readNormalizedMeasure = ""
		    self.mapInfo_writeSatisfiedStatus = ""
		    self.mapInfo_writeNormalizedMeasure = ""


	    if elename[-1] == 'objective':
		    self.isobjective = 1
		    self.objective_satisfiedByMeasure = attrs.get('satisfiedByMeasure',"")
		    self.objective_objectiveID = attrs.get('objectiveID',"")
		    self.objective_minNormalizedMeasure = ""
		    self.mapInfo_targetObjectiveID = ""
		    self.mapInfo_readSatisfiedStatus = ""
		    self.mapInfo_readNormalizedMeasure = ""
		    self.mapInfo_writeSatisfiedStatus = ""
		    self.mapInfo_writeNormalizedMeasure = ""

	    if elename[-1] == 'minNormalizedMeasure':
		    self.isminNormalizedMeasure = 1
		    if self.isprimaryObjective:
			    self.primaryObjective_minNormalizedMeasure = ""
		    elif self.isobjective:
			    self.objective_minNormalizedMeasure = ""

	    if elename[-1] == 'mapInfo':
		    self.ismapInfo = 1
		    self.mapInfo_targetObjectiveID = attrs.get('targetObjectiveID',"")
		    self.mapInfo_readSatisfiedStatus = attrs.get('readSatisfiedStatus',"")
		    self.mapInfo_readNormalizedMeasure = attrs.get('readNormalizedMeasure',"")
		    self.mapInfo_writeSatisfiedStatus = attrs.get('writeSatisfiedStatus',"")
		    self.mapInfo_writeNormalizedMeasure = attrs.get('writeNormalizedMeasure',"")

	    if elename[-1] == 'randomizationControls':
		    self.israndomizationControls = 1
		    self.randomizationControls_randomizationTiming = attrs.get('randomizationTiming',"")
		    self.randomizationControls_selectCount = attrs.get('selectCount',"")
		    self.randomizationControls_reorderChildren = attrs.get('reorderChildren',"")
		    self.randomizationControls_selectionTiming = attrs.get('selectionTiming',"")

	    if elename[-1] == 'deliveryControls':
		    self.isdeliveryControls = 1
		    self.deliveryControls_tracked = attrs.get('tracked',"")
		    self.deliveryControls_completionSetByContent = attrs.get('completionSetByContent',"")
		    self.deliveryControls_objectiveSetByContent = attrs.get('objectiveSetByContent',"")

	    if elename[-1] == 'constrainedChoiceConsiderations':
		    self.isconstrainedChoiceConsiderations = 1
		    self.constrainedChoiceConsiderations_preventActivation = attrs.get('preventActivation',"")
		    self.constrainedChoiceConsiderations_constrainChoice = attrs.get('constrainChoice',"")

	    if elename[-1] == 'rollupConsiderations':
		    self.isrollupConsiderations = 1
		    self.rollupConsiderations_requiredForSatisfied = attrs.get('requiredForSatisfied',"")
		    self.rollupConsiderations_requiredForNotSatisfied = attrs.get('requiredForNotSatisfied',"")
		    self.rollupConsiderations_requiredForCompleted = attrs.get('requiredForCompleted',"")
		    self.rollupConsiderations_requiredForIncomplete = attrs.get('requiredForIncomplete',"")
		    self.rollupConsiderations_measureSatisfactionIfActive = attrs.get('measureSatisfactionIfActive',"")

	    if elename[-1] == 'presentation':
		    self.ispresentation = 1
		    #presentation = []
		    presentation.append([sco_obj[-1]])

	    if elename[-1] == 'hideLMSUI':
		    self.ishideLMSUI = 1
		    self.hideLMSUI = ""

            return
            
        def characters(self, ch):
	    """
	    Collects the Element's Character Set
	    """
	    
            if self.istitle == 1:
                self.title = self.title+ch
                
            if self.ismetadata == 1:
                self.metadata = ch

	    if self.isminNormalizedMeasure and self.isprimaryObjective:
		    self.primaryObjective_minNormalizedMeasure += ch

	    if self.isminNormalizedMeasure and self.isobjective:
		    self.objective_minNormalizedMeasure += ch

	    if self.ispresentation and self.ishideLMSUI:
		    self.hideLMSUI += ch
            
        def endElement(self, name):
	    """
	    Check for end elements of the manifest file & switch off their respective flags
	    """
	    
	    elename=name.split(':')
            print name
	    
            if name == 'title':
	        #Id for LO is generated & title is associated with it
	        print "Close of title"
                self.istitle = 0
		
		if self.isItem and self.isOrganization and self.meta_count <= 1:
			#Works for SCORM files being taken from platforms other than SELF
			if self.item_count == 1:
				pass
			else:
				self.content_counter += 1 
			contentId = "content" + str(self.content_counter)
			self.newID = contentId
			object_id.append(self.newID)
			object_ref.append(self.identifierref)
			print self.newID

			LO_list = [self.newID, self.title]
                        plone_objects.append(LO_list)
			gnowsys_objects.append(LO_list)
			gnowsys_objects[-1].append('Content')

			tpl = []
			tpl.append(self.newID)
			tpl.append(sco_obj[-1])
                        cour_structure.append(tpl)

			sco_obj.append(self.newID)

		
		if self.isOrganization and self.meta_count > 1:
		    #Works for files being exported from SELF platform
		    print self.identifier, self.identifierref, self.title, self.metadata, self.course

		    if self.metadata in ['Content', 'Glossary', 'FaqTopics', 'Tests']:
                            if self.metadata == 'Content':
				    counter = self.content_counter
				    self.content_counter += 1
			    elif self.metadata == 'Glossary':
				    counter = self.glossary_counter
				    self.glossary_counter += 1
			    elif self.metadata == 'FaqTopics':
				    counter = self.FaqTopics_counter
				    self.FaqTopics_counter += 1
			    contentId = self.metadata + str(counter)
			    self.newID = contentId.encode()
			    object_id.append(self.newID)
			    object_ref.append(self.identifierref)
			    print self.newID

                            LO_list = [self.newID, self.title]
                            plone_objects.append(LO_list)
			    gnowsys_objects.append(LO_list)
			    gnowsys_objects[-1].append(self.metadata.encode())
			    
			    if self.metadata == 'Content':

				    tpl = []
				    tpl.append(self.newID)
				    tpl.append(sco_obj[-1])
                                    cour_structure.append(tpl)
				
			    sco_obj.append(self.newID)
				
		    if self.metadata in ['FaqEntries', 'TestsQuestions', 'Links']:

                           if self.metadata == 'FaqEntries':
				   counter = self.FaqEntries_counter
				   self.FaqEntries_counter += 1
			   elif self.metadata == 'Links':
				   counter = self.link_counter
				   self.link_counter += 1
			   contentId = self.metadata + str(counter)
			
			   self.newID = contentId.encode()
			   object_id.append(self.newID)
			   object_ref.append(self.identifierref)
			   print self.newID
			   self.relID = sco_obj[-1]
			
                           LO_list = [self.newID, self.title]
                           plone_objects.append(LO_list)
			   gnowsys_objects.append(LO_list)
			   gnowsys_objects[-1].append(self.metadata.encode())
			   gnowsys_objects[-1].append(self.relID)

			   sco_obj.append(self.newID)
		    

            if name == 'metadata':
                self.ismetadata = 0

	    if name == 'item':
		    sco_obj.pop()
		    
	    if name == 'organization':
		    self.isOrganization = 0

	    if elename[-1] == 'sequencing':
		    self.issequencing = 0
		    sequencing[-1]['controlMode'] = controlMode
		    sequencing[-1]['sequencingRules'] = sequencingRules
		    sequencing[-1]['limitConditions'] = limitConditions
		    sequencing[-1]['auxiliaryResources'] = auxiliaryResources
		    sequencing[-1]['rollupRules'] = rollupRules
		    sequencing[-1]['objectives'] = objectives
		    sequencing[-1]['randomizationControls'] = randomizationControls
		    sequencing[-1]['deliveryControls'] = deliveryControls
		    sequencing[-1]['constrainedChoiceConsiderations'] = constrainedChoiceConsiderations
		    sequencing[-1]['rollupConsiderations'] = rollupConsiderations

	    if elename[-1] == 'controlMode':
		    self.iscontrolMode = 0
		    controlMode['choice'] = self.controlMode_choice 
		    controlMode['choiceExit'] = self.controlMode_choiceExit
		    controlMode['flow'] = self.controlMode_flow
		    controlMode['forwardOnly'] = self.controlMode_forwardOnly
		    controlMode['useCurrentAttemptObjectiveInfo'] = self.controlMode_useCurrentAttemptObjectiveInfo

	    if elename[-1] == 'sequencingRules':
		    self.issequencingRules = 0
		    sequencingRules['preConditionRule'] = preConditionRule
		    sequencingRules['postConditionRule'] = postConditionRule
		    sequencingRules['exitConditionRule'] = exitConditionRule

	    if elename[-1] == 'preConditionRule':
		    self.ispreConditionRule = 0
		    preConditionRule['referencedObjective'] = self.ruleCondition_referencedObjective
		    preConditionRule['measureThreshold'] = self.ruleCondition_measureThreshold
		    preConditionRule['operator'] = self.ruleCondition_operator
		    preConditionRule['condition'] = self.ruleCondition_condition
		    preConditionRule['action'] = self.ruleAction_action

	    if elename[-1] == 'exitConditionRule':
		    self.isexitConditionRule = 0
		    exitConditionRule['referencedObjective'] = self.ruleCondition_referencedObjective
		    exitConditionRule['measureThreshold'] = self.ruleCondition_measureThreshold
		    exitConditionRule['operator'] = self.ruleCondition_operator
		    exitConditionRule['condition'] = self.ruleCondition_condition
		    exitConditionRule['action'] = self.ruleAction_action

	    if elename[-1] == 'postConditionRule':
		    self.ispostConditionRule = 0
		    postConditionRule['referencedObjective'] = self.ruleCondition_referencedObjective
		    postConditionRule['measureThreshold'] = self.ruleCondition_measureThreshold
		    postConditionRule['operator'] = self.ruleCondition_operator
		    postConditionRule['condition'] = self.ruleCondition_condition
		    postConditionRule['action'] = self.ruleAction_action

	    if elename[-1] == 'ruleCondition':
		    self.isruleCondition = 0

	    if elename[-1] == 'ruleAction':
		    self.isruleAction = 0

	    if elename[-1] == 'limitConditions':
		    self.islimitConditions = 0
		    limitConditions['attemptLimit'] = self.limitConditions_attemptLimit
		    limitConditions['attemptAbsoluteDurationLimit'] = self.limitConditions_attemptAbsoluteDurationLimit

	    if elename[-1] == 'auxiliaryResources':
		    self.isauxiliaryResources = 0

	    if elename[-1] == 'rollupRules':
		    self.isrollupRules = 0
		    rollupRules['rollupObjectiveSatisfied'] = self.rollupRules_rollupObjectiveSatisfied
		    rollupRules['rollupProgressCompletion'] = self.rollupRules_rollupProgressCompletion
		    rollupRules['objectiveMeasureWeight'] = self.rollupRules_objectiveMeasureWeight
		    rollupRules['childActivitySet'] = self.rollupRule_childActivitySet
		    rollupRules['minimumCount'] = self.rollupRule_minimumCount
		    rollupRules['minimumPercent'] = self.rollupRule_minimumPercent
		    rollupRules['operator'] = self.rollupCondition_operator
		    rollupRules['condition'] = self.rollupCondition_condition
		    rollupRules['action'] = self.rollupAction_action

	    if elename[-1] == 'rollupRule':
		    self.isrollupRule = 0

	    if elename[-1] == 'rollupCondition':
		    self.isrollupCondition = 0

	    if elename[-1] == 'rollupAction':
		    self.isrollupAction = 0

	    if elename[-1] == 'objectives':
		    self.isobjectives = 0
		    objectives['primaryObjective'] = primaryObjective
		    objectives['objective'] = objective

	    if elename[-1] == 'primaryObjective':
		    self.isprimaryObjective = 0
		    primaryObjective['satisfiedByMeasure'] = self.primaryObjective_satisfiedByMeasure
		    primaryObjective['objectiveID'] = self.primaryObjective_objectiveID
		    primaryObjective['minNormalizedMeasure'] = self.primaryObjective_minNormalizedMeasure
		    primaryObjective['targetObjectiveID'] = self.mapInfo_targetObjectiveID
		    primaryObjective['readSatisfiedStatus'] = self.mapInfo_readSatisfiedStatus
		    primaryObjective['readNormalizedMeasure'] = self.mapInfo_readNormalizedMeasure
		    primaryObjective['writeSatisfiedStatus'] = self.mapInfo_writeSatisfiedStatus
		    primaryObjective['writeNormalizedMeasure'] = self.mapInfo_writeNormalizedMeasure

	    if elename[-1] == 'objective':
		    self.isobjective = 0
		    objective['satisfiedByMeasure'] = self.objective_satisfiedByMeasure
		    objective['objectiveID'] = self.objective_objectiveID
		    objective['minNormalizedMeasure'] = self.objective_minNormalizedMeasure
		    objective['targetObjectiveID'] = self.mapInfo_targetObjectiveID
		    objective['readSatisfiedStatus'] = self.mapInfo_readSatisfiedStatus
		    objective['readNormalizedMeasure'] = self.mapInfo_readNormalizedMeasure
		    objective['writeSatisfiedStatus'] = self.mapInfo_writeSatisfiedStatus
		    objective['writeNormalizedMeasure'] = self.mapInfo_writeNormalizedMeasure

	    if elename[-1] == 'minNormalizedMeasure':
		    self.isminNormalizedMeasure = 0

	    if elename[-1] == 'mapInfo':
		    self.ismapInfo = 0

	    if elename[-1] == 'randomizationControls':
		    self.israndomizationControls = 0
		    randomizationControls['randomizationTiming'] = self.randomizationControls_randomizationTiming
		    randomizationControls['selectCount'] = self.randomizationControls_selectCount
		    randomizationControls['reorderChildren'] = self.randomizationControls_reorderChildren
		    randomizationControls['selectionTiming'] = self.randomizationControls_selectionTiming

	    if elename[-1] == 'deliveryControls':
		    self.isdeliveryControls = 0
		    deliveryControls['tracked'] = self.deliveryControls_tracked
		    deliveryControls['completionSetByContent'] = self.deliveryControls_completionSetByContent
		    deliveryControls['objectiveSetByContent'] = self.deliveryControls_objectiveSetByContent

	    if elename[-1] == 'constrainedChoiceConsiderations':
		    self.isconstrainedChoiceConsiderations = 0
		    constrainedChoiceConsiderations['preventActivation'] = self.constrainedChoiceConsiderations_preventActivation
		    constrainedChoiceConsiderations['constrainChoice'] = self.constrainedChoiceConsiderations_constrainChoice

	    if elename[-1] == 'rollupConsiderations':
		    self.isrollupConsiderations = 0
		    rollupConsiderations['requiredForSatisfied'] = self.rollupConsiderations_requiredForSatisfied
		    rollupConsiderations['requiredForNotSatisfied'] = self.rollupConsiderations_requiredForNotSatisfied
		    rollupConsiderations['requiredForCompleted'] = self.rollupConsiderations_requiredForCompleted
		    rollupConsiderations['requiredForIncomplete'] = self.rollupConsiderations_requiredForIncomplete
		    rollupConsiderations['measureSatisfactionIfActive'] = self.rollupConsiderations_measureSatisfactionIfActive

	    if elename[-1] == 'presentation':
		    self.ispresentation = 0

	    if elename[-1] == 'hideLMSUI':
		    self.ishideLMSUI = 0
		    presentation[-1].append(self.hideLMSUI)

#             if name == 'organizations':
#                 url2 = self.conpath + '/kb/data/attribute/' + self.courseId[0] + '/' + self.courseId[1] + '/' + self.courseId + '.CourseStructure'
#                 con2 = xmlrpclib.Server(url2)
#                 con2.setAttributeValue(cour_structure)

        def ploneLO(self):
	    """
	    Returns list of LOs to be added to plone
	    """
	    
            return plone_objects

        def gnowsysLO(self):
	    """
	    Returns list of LOs to be added to gnowsys along with its Structure
	    """
	    
	    cour_schema.append(self.courseId)
	    cour_schema.append(gnowsys_objects)
	    cour_schema.append(cour_structure)
	    return cour_schema

	def value(self):
	    """
	    Returns a list which is required as reference in import_file Class 
	    """

	    resource_ref.append(object_id)
	    resource_ref.append(object_ref)
	    resource_ref.append(course_Id)
	    return resource_ref

	def seqinfo(self):
	    """
	    Returns the list of Sequencing info
	    """
	    
	    return sequencing

        def navinfo(self):
	    """
	    Returns the list of Navigation info
	    """
	    
	    return presentation
	
# Class for parsing resources section of imsmanifest file

class import_file( ContentHandler ):
    """
    Parse the Resources section of the manifest file and collects the list of all files associated with each LOs
    """
	
    def __init__(self, search, username,CLIENT_HOME, instance_name):
	    """
	    Initialize variables to store user & environment info 
	    """
	    self.href = ''
	    self.res_ref = search
	    self.username = username
	    self.isRes = 0
	    self.FilePath = ''
	    self.ishref = 0
	    self.I_count = 1
	    self.instance_name = instance_name
	    self.dependency = 0
	    self.f_count = 0
	    self.course_ID = self.res_ref[2][-1]
	    self.CLIENT_HOME = CLIENT_HOME
	    self.list_of_files = []
	    
    def startElement(self, name, attrs):
        """
	Check for start elements of the manifest file & switch on their respective flags
	"""

#         if name == 'resources':
# 	    self.FileStoragePath = self.CLIENT_HOME+'/GB/'+self.instance_name+'/gbobjects/'+self.course_ID[0]+'/'+self.course_ID[1]+'/'+self.course_ID
# 	    #os.system('mkdir "'+self.FileStoragePath+'"')
# 	    self.FileStoragePath = self.FileStoragePath + '/'
        if name == 'resource':
	    self.path = ''
	    self.isRes = 1
 	    self.list_of_files =[]
            self.identifier = attrs.get('identifier',"")
            self.href = attrs.get('href',"")
	    dependency_list.append([self.identifier])
	    dependency_list[-1].append(self.href)
	    
	    self.hrefpath = '/tmp/' + self.username + '/' + self.href.replace('%20', ' ')
#	    print dependency_list
	    if self.href <> '':
		    self.ishref = 1
		    path_var = self.href
		    self.path = path_var.split('/')

		    for self.obj,self.ref in zip(self.res_ref[0],self.res_ref[1]):

			    if self.identifier == self.ref:    
				    self.object = self.obj
#				    self.list_of_files.append(self.object)
				    self.FileStoragePath = self.CLIENT_HOME+'/GB/'+self.instance_name+'/gbobjects/'+self.obj[0]+'/'+self.obj[1]+'/'+self.obj+'/'


	    if self.href == '':
		    self.dependency = 1
		    dependency_files.append([self.identifier])
		    if len(dependency_list) > 1:
			    for l in range(len(dependency_list)-1):
				    for l_item in dependency_list[l]:
					    if self.identifier == l_item:
						    print dependency_list[l][1]
						    path_var = dependency_list[l][1]
						    print path_var
						    self.path = path_var.split('/')
		    else:
			    self.path = ''
		        
		    self.FileStoragePath = self.CLIENT_HOME+'/GB/'+self.instance_name+'/gbobjects/'+self.course_ID[0]+'/'+self.course_ID[1]+'/'+self.course_ID + '/'+ 'dependency'
		    os.system('mkdir "'+self.FileStoragePath+'"')
		    self.FileStoragePath = self.FileStoragePath + '/'


	if name == 'file':
	    self.f_count = self.f_count + 1
	    self.file_href = attrs.get('href',"")
	    self.FilePath = ''
	    rel_file = self.file_href
	    self.rel_file = rel_file.split('/')
	    self.rel = self.rel_file[-1]
	    self.count = 0
	    size = len(self.rel_file)
	    self.file_hrefpath = '/tmp/' + self.username + '/' +self.file_href.replace('%20', ' ')
	    print self.path
	    path_len = len(self.path)
	    #self.path.replace('%20', ' ')
	    self.maintain_path = self.FileStoragePath
	    for i in range(size-1):
		    
		    if i<=(path_len-1) and self.path[i] == self.rel_file[i]:
			    pass
		    else:
# 			    self.count = self.count + 1
			    
# 			    if os.path.exists(self.maintain_path+self.rel_file[i].replace('%20', ' ')):
# 				   self.maintain_path = self.maintain_path + self.rel_file[i].replace('%20', ' ')+'/'
				   
# 			    else:
# 				   os.system('mkdir "'+self.maintain_path+self.rel_file[i].replace('%20', ' ')+'"')
# 				   self.maintain_path = self.maintain_path + self.rel_file[i].replace('%20', ' ')+'/'
			    self.FilePath = self.FilePath + self.rel_file[i].replace('%20', ' ')+'/'

            if path_len:
		    if self.path[-1] == self.rel:
			    pass
		    else:
# 			    if self.rel[(len(self.rel)-4):] == 'html':
# 				    os.chmod(self.file_hrefpath, 0644)
# 			    	    URLCheck(self.file_hrefpath)
			    self.list_of_files.append(self.file_href)
#			    os.system('cp "' + self.file_hrefpath + '" "' + self.maintain_path + self.rel+'"')
			    self.FilePath = self.FilePath + self.rel
	    else:
# 		    if self.rel[(len(self.rel)-4):] == 'html':
# 			    os.chmod(self.file_hrefpath, 0644)
# 			    URLCheck(self.file_hrefpath)
		    self.list_of_files.append(self.file_href)
#		    os.system('cp "' + self.file_hrefpath + '" "' + self.maintain_path + self.rel+'"')
		    self.FilePath = self.FilePath + self.rel

	    if self.dependency == 1:
		    if len(self.FilePath) <> 0:
			    dependency_files[-1].append(self.FilePath)


        if name == 'dependency':

		self.depend_identifierref = attrs.get('identifierref',"")
		dependency_list[-1].append(self.depend_identifierref)

        return

    def endElement(self, name):
	    """
	    Check for end elements of the manifest file & switch off their respective flags
	    """

	    if name == 'file':
		    if self.f_count == 1:
			    pass
		    elif self.f_count == 2 and len(self.FilePath) <> 0:
			    resource_list.append([self.FilePath])
		    else:
			    if len(self.FilePath) <> 0:
				    resource_list[-1].append(self.FilePath)
		    		    
            
            if name == 'resource':
 	        if self.f_count < 2:
 			resource_list.append([])
	        
		
	        self.dependency = 0
                self.isRes = 0
		self.new_conpath = ''
		if self.ishref == 1:
			#os.system('cp "'+ self.hrefpath + '" '+self.FileStoragePath+self.object+'.html')
			print "Adding data to " + self.object

			Hashref_list.append([self.object])
			Hashref_list[-1].append(resource_list[-1])
			
			try:
				os.chmod(self.hrefpath, 0644)
				URLModification(self.hrefpath, resource_list[-1], self.object)
				files_lists.append( [ self.object, self.href, self.list_of_files ] )
                                file_list = [self.object, self.hrefpath]
                                plone_files.append(file_list)
			except:
				print "Invalid html file", self.object
		self.ishref = 0
		self.f_count = 0
		if len(dependency_list[-1]) < 3:
			dependency_list.pop(-1)
		else:
			pass


            if name == 'metadata':
                self.ismetadata = 0
	
	    if name == 'resources':
		    revised_HashrefList.append(dependency_list)
		    revised_HashrefList.append(self.res_ref)
		    revised_HashrefList.append(dependency_files)

    def plonedata(self):
        """
	Returns a list of files specifying content for each plone object
	"""
        return plone_files

    def HashrefList(self):
        """
	Returns a list of files associated with each LO
	"""
	return Hashref_list
	
    def RevisedHashrefList(self):
        """
	Returns new list in case of occurance of dependency element in manifest file
	"""
	return revised_HashrefList


    def newFileList(self):
        return files_lists
