# -*- coding: utf-8 -*-

#  manifest.py

#  Copyright (C) 2007 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of <Program Name> is the Free Software Foundation Europe
#  (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__author__ = """Divya <divyas15@gmail.com>, Prasanta Kumar Baruah <prasanta.baruah@gmail.com>"""
__docformat__ = 'plaintext'

import re, sys, os, time
from xml import sax
from Products.selfApp.Extensions.htmparse import MyHTMLParser
from Products.selfApp.Extensions.file_codec import fun_id
from Products.selfApp.Extensions.htm_update import URLModification
from xml.sax.saxutils import XMLGenerator
from xml.sax.xmlreader import AttributesNSImpl
import xmlrpclib
import string
import urllib2

# Establishing a connection to the gnowsys database

#con=xmlrpclib.Server('http://admin:hidagger@localhost:8080/ATUTOR-SELF/kb')


LOG_LEVELS = ['DEBUG', 'WARNING', 'ERROR']

LOM_LEVELS = ['http://ltsc.ieee.org/xsd/LOM']

MANIFEST_ELE = ['metadata', 'organizations', 'resources', 'manifest', 'adlcp:sequencingCollection']

LOM_ELE = ['general', 'lifeCycle', 'metaMetadata', 'technical', 'educational', 'rights', 'relation', 'annotation', 'classification']

GENERAL_ELE = ['identifier', 'title', 'language', 'description', 'keyword', 'coverage', 'structure', 'aggregationLevel']

IDENTIFIER_ELE = ['catalog', 'entry']

STR_ELE = ['string', 'language', 'fake']

VOC_ELE = ['source', 'value', 'LOMv1.0']

DATE_ELE = ['dateTime', 'description']

VCARD_ELE = ['BEGIN:VCARD\nFN:', 'END:VCARD']

DURATION_ELE = ['duration', 'description']

LIFECYCLE_ELE = ['version', 'status', 'contribute']

CONTRIBUTE_ELE = ['role', 'entity', 'date']

metaMETADATA_ELE = ['identifier', 'contribute', 'metadataSchema', 'language']

TECHNICAL_ELE = ['format', 'size', 'location', 'requirement', 'installationRemarks', 'otherPlatformRequirements', 'duration']

REQUIREMENT_ELE = ['orComposite']

orCOMPOSITE_ELE = ['type', 'name', 'minimumVersion', 'maximumVersion']

EDUCATIONAL_ELE = ['interactivityType', 'learningResourceType', 'interactivityLevel', 'semanticDensity', 'intendedEndUserRole', 'context', 'typicalAgeRange', 'difficulty', 'typicalLearningTime', 'description', 'language']

LEARNING_RESOURCE = ['exercise', 'simulation', 'questionnaire', 'diagram', 'figure', 'graph', 'index', 'slide', 'table', 'narrative text', 'exam', 'experiment', 'problem statemenet', 'self assessment', 'lecture']

RIGHTS_ELE = ['cost', 'copyrightAndOtherRestrictions', 'description']

RELATION_ELE = ['kind', 'resource']

RESOURCE_ELE = ['identifier', 'description']

ANNOTATION_ELE = ['entity', 'date', 'description']

CLASSIFICATION_ELE = ['purpose', 'taxonPath', 'description', 'keyword']

TAXONPATH_ELE = ['source', 'taxon']

TAXON_ELE = ['id', 'entry']

MAN_ATTRS_QNAME = ['identifier', 'version', 'xml:base', 'xmlns', 'xmlns:adlcp', 'xmlns:xsi', 'xsi:schemaLocation']

MAN_ATTRS_VALS = ['SAMPLE1', '1.3', 'resources', 'http://www.imsglobal.org/xsd/imscp_v1p1', 'http://www.adlnet.org/xsd/adlcp_v1p3', 'http://www.w3.org/2001/XMLSchema-instance', 'http://www.adlnet.org/xsd/adlcp_v1p3adlcp_v1p3.xsd']

META_DATA = ['ADL SCORM', 'CAM 1.3']

SEQUENCING_ELE = ['controlMode', 'sequencingRules', 'limitConditions', 'auxiliaryResources', 'rollupRules', 'objectives', 'randomizationControls', 'deliveryControls', 'adlcp:constrainedChoiceConsiderations', 'adlcp:rollupConsiderations']

SEQUENCINGRULES_ELE = ['preConditionRule', 'exitConditionRule', 'postConditionRule']

CONDITIONRULE_ELE = ['ruleConditions', 'ruleAction']

RULECONDITIONS_ELE = ['ruleCondition']

ROLLUPRULES_ELE = ['rollupRule']

ROLLUPRULE_ELE = ['rollupConditions', 'rollupAction']

ROLLUPCONDITIONS_ELE = ['rollupCondition']

OBJECTIVES_ELE = ['primaryObjective', 'objective']

OBJECTIVE_ELE = ['minNormalizedMeasure', 'mapInfo']

course_ID = ''

class xml_logger:
    
    def __init__(self, output, encoding, username, ins_name):
         """
         Set up a logger object, which takes SAX events and outputs
         an XML manifest file
         """
         self.instance_name = ins_name
         self.username = username
         #self.conpath = conpath
         #self.con = xmlrpclib.Server(self.conpath)
         #self.base_path = conpath.replace('/kb', '')
         #self.base_con = xmlrpclib.Server(self.base_path)
         #self.instance_name = self.base_con.getId()

         logger = XMLGenerator(output, encoding)
         logger.startDocument()
         
         man_attrs_vals = {
             (None, MAN_ATTRS_QNAME[0]): MAN_ATTRS_VALS[0],
             (None, MAN_ATTRS_QNAME[1]): MAN_ATTRS_VALS[1],
             (None, MAN_ATTRS_QNAME[2]): MAN_ATTRS_VALS[2],
             (None, MAN_ATTRS_QNAME[3]): MAN_ATTRS_VALS[3],
             (None, MAN_ATTRS_QNAME[4]): MAN_ATTRS_VALS[4],
             (None, MAN_ATTRS_QNAME[5]): MAN_ATTRS_VALS[5],
             (None, MAN_ATTRS_QNAME[6]): MAN_ATTRS_VALS[6]
             }
         man_attrs_qname = {
             (None, MAN_ATTRS_QNAME[0]): MAN_ATTRS_QNAME[0],
             (None, MAN_ATTRS_QNAME[1]): MAN_ATTRS_QNAME[1],
             (None, MAN_ATTRS_QNAME[2]): MAN_ATTRS_QNAME[2],
             (None, MAN_ATTRS_QNAME[3]): MAN_ATTRS_QNAME[3],
             (None, MAN_ATTRS_QNAME[4]): MAN_ATTRS_QNAME[4],
             (None, MAN_ATTRS_QNAME[5]): MAN_ATTRS_QNAME[5],
             (None, MAN_ATTRS_QNAME[6]): MAN_ATTRS_QNAME[6]
             }
         
         attrs = AttributesNSImpl({}, {})
         
         attrs = AttributesNSImpl(man_attrs_vals, man_attrs_qname)
         logger.startElementNS((None, 'manifest'), 'manifest', attrs)
         self._logger = logger
                          
         self._output = output
         self._encoding = encoding
         return

    def write_entry(self, ID, courseStructure, course_info, type_info, CLIENT_HOME):
         self.CLIENT_HOME = CLIENT_HOME
         item = []
         item_ID = []
         attr_vals = {
             (None, 'default'): ID,
             }
         attr_qnames = {
             (None, 'default'): 'default'
             }
         attrs = AttributesNSImpl(attr_vals, attr_qnames)
         self._logger.startElementNS((None, MANIFEST_ELE[1]), MANIFEST_ELE[1], attrs)


         #For now escape this part assuming only courses to be imported
         """	  
	 if type == 'Courses':
		course_ID = ID
	 else:
		self.course = self.con.getNeighbourhood(ID, 'object', ['relations'], [['haspart', '1']])
		course_ID = self.course[0][0][1][0]
         """
         
	 #self.struct = self.con.getNeighbourhood(course_ID+'.CourseStructure', 'attributes', ['value'])
         self.list_struct = courseStructure
	 #self.list_struct = self.con.drive(self.struct[0])
	 self.struct_length = len(self.list_struct)	
	 self.struct_count = 1
	 self.iterator = 0
	 self.ul_count = 0
	 self.sco_count = 0
         
	 print self.list_struct[self.iterator][0], self.list_struct[self.iterator][1]
	 print course_ID

         #avoiding for now considering only course export
         """
	 while self.iterator < self.struct_length:
		self.struct_count = self.iterator + 1
		if self.list_struct[self.iterator][0]=='openli' and self.list_struct[self.iterator][1]==ID:
                    break
                else:
                    self.iterator = self.iterator + 2
         """
         
         attr_vals = {
             (None, 'identifier'): ID
             }
         attr_qnames = {
             (None, 'identifier'): 'identifier'
             }
         attrs = AttributesNSImpl(attr_vals, attr_qnames)
         self._logger.startElementNS((None, 'organization'), 'organization', attrs)
         attrs = AttributesNSImpl({}, {})
         self._logger.startElementNS((None, 'title'), 'title', attrs)
         print '-------------------------------------------------------',course_info[ID]['title'][0]
         self._logger.characters(course_info[ID]['title'][0])
         self._logger.endElementNS((None, 'title'), 'title')
                
	 if self.list_struct[self.struct_count][0] == 'openul':
             self.ul_count = self.ul_count + 1
             self.struct_count = self.struct_count + 1
             while self.struct_count < (self.struct_length - 1) and self.ul_count <> 0:
                if self.list_struct[self.struct_count][0] == 'closeul':
                    self.ul_count = self.ul_count - 1
                    self.struct_count = self.struct_count + 1
                if self.list_struct[self.struct_count][0] == 'openul':
                    self.ul_count = self.ul_count + 1
                    self.struct_count = self.struct_count + 1
                if self.list_struct[self.struct_count][0] == 'closeli' and self.ul_count <> 0:
                    self.struct_count = self.struct_count + 1
                    self._logger.endElementNS((None, 'item'), 'item')
		self.sco_count = self.sco_count + 1
                if self.struct_count<self.struct_length and self.list_struct[self.struct_count][0] == 'openli':

                   #Plone part is not required
                   """
                   author = self.con.getNeighbourhood(self.list_struct[self.struct_count][1], 'object', ['relations'], [['owns','1']])[0][0][1][0]
                   conpath2 = self.conpath
                   uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + self.list_struct[self.struct_count][1]
                   con1 = xmlrpclib.Server(uri1)
                   content1 = con1.getBody()
                   content1 = content1.replace('./fs_access/'+course_ID+'/','')
                   """
                   #os.chown('/tmp/resources/sco__'+str(self.sco_count)+'.html', 'root', 'root')
                   #URLModification('/tmp/resources/sco__'+str(self.sco_count)+'.html', course_info[self.list_struct[self.struct_count][1]]['nid'])
                   
                   content1 = course_info[self.list_struct[self.struct_count][1]]['content']
                   if content1 == None:
                       pass
                   else:
                       content1 = content1.replace('./Data/gbobjects/'+course_info[self.list_struct[self.struct_count][1]]['nid'][0]+'/'+course_info[self.list_struct[self.struct_count][1]]['nid'][1]+'/'+course_info[self.list_struct[self.struct_count][1]]['nid']+'/','')
#                   content1 = content1.replace('./fs_access/'+course_ID+'/','')
                   
                   if self.list_struct[self.struct_count + 1][0] == 'openul':
                       if content1 != None:
                           if len(content1)>0:
                               item.append('sco__'+str(self.sco_count)) 
                               item_ID.append(self.list_struct[self.struct_count][1])
                               fp = open('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html', 'w')
                               try:
                                   fp.write(content1)
                               except:
                                   #f_codecs = fun_id()
                                   #content1 = f_codecs.file_fun(content1)
                                   fp.write(unicode(content1))
                               fp.close()
                   else:
                       item.append('sco__'+str(self.sco_count)) 
                       item_ID.append(self.list_struct[self.struct_count][1]) 
                       fp = open('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html', 'w')
                       try:
                           fp.write(content1)
                       except:
                           #f_codecs = fun_id()
                           #content1 = f_codecs.file_fun(content1)
                           fp.write(unicode(content1))
                       fp.close()
                   
                   
                   attrs_val = {
                       (None, 'identifier'): self.list_struct[self.struct_count][1],
                       (None, 'identifierref'): 'sco__'+str(self.sco_count)
                       }
                   attrs_qname = {
                       (None, 'identifier'): 'identifier',
                       (None, 'identifierref'): 'identifierref'
                       }
                   attrs = AttributesNSImpl(attrs_val, attrs_qname)
                   self._logger.startElementNS((None, 'item'), 'item', attrs)
                   
                   attrs = AttributesNSImpl({},{})
                   self._logger.startElementNS((None, 'metadata'), 'metadata', attrs )
                   self._logger.characters(type_info[self.list_struct[self.struct_count][1]][0])
                   self._logger.endElementNS((None, 'metadata'), 'metadata')
                   self._logger.startElementNS((None, 'title'), 'title', attrs)
                   self._logger.characters(course_info[self.list_struct[self.struct_count][1]]['title'][0])
                   self._logger.endElementNS((None, 'title'), 'title')
                   self.struct_count = self.struct_count + 1
		        
	 else:
             self.sco_count = self.sco_count + 1


             #Avoid plone stuff now
             """
             author = self.con.getNeighbourhood(self.list_struct[self.iterator][1], 'object', ['relations'], [['owns','1']])[0][0][1][0]
             conpath2 = self.conpath
             uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + self.list_struct[self.iterator][1]
             con1 = xmlrpclib.Server(uri1)
             content1 = con1.getBody()
             content1 = content1.replace('./fs_access/'+course_ID+'/', '')
             """
             print course_info[self.list_struct[self.iterator][1]]
             print course_info[self.list_struct[self.iterator][1]]['content']
             content1 = course_info[self.list_struct[self.iterator][1]]['content']
             if content1 == None:
                 pass
             else:
                 content1 = content1.replace('./Data/gbobjects/'+course_info[self.list_struct[self.iterator][1]]['nid'][0]+'/'+course_info[self.list_struct[self.iterator][1]]['nid'][1]+'/'+course_info[self.list_struct[self.iterator][1]]['nid']+'/','')
             fp = open('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html', 'w')
             try:
                 fp.write(content1)
             except:
                 #f_codecs = fun_id()
                 #content1 = f_codecs.file_fun(content1)
                 fp.write(unicode(content1))
             fp.close()
             #os.chown('/tmp/resources/sco__'+str(self.sco_count)+'.html', 'root', 'root')
             #URLModification('/tmp/resources/sco__'+str(self.sco_count)+'.html', course_info[self.list_struct[self.iterator][1]]['nid'])             
             
#              if os.path.exists('/home/divya/divya/SCORM/'+self.list_struct[self.iterator][1]+'.html'):
#                 os.system('cp '+ ' /home/divya/divya/SCORM/'+self.list_struct[self.iterator][1]+'.html '+  '/tmp/resources/sco__'+str(self.sco_count)+'.html')
             attrs_val = {
                 (None, 'identifier'): self.list_struct[self.iterator][1],
                 (None, 'identifierref'): 'sco__'+str(self.sco_count)
                 }
             attrs_qname = {
                 (None, 'identifier'): 'identifier',
                 (None, 'identifierref'): 'identifierref'
                 }
             attrs = AttributesNSImpl(attrs_val, attrs_qname)
             self._logger.startElementNS((None, 'item'), 'item', attrs)
             
             item.append('sco__'+str(self.sco_count)) 
             item_ID.append(self.list_struct[self.struct_count][1]) 
             
             attrs = AttributesNSImpl({},{})
             self._logger.startElementNS((None, 'metadata'), 'metadata', attrs )
             self._logger.characters(type_info[self.list_struct[self.struct_count][1]][0])
             self._logger.endElementNS((None, 'metadata'), 'metadata')
             self._logger.startElementNS((None, 'title'), 'title', attrs)
             self._logger.characters(course_info[self.list_struct[self.struct_count][1]]['title'][0])
             self._logger.endElementNS((None, 'title'), 'title')
             
             self._logger.endElementNS((None, 'item'), 'item')


    
#          if type == 'Courses':
#              self.course_parts = self.con.getNeighbourhood(course_ID, 'object', ['relations'], [['haspart', '0']])[0]
#              for LO in self.course_parts:
#                  LO_type = self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['hasInstance', '1']])[0][0][1][0]

#                  if LO_type == 'Content':
#                      pass
#                  elif LO_type == 'Glossary':#Confirm for absence of Glossary in the structure 
#                      self.sco_count = self.sco_count + 1

#                      #Avoid plone stuff
#                      """
#                      author = self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['owns','1']])[0][0][1][0]
#                      conpath2 = self.conpath
#                      uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + LO[1][0]
#                      con1 = xmlrpclib.Server(uri1)
#                      content1 = con1.getBody()
#                      content1 = content1.replace('./fs_access/'+course_ID+'/', '')
#                      """
                     
#                      fp = open('/tmp/'+self.usrname+'Export/resources/sco__'+str(self.sco_count)+'.html', 'w')
#                      try:
#                          fp.write(content1)
#                      except:
#                          f_codecs = fun_id()
#                          content1 = f_codecs.file_fun(content1)
#                          fp.write(unicode(content1))
#                      fp.close()

#                      URLModification('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html')
             
#                      attrs_val = {
#                          (None, 'identifier'): LO[1][0],
#                          (None, 'identifierref'): 'sco__'+str(self.sco_count)
#                          }
#                      attrs_qname = {
#                          (None, 'identifier'): 'identifier',
#                          (None, 'identifierref'): 'identifierref'
#                          }
#                      attrs = AttributesNSImpl(attrs_val, attrs_qname)
#                      self._logger.startElementNS((None, 'item'), 'item', attrs)
#                      item.append('sco__'+str(self.sco_count))
#                      item_ID.append(LO[1][0])
#                      attrs = AttributesNSImpl({},{})
#                      self._logger.startElementNS((None, 'metadata'), 'metadata', attrs )
#                      self._logger.characters(self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['hasInstance', '1']])[0][0][1][0])
#                      self._logger.endElementNS((None, 'metadata'), 'metadata')
#                      self._logger.startElementNS((None, 'title'), 'title', attrs)
#                      self._logger.characters(self.con.getNeighbourhood(LO[1][0], 'object', ['title'])[0])
#                      self._logger.endElementNS((None, 'title'), 'title')
#                      self._logger.endElementNS((None, 'item'), 'item')
                     
#                  elif LO_type == 'FaqTopics':
#                      self.sco_count = self.sco_count + 1
# #                      author = self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['owns','1']])[0][0][1][0]
# #                      conpath2 = self.conpath
# #                      uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + LO[1][0]
# #                      con1 = xmlrpclib.Server(uri1)
# #                      content1 = con1.getBody()
# #                      content1 = content1.replace('./fs_access/'+course_ID+'/', '')
# #                      fp = open('/tmp/resources/sco__'+str(self.sco_count)+'.html', 'w')
# #                      try:
# #                          fp.write(content1)
# #                      except:
# #                          f_codecs = fun_id()
# #                          content1 = f_codecs.file_fun(content1)
# #                          fp.write(unicode(content1))
# #                      fp.close()
# #                      #os.chown('/tmp/resources/sco__'+str(self.sco_count)+'.html', 'plone', 'root')
# #                      URLModification('/tmp/resources/sco__'+str(self.sco_count)+'.html')
             
#                      attrs_val = {
#                          (None, 'identifier'): LO[1][0],
#                          (None, 'identifierref'): 'sco__'+str(self.sco_count)
#                          }
#                      attrs_qname = {
#                          (None, 'identifier'): 'identifier',
#                          (None, 'identifierref'): 'identifierref'
#                          }
#                      attrs = AttributesNSImpl(attrs_val, attrs_qname)
#                      self._logger.startElementNS((None, 'item'), 'item', attrs)
# #                     item.append('sco__'+str(self.sco_count))
# #                     item_ID.append(LO[1][0])
#                      attrs = AttributesNSImpl({},{})
#                      self._logger.startElementNS((None, 'metadata'), 'metadata', attrs )
#                      self._logger.characters(self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['hasInstance', '1']])[0][0][1][0])
#                      self._logger.endElementNS((None, 'metadata'), 'metadata')
#                      self._logger.startElementNS((None, 'title'), 'title', attrs)
#                      self._logger.characters(self.con.getNeighbourhood(LO[1][0], 'object', ['title'])[0])
#                      self._logger.endElementNS((None, 'title'), 'title')
                     
#                      refered_LO = self.con.getNeighbourhood(LO[1][0], 'object', ['relations'], [['references', '0']])[0]
#                      for ref_LO  in refered_LO:
#                          self.sco_count = self.sco_count + 1

#                          #Avoid plone stuff
#                          """
#                          author = self.con.getNeighbourhood(ref_LO[1][0], 'object', ['relations'], [['owns','1']])[0][0][1][0]
#                          conpath2 = self.conpath
#                          uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + ref_LO[1][0]
#                          con1 = xmlrpclib.Server(uri1)
#                          content1 = con1.getBody()
#                          content1 = content1.replace('./fs_access/'+course_ID+'/', '')
#                          """
                         
#                          fp = open('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html', 'w')
#                          try:
#                              fp.write(content1)
#                          except:
#                              f_codecs = fun_id()
#                              content1 = f_codecs.file_fun(content1)
#                              fp.write(unicode(content1))
#                          fp.close()
#                          URLModification('/tmp/'+self.username+'Export/resources/sco__'+str(self.sco_count)+'.html')
             
#                          attrs_val = {
#                              (None, 'identifier'): ref_LO[1][0],
#                              (None, 'identifierref'): 'sco__'+str(self.sco_count)
#                              }
#                          attrs_qname = {
#                              (None, 'identifier'): 'identifier',
#                              (None, 'identifierref'): 'identifierref'
#                              }
#                          attrs = AttributesNSImpl(attrs_val, attrs_qname)
#                          self._logger.startElementNS((None, 'item'), 'item', attrs)
#                          item.append('sco__'+str(self.sco_count))
#                          item_ID.append(ref_LO[1][0])
#                          attrs = AttributesNSImpl({},{})
#                          self._logger.startElementNS((None, 'metadata'), 'metadata', attrs )
#                          self._logger.characters(self.con.getNeighbourhood(ref_LO[1][0], 'object', ['relations'], [['hasInstance', '1']])[0][0][1][0])
#                          self._logger.endElementNS((None, 'metadata'), 'metadata')
#                          self._logger.startElementNS((None, 'title'), 'title', attrs)
#                          self._logger.characters(self.con.getNeighbourhood(ref_LO[1][0], 'object', ['title'])[0])
#                          self._logger.endElementNS((None, 'title'), 'title')
                         
#                          self._logger.endElementNS((None, 'item'), 'item')
#                      self._logger.endElementNS((None, 'item'), 'item')
                     

          #------------------------------------------------------
         
         self._logger.endElementNS((None, 'organization'), 'organization')
         self._logger.endElementNS((None, MANIFEST_ELE[1]), MANIFEST_ELE[1])
         self._logger.startElementNS((None, MANIFEST_ELE[2]), MANIFEST_ELE[2], attrs)
         self.i_count = 0
         self.pointer_count = 0
         for i in item:
	     print i
             self.i_count = self.i_count + 1
             attrs_vals = {
                 (None, 'identifier'): i,
                 (None, 'type'): 'webcontent',
                 (None, 'href'): "resources/"+i+'.html'
                 }
             attrs_qname = {
                 (None, 'identifier'): 'identifier',
                 (None, 'type'): 'type',
                 (None, 'href'): 'href'
                 }
             attrs = AttributesNSImpl(attrs_vals, attrs_qname)
             self._logger.startElementNS((None, 'resource'), 'resource', attrs)
             self.img_path = ""
             self.fs_path = ''
             attrs_vals = {
                 (None, 'href'): 'resources/'+i+'.html'
                 }
             attrs_qname = {
                 (None, 'href'): 'href'
                 }
             attrs = AttributesNSImpl(attrs_vals, attrs_qname)
             self._logger.startElementNS((None, 'file'), 'file', attrs)
             self._logger.endElementNS((None, 'file'), 'file')
             print item_ID[self.i_count - 1]

             
             SCO_type = type_info[item_ID[self.i_count - 1]]
             
             #if SCO_type == 'Content':
             #    self.all_files = self.con.getNeighbourhood(item_ID[self.i_count - 1]+'.Hashref', 'attribute', ['value'])[0]
             #else:
             #    self.all_files = ''
             
             self.all_files = ''
             print self.all_files
             if len(self.all_files) <> 0:
                 
                 for f in self.all_files:
                     self.img_path = '/tmp/'+self.username+'Export/resources/'
                     self.fs_path = self.CLIENT_HOME+'/GB/'+self.instance_name+'/gbobjects/'+course_info[item_ID[self.i_count - 1]]['nid'][0]+'/'+course_info[item_ID[self.i_count - 1]]['nid'][1]+'/'+course_info[item_ID[self.i_count - 1]]['nid']+'/'
                     folder_path = f.split('/')
                     for p in range(len(folder_path)-1):
                         if os.path.exists(self.img_path+folder_path[p]):
                             pass
                         else:
                             os.system('mkdir "'+self.img_path+folder_path[p]+'"')
                         self.img_path = self.img_path + folder_path[p]+'/'
                         self.fs_path = self.fs_path + folder_path[p]+'/'
                     if os.path.exists(self.fs_path + folder_path[-1]):
                         os.system('cp "'+self.fs_path+folder_path[-1]+ '" "'+ self.img_path+'"')
                     print folder_path[-1]
                     attrs_vals = {
                         (None, 'href'): self.img_path.replace('/tmp/'+self.username+'Export/','') + folder_path[-1]
                         }
                     attrs_qname = {
                         (None, 'href'): 'href'
                         }
                     attrs = AttributesNSImpl(attrs_vals, attrs_qname)
                     self._logger.startElementNS((None, 'file'), 'file', attrs)
                     self._logger.endElementNS((None, 'file'), 'file')
                     folder_path = []

             else:
                 print "parsing the files"
                 reference_files = MyHTMLParser()
	     
                 data = open('/tmp/'+self.username+'Export/resources/' + i+'.html', 'r').read()
                 if data <> None:
                     try:
                         reference_files.feed(data)
                         print "data feeded successfully"
                         include_files = reference_files.resource_files()
                         print include_files
                         print self.pointer_count
                         print include_files[self.pointer_count:]
                         if include_files == '':
                             pass
                         else:
 
                             print len(include_files)
                             if len(include_files):
 
                                 for f in include_files[self.pointer_count:]:
 
					self.img_path = '/tmp/'+self.username+'Export/resources/'
 
	     				self.fs_path = self.CLIENT_HOME+'/GB/'+self.instance_name+'/gbobjects/'+course_info[item_ID[self.i_count - 1]]['nid'][0]+'/'+course_info[item_ID[self.i_count - 1]]['nid'][1]+'/'+course_info[item_ID[self.i_count - 1]]['nid']+'/'
 
					folder_path = f.split('/')
 
                                        if len(folder_path) > 1:
 
                                            for p in range(len(folder_path)-1):
						if os.path.exists(self.img_path+folder_path[p]):
							print "Folder Exists"
						else:
							os.system('mkdir "'+self.img_path+folder_path[p]+'"')
						self.img_path = self.img_path + folder_path[p]+'/'
						self.fs_path = self.fs_path + folder_path[p]+'/'
                                        if os.path.exists(self.fs_path + folder_path[-1]):
                                            os.system('cp "'+self.fs_path+folder_path[-1]+ '" "'+ self.img_path+'"')
                                        else:
                                            print "Cannot copy the specified file"
#                                         elif len(folder_path) == 1:


#                                         author = self.con.getNeighbourhood(item_ID[self.i_count - 1], 'object', ['relations'], [['owns','1']])[0][0][1][0]
#                                         conpath2 = self.conpath
#                                         uri1 = conpath2.replace('kb', '')+'Members/' + author + '/' + f
#                                         img_con = urllib2.urlopen(uri1)
#                                         f_img = open(self.img_path + '/' + f, 'wb')
#                                         f_img.write(img_con.read())
#                                         f_img.close()
#                                         img_con.close()
                                          
					print f
					attrs_vals = {
                 	     	     	     (None, 'href'): self.img_path.replace('/tmp/'+self.username+'Export/', '') + f
                 	     	     	     }
             				attrs_qname = {
                 	     	     	     (None, 'href'): 'href'
                 	     	    	     }
             				attrs = AttributesNSImpl(attrs_vals, attrs_qname)
             				self._logger.startElementNS((None, 'file'), 'file', attrs)
             				self._logger.endElementNS((None, 'file'), 'file')
                                        #folder_path = []
                         self.pointer_count = len(include_files)
                     except:
                         pass
             #---------------------------------------------------------------
             self._logger.endElementNS((None, 'resource'), 'resource')
         self._logger.endElementNS((None, MANIFEST_ELE[2]), MANIFEST_ELE[2])

         return item

    def lom_gen(self, course_id, cour_name, desc, keywords, val, aggr_val):
        
         str_attrs = AttributesNSImpl({}, {})
         l=self.con.getNeighbourhood(course_id, 'object', ['relations'], [['encodedin', '0']])[0][0][1][0]
         str_attrs_vals = {
             (None, STR_ELE[1]): l
             }
         str_attrs_qname = {
             (None, STR_ELE[1]): STR_ELE[1]
             }
         str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
         attrs = AttributesNSImpl({}, {})
         self._logger.startElementNS((None, MANIFEST_ELE[0]), MANIFEST_ELE[0], attrs)
         self._logger.startElementNS((None, 'schema'), 'schema', attrs)
         self._logger.characters(META_DATA[0])
         self._logger.endElementNS((None, 'schema'), 'schema')
         self._logger.startElementNS((None, 'schemaversion'), 'schemaversion', attrs)
         self._logger.characters(META_DATA[1])
         self._logger.endElementNS((None, 'schemaversion'), 'schemaversion')
         attrs_vals = {
             (None, 'xmlns'): LOM_LEVELS[0]
             }
         attrs_qname = {
             (None, 'xmlns'): 'xmlns'
             }
         attrs = AttributesNSImpl(attrs_vals, attrs_qname)
         self._logger.startElementNS((None, 'lom'), 'lom', attrs)
         attrs = AttributesNSImpl({}, {})

	 # General (LOM)

         self._logger.startElementNS((None, LOM_ELE[0]), LOM_ELE[0], attrs)
         self._logger.startElementNS((None, GENERAL_ELE[0]), GENERAL_ELE[0], attrs)
         self._logger.startElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0], attrs)
         self._logger.endElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0])
         self._logger.startElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1], attrs)
         self._logger.endElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1])                 
         self._logger.endElementNS((None, GENERAL_ELE[0]), GENERAL_ELE[0])
         self._logger.startElementNS((None, GENERAL_ELE[1]), GENERAL_ELE[1], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(cour_name),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, GENERAL_ELE[1]), GENERAL_ELE[1])

         # Looping through the language table

#          L = s.getNeighbourhood('Languages', 'objectType', ['relations','relations'], [['hasInstance','0'],['hasSubtype','1']])
#          for lan in L[0]:
#              self._logger.startElementNS((None, GENERAL_ELE[2]), GENERAL_ELE[2], attrs)
#              self._logger.characters(lan[1][0])
#              self._logger.endElementNS((None, GENERAL_ELE[2]), GENERAL_ELE[2])

         # End of code
         
         self._logger.startElementNS((None, GENERAL_ELE[3]), GENERAL_ELE[3], attrs)

         # Loop through for multiple keywords

         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(desc),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])

         # End of code

         self._logger.endElementNS((None, GENERAL_ELE[3]), GENERAL_ELE[3])
#          self._logger.startElementNS((None, GENERAL_ELE[4]), GENERAL_ELE[4], attrs)
#          keys = re.split('\W+', keywords)
#          for keyword in keys: 
#              self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#              self._logger.characters(keyword),
#              self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
#          self._logger.endElementNS((None, GENERAL_ELE[4]), GENERAL_ELE[4])

         # Most likely to be skipped
         
         self._logger.startElementNS((None, GENERAL_ELE[5]), GENERAL_ELE[5], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters("time,culture,geography,region")
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
                  
         self._logger.endElementNS((None, GENERAL_ELE[5]), GENERAL_ELE[5])

         # End of code
         
         self._logger.startElementNS((None, GENERAL_ELE[6]), GENERAL_ELE[6], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(val),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, GENERAL_ELE[6]), GENERAL_ELE[6])
         self._logger.startElementNS((None, GENERAL_ELE[7]), GENERAL_ELE[7], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(aggr_val),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, GENERAL_ELE[7]), GENERAL_ELE[7])
         self._logger.endElementNS((None, LOM_ELE[0]), LOM_ELE[0])

         return

    def lom_lifecycle(self, course_id, status_val, role_val, VCARD):
        
         attrs = AttributesNSImpl({}, {})
         str_attrs = AttributesNSImpl({}, {})
         l=self.con.getNeighbourhood(course_id, 'object', ['relations'], [['encodedin', '0']])[0][0][1][0]
         str_attrs_vals = {
             (None, STR_ELE[1]): l
             }
         str_attrs_qname = {
             (None, STR_ELE[1]): STR_ELE[1]
             }
         str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)

         # Life Cycle (LOM)
         
	 self._logger.startElementNS((None, LOM_ELE[1]), LOM_ELE[1], attrs)
         self._logger.startElementNS((None, LIFECYCLE_ELE[0]), LIFECYCLE_ELE[0], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters("testing"),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, LIFECYCLE_ELE[0]), LIFECYCLE_ELE[0])
         self._logger.startElementNS((None, LIFECYCLE_ELE[1]), LIFECYCLE_ELE[1], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(status_val),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, LIFECYCLE_ELE[1]), LIFECYCLE_ELE[1])
         self._logger.startElementNS((None, LIFECYCLE_ELE[2]), LIFECYCLE_ELE[2], attrs)
         self._logger.startElementNS((None, CONTRIBUTE_ELE[0]), CONTRIBUTE_ELE[0], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(role_val),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, CONTRIBUTE_ELE[0]), CONTRIBUTE_ELE[0])
         self._logger.startElementNS((None, CONTRIBUTE_ELE[1]), CONTRIBUTE_ELE[1], attrs)
         self._logger.characters(VCARD)
         self._logger.endElementNS((None, CONTRIBUTE_ELE[1]), CONTRIBUTE_ELE[1])
         self._logger.endElementNS((None, LIFECYCLE_ELE[2]), LIFECYCLE_ELE[2])
         self._logger.endElementNS((None, LOM_ELE[1]), LOM_ELE[1])

         return
     
    def lom_meta(self,role, name):
        
         attrs = AttributesNSImpl({}, {})
         str_attrs = AttributesNSImpl({}, {})
#          l=self.con.getNeighbourhood('comp_sci.primary_language','attribute',['value'])
#          str_attrs_vals = {
#              (None, STR_ELE[1]): l[0]
#              }
#          str_attrs_qname = {
#              (None, STR_ELE[1]): STR_ELE[1]
#              }
#          str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)

         # meta-METADATA (LOM)

	 self._logger.startElementNS((None, LOM_ELE[2]), LOM_ELE[2], attrs)
         self._logger.startElementNS((None, metaMETADATA_ELE[0]), metaMETADATA_ELE[0], attrs)
	 self._logger.startElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0], attrs)
         self._logger.characters(u'URI'),
         self._logger.endElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0])
         self._logger.startElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1], attrs)
         self._logger.characters('http://www.adlnet.org/metadata/MDO_01'),
         self._logger.endElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1])
	 self._logger.endElementNS((None, metaMETADATA_ELE[0]), metaMETADATA_ELE[0])
	 self._logger.startElementNS((None, metaMETADATA_ELE[1]), metaMETADATA_ELE[1], attrs)
	 self._logger.startElementNS((None, CONTRIBUTE_ELE[0]), CONTRIBUTE_ELE[0], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         
         # It can take validator value also
         
         self._logger.characters(role),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, CONTRIBUTE_ELE[0]), CONTRIBUTE_ELE[0])
         self._logger.startElementNS((None, CONTRIBUTE_ELE[1]), CONTRIBUTE_ELE[1], attrs)
         self._logger.characters(VCARD_ELE[0] + name + " Metadat Creator " + VCARD_ELE[1])
         self._logger.endElementNS((None, CONTRIBUTE_ELE[1]), CONTRIBUTE_ELE[1])
    	 self._logger.endElementNS((None, metaMETADATA_ELE[1]), metaMETADATA_ELE[1])
         self._logger.startElementNS((None, metaMETADATA_ELE[2]), metaMETADATA_ELE[2], attrs)
         self._logger.characters('LOMv1.0'),
	 self._logger.endElementNS((None, metaMETADATA_ELE[2]), metaMETADATA_ELE[2])
         self._logger.startElementNS((None, metaMETADATA_ELE[2]), metaMETADATA_ELE[2], attrs)
         self._logger.characters('SCORM CAM v1.3'),
         self._logger.endElementNS((None, metaMETADATA_ELE[2]), metaMETADATA_ELE[2])
	 self._logger.startElementNS((None, metaMETADATA_ELE[3]), metaMETADATA_ELE[3], attrs)
         self._logger.characters('en'),
	 self._logger.endElementNS((None, metaMETADATA_ELE[3]), metaMETADATA_ELE[3])		 
	 self._logger.endElementNS((None, LOM_ELE[2]), LOM_ELE[2])

         return

     
#     # Technical (LOM)
    
#     def lom_tech(self):
#          attrs = AttributesNSImpl({}, {})
#          str_attrs = AttributesNSImpl({}, {})
#          l=self.con.getNeighbourhood('comp_sci.primary_language','attribute',['value'])
#          str_attrs_vals = {
#              (None, STR_ELE[1]): l[0]
#              }
#          str_attrs_qname = {
#              (None, STR_ELE[1]): STR_ELE[1]
#              }
#          str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
# 	 self._logger.startElementNS((None, LOM_ELE[3]), LOM_ELE[3], attrs)
#          self._logger.startElementNS((None, TECHNICAL_ELE[0]), TECHNICAL_ELE[0], attrs)
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[0]), TECHNICAL_ELE[0])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[1]), TECHNICAL_ELE[1], attrs)
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[1]), TECHNICAL_ELE[1])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[2]), TECHNICAL_ELE[2], attrs)
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[2]), TECHNICAL_ELE[2])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[3]), TECHNICAL_ELE[3], attrs)
# 	 self._logger.startElementNS((None, REQUIREMENT_ELE[0]), REQUIREMENT_ELE[0], attrs)
# 	 self._logger.startElementNS((None, orCOMPOSITE_ELE[0]), orCOMPOSITE_ELE[0], attrs)
# 	 self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
#          self._logger.characters(VOC_ELE[2])
#          self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
#          self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
#          self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
# 	 self._logger.endElementNS((None, orCOMPOSITE_ELE[0]), orCOMPOSITE_ELE[0])
# 	 self._logger.startElementNS((None, orCOMPOSITE_ELE[1]), orCOMPOSITE_ELE[1], attrs)
# 	 self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
#          self._logger.characters(VOC_ELE[2])
#          self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
#          self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
#          self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
# 	 self._logger.endElementNS((None, orCOMPOSITE_ELE[1]), orCOMPOSITE_ELE[1])
# 	 self._logger.startElementNS((None, orCOMPOSITE_ELE[2]), orCOMPOSITE_ELE[2], attrs)
# 	 self._logger.endElementNS((None, orCOMPOSITE_ELE[2]), orCOMPOSITE_ELE[2])
# 	 self._logger.startElementNS((None, orCOMPOSITE_ELE[3]), orCOMPOSITE_ELE[3], attrs)
# 	 self._logger.endElementNS((None, orCOMPOSITE_ELE[3]), orCOMPOSITE_ELE[3])
# 	 self._logger.endElementNS((None, REQUIREMENT_ELE[0]), REQUIREMENT_ELE[0])
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[3]), TECHNICAL_ELE[3])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[4]), TECHNICAL_ELE[4], attrs)
# 	 self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#          self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[4]), TECHNICAL_ELE[4])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[5]), TECHNICAL_ELE[5], attrs)
# 	 self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#          self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[5]), TECHNICAL_ELE[5])
# 	 self._logger.startElementNS((None, TECHNICAL_ELE[6]), TECHNICAL_ELE[6], attrs)
# 	 self._logger.endElementNS((None, TECHNICAL_ELE[6]), TECHNICAL_ELE[6])
# 	 self._logger.endElementNS((None, LOM_ELE[3]), LOM_ELE[3])

#          return


     
#          # Educational (LOM)
         
    def lom_edu(self, course_id, eu_type, res_type, eu_level, eu_semantic, eu_enduser, eu_context, eu_difficulty,learningtime_duration, learningtime_description, eu_desc, eu_lang):
        
         attrs = AttributesNSImpl({}, {})
         str_attrs = AttributesNSImpl({}, {})
         l=self.con.getNeighbourhood(course_id, 'object', ['relations'], [['encodedin', '0']])[0][0][1][0]
         str_attrs_vals = {
             (None, STR_ELE[1]): l
             }
         str_attrs_qname = {
             (None, STR_ELE[1]): STR_ELE[1]
             }
         str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
	 self._logger.startElementNS((None, LOM_ELE[4]), LOM_ELE[4], attrs)
         self._logger.startElementNS((None, EDUCATIONAL_ELE[0]), EDUCATIONAL_ELE[0], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_type),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[0]), EDUCATIONAL_ELE[0])

         # Begin of code for condition checking for the extention of file
         
         self._logger.startElementNS((None, EDUCATIONAL_ELE[1]), EDUCATIONAL_ELE[1], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(res_type),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[1]), EDUCATIONAL_ELE[1])

         # End of code
         
         self._logger.startElementNS((None, EDUCATIONAL_ELE[2]), EDUCATIONAL_ELE[2], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_level),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[2]), EDUCATIONAL_ELE[2])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[3]), EDUCATIONAL_ELE[3], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_semantic),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[3]), EDUCATIONAL_ELE[3])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[4]), EDUCATIONAL_ELE[4], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_enduser),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[4]), EDUCATIONAL_ELE[4])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[5]), EDUCATIONAL_ELE[5], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_context),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[5]), EDUCATIONAL_ELE[5])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[6]), EDUCATIONAL_ELE[6], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(u'suitable for all'),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[6]), EDUCATIONAL_ELE[6])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[7]), EDUCATIONAL_ELE[7], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(eu_difficulty),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[7]), EDUCATIONAL_ELE[7])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[8]), EDUCATIONAL_ELE[8], attrs)
         self._logger.startElementNS((None, DURATION_ELE[0]), DURATION_ELE[0], attrs)
         self._logger.characters(learningtime_duration),
         self._logger.endElementNS((None, DURATION_ELE[0]), DURATION_ELE[0])
         self._logger.startElementNS((None, DURATION_ELE[1]), DURATION_ELE[1], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(learningtime_description),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, DURATION_ELE[1]), DURATION_ELE[1])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[8]), EDUCATIONAL_ELE[8])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[9]), EDUCATIONAL_ELE[9], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(eu_desc),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, EDUCATIONAL_ELE[9]), EDUCATIONAL_ELE[9])
         self._logger.startElementNS((None, EDUCATIONAL_ELE[10]), EDUCATIONAL_ELE[10], attrs)
         self._logger.characters(eu_lang),
         self._logger.endElementNS((None, EDUCATIONAL_ELE[10]), EDUCATIONAL_ELE[10])
         self._logger.endElementNS((None, LOM_ELE[4]), LOM_ELE[4])

         return

     
    # Rights (LOM)
    
    def lom_rights(self, course_id, cost, copyright, right_desc):
        
         attrs = AttributesNSImpl({}, {})
         str_attrs = AttributesNSImpl({}, {})
         l=self.con.getNeighbourhood(course_id, 'object', ['relations'], [['encodedin', '0']])[0][0][1][0]
         str_attrs_vals = {
             (None, STR_ELE[1]): l
             }
         str_attrs_qname = {
             (None, STR_ELE[1]): STR_ELE[1]
             }
         str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
	 self._logger.startElementNS((None, LOM_ELE[5]), LOM_ELE[5], attrs)
         self._logger.startElementNS((None, RIGHTS_ELE[0]), RIGHTS_ELE[0], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(cost),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, RIGHTS_ELE[0]), RIGHTS_ELE[0])
         self._logger.startElementNS((None, RIGHTS_ELE[1]), RIGHTS_ELE[1], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(copyright),
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, RIGHTS_ELE[1]), RIGHTS_ELE[1])
         self._logger.startElementNS((None, RIGHTS_ELE[2]), RIGHTS_ELE[2], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters('Contact ' + right_desc + ' for copyright information'),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, RIGHTS_ELE[2]), RIGHTS_ELE[2])
         self._logger.endElementNS((None, LOM_ELE[5]), LOM_ELE[5])

         return
     
#     # Relation (LOM)
    
#     def lom_relation(self, kind, item, res_desc):
        
#          attrs = AttributesNSImpl({}, {})
#          str_attrs = AttributesNSImpl({}, {})
#          l=self.con.getNeighbourhood('comp_sci.primary_language','attribute',['value'])
#          str_attrs_vals = {
#              (None, STR_ELE[1]): l[0]
#              }
#          str_attrs_qname = {
#              (None, STR_ELE[1]): STR_ELE[1]
#              }
#          str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
# 	 self._logger.startElementNS((None, LOM_ELE[6]), LOM_ELE[6], attrs)
#          for identifier, description in zip(item, res_desc):
#              self._logger.startElementNS((None, RELATION_ELE[0]), RELATION_ELE[0], attrs)
#              self._logger.characters(kind)
#              self._logger.endElementNS((None, RELATION_ELE[0]), RELATION_ELE[0])
#              self._logger.startElementNS((None, RELATION_ELE[1]), RELATION_ELE[1], attrs)
#              self._logger.startElementNS((None, RESOURCE_ELE[0]), RESOURCE_ELE[0], attrs)
#              self._logger.startElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0], attrs)
#              self._logger.endElementNS((None, IDENTIFIER_ELE[0]), IDENTIFIER_ELE[0])
             
#              self._logger.startElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1], attrs)
#              self._logger.characters(identifier)
#              self._logger.endElementNS((None, IDENTIFIER_ELE[1]), IDENTIFIER_ELE[1])
#              self._logger.endElementNS((None, RESOURCE_ELE[0]), RESOURCE_ELE[0])
#              self._logger.startElementNS((None,RESOURCE_ELE[1]), RESOURCE_ELE[1], attrs)
#              self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#              self._logger.characters(description)
#              self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
#              self._logger.endElementNS((None, RESOURCE_ELE[1]), RESOURCE_ELE[1])
         
#              """
#              self._logger.startElementNS((None, RESOURCE_ELE[0]), RESOURCE_ELE[0], attrs)
#              self._logger.endElementNS((None, RESOURCE_ELE[0]), RESOURCE_ELE[0])
#              self._logger.startElementNS((None, RESOURCE_ELE[1]), RESOURCE_ELE[1], attrs)
#              self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#              self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
#              self._logger.endElementNS((None, RESOURCE_ELE[1]), RESOURCE_ELE[1])
#              """
#              self._logger.endElementNS((None, RELATION_ELE[1]), RELATION_ELE[1])
#          self._logger.endElementNS((None, LOM_ELE[6]), LOM_ELE[6])

#          return
     
#     # Annotation (LOM)
    
#     def lom_annotation(self, name, anno_time, anno_desc, role_val):
        
#          attrs = AttributesNSImpl({}, {})
#          str_attrs = AttributesNSImpl({}, {})
#          l=self.con.getNeighbourhood('comp_sci.primary_language','attribute',['value'])
#          str_attrs_vals = {
#              (None, STR_ELE[1]): l[0]
#              }
#          str_attrs_qname = {
#              (None, STR_ELE[1]): STR_ELE[1]
#              }
#          str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
# 	 self._logger.startElementNS((None, LOM_ELE[7]), LOM_ELE[7], attrs)
#          self._logger.startElementNS((None, ANNOTATION_ELE[0]), ANNOTATION_ELE[0], attrs)
#          self._logger.characters(VCARD_ELE[0] + name + " " + role_val + VCARD_ELE[1])
#          self._logger.endElementNS((None, ANNOTATION_ELE[0]), ANNOTATION_ELE[0])
#          self._logger.startElementNS((None, ANNOTATION_ELE[1]), ANNOTATION_ELE[1], attrs)
#          self._logger.startElementNS((None, DATE_ELE[0]), DATE_ELE[0], attrs)
#          self._logger.characters(anno_time),
#          self._logger.endElementNS((None, DATE_ELE[0]), DATE_ELE[0])
#          self._logger.startElementNS((None, DATE_ELE[1]), DATE_ELE[1], attrs)
#          self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
#          self._logger.characters('Date and time annotation was created'),
#          self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
#          self._logger.endElementNS((None, DATE_ELE[1]), DATE_ELE[1])
#          self._logger.endElementNS((None, ANNOTATION_ELE[1]), ANNOTATION_ELE[1])
#          self._logger.startElementNS((None, ANNOTATION_ELE[2]), ANNOTATION_ELE[2], attrs)
#          self._logger.characters(anno_desc),
#          self._logger.endElementNS((None, ANNOTATION_ELE[2]), ANNOTATION_ELE[2])
# 	 self._logger.endElementNS((None, LOM_ELE[7]), LOM_ELE[7])

#          return


#     # Classification (LOM)

    def lom_classification(self, course_id, class_purpose, class_title, class_id, class_desc, sco_desc):
        
         attrs = AttributesNSImpl({}, {})
         str_attrs = AttributesNSImpl({}, {})
         l=self.con.getNeighbourhood(course_id, 'object', ['relations'], [['encodedin', '0']])[0][0][1][0]
         str_attrs_vals = {
             (None, STR_ELE[1]): l
             }
         str_attrs_qname = {
             (None, STR_ELE[1]): STR_ELE[1]
             }
         str_attrs = AttributesNSImpl(str_attrs_vals, str_attrs_qname)
	 self._logger.startElementNS((None, LOM_ELE[8]), LOM_ELE[8], attrs)
         self._logger.startElementNS((None, CLASSIFICATION_ELE[0]), CLASSIFICATION_ELE[0], attrs)
         self._logger.startElementNS((None, VOC_ELE[0]), VOC_ELE[0], attrs)
         self._logger.characters(VOC_ELE[2])
         self._logger.endElementNS((None, VOC_ELE[0]), VOC_ELE[0])
         self._logger.startElementNS((None, VOC_ELE[1]), VOC_ELE[1], attrs)
         self._logger.characters(class_purpose)
         self._logger.endElementNS((None, VOC_ELE[1]), VOC_ELE[1])
         self._logger.endElementNS((None, CLASSIFICATION_ELE[0]), CLASSIFICATION_ELE[0])
         self._logger.startElementNS((None, CLASSIFICATION_ELE[1]), CLASSIFICATION_ELE[1], attrs)
         self._logger.startElementNS((None, TAXONPATH_ELE[0]), TAXONPATH_ELE[0], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(class_title),
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, TAXONPATH_ELE[0]), TAXONPATH_ELE[0])
         self._logger.startElementNS((None, TAXONPATH_ELE[1]), TAXONPATH_ELE[1], attrs)
         self._logger.startElementNS((None, TAXON_ELE[0]), TAXON_ELE[0], attrs)
         self._logger.characters(class_id)
         self._logger.endElementNS((None, TAXON_ELE[0]), TAXON_ELE[0])
         self._logger.startElementNS((None, TAXON_ELE[1]), TAXON_ELE[1], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(class_desc)
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, TAXON_ELE[1]), TAXON_ELE[1])
         self._logger.endElementNS((None, TAXONPATH_ELE[1]), TAXONPATH_ELE[1])
         self._logger.endElementNS((None, CLASSIFICATION_ELE[1]), CLASSIFICATION_ELE[1])
         self._logger.startElementNS((None, CLASSIFICATION_ELE[2]), CLASSIFICATION_ELE[2], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(sco_desc)
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, CLASSIFICATION_ELE[2]), CLASSIFICATION_ELE[2])
         self._logger.startElementNS((None, CLASSIFICATION_ELE[3]), CLASSIFICATION_ELE[3], attrs)
         self._logger.startElementNS((None, STR_ELE[0]), STR_ELE[0], str_attrs)
         self._logger.characters(u'Packaging SCOs')
         self._logger.endElementNS((None, STR_ELE[0]), STR_ELE[0])
         self._logger.endElementNS((None, CLASSIFICATION_ELE[3]), CLASSIFICATION_ELE[3])
         self._logger.endElementNS((None, LOM_ELE[8]), LOM_ELE[8])
         self._logger.endElementNS((None, 'lom'), 'lom')
         self._logger.endElementNS((None, MANIFEST_ELE[0]), MANIFEST_ELE[0])  

         return

    def close(self):

         # Cleaning up the logger object

         self._logger.endElementNS((None, 'manifest'), 'manifest')
         self._logger.endDocument()

         return

#     def fun_id(id):
#          dicti = {'(':'28', ')':'29'}
#          try:
#              id1 = id.encode('ascii', 'strict')
#          except:
#              id1 = ""
#              for count in id:
#                  ordinal = ord(count)
#                  a=repr(count)
#                  if ordinal > 127:
#                      id1 = id1 + str(hex(ord(count)))
#                  elif count in dicti.keys():
#                      id1 = id1 + hex(ord(count))
#                  else:
#                      id1 = id1 + count.replace(' ','_')
#              return id1
#          return id1
     
    
    
