#!/bin/sh

# Process this file with autoconf to produce a configure script.

# Copyright (C) 2013, 2015 Henrik Sandklef
#
# This file is part of Searduino
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


read_file()
{
    FILE=$1
    if [ -f ${FILE} ]
    then
	. ${FILE}
    else
	echo "Can't find file: $FILE"
	exit 1
    fi
}

SEARDUINO_PATH=/opt/searduino
SEARDUINO_SHARE=${SEARDUINO_PATH}/share/searduino/
read_file ${SEARDUINO_SHARE}/scripts/settings
read_file ${SEARDUINO_SHARE}/scripts/functions

export PATH=${SEARDUINO_PATH}/bin:${PATH}
export LD_LIBRARY_PATH=${SEARDUINO_PATH}/lib:${LD_LIBRARY_PATH}
export JAVA_LIBRARY_PATH=${SEARDUINO_PATH}/lib:${JAVA_LIBRARY_PATH}
export CLASSPATH=${SEARDUINO_PATH}/lib/Searduino.jar:${SEARDUINO_PATH}/lib/Jearduino.jar:${CLASSPATH}

export JAVA_ARGS="-cp ${CLASSPATH} "
export JAVA_ARGS=" $JAVA_ARGS -Dsearduino.dir=${SEARDUINO_PATH}"
export JAVA_ARGS=" $JAVA_ARGS -Dsearduino.project.dir=${SEARDUINO_PROJECT_DIR}"
export JAVA_ARGS=" $JAVA_ARGS      -Dsearduino.arduinoex.dir=${ARDUINO_INO_EX}"
export JAVA_ARGS=" $JAVA_ARGS      -Djava.library.path=${JAVA_LIBRARY_PATH}"
export JAVA_ARGS=" $JAVA_ARGS      com.sandklef.jearduino.Jearduino"


if [ "$1" = "--nroff" ]
then
    MAN=$2
    if [ "$MAN" = "" ]
    then
        echo "Missing name for MAN page"
        exit 1
    fi
    . ../../scripts/man-support
    SEARD_HELP=/tmp/searduino-help.txt
    java ${JAVA_ARGS} --help > ${SEARD_HELP}
    if [ "$?" != "0" ] || [ ! -s ${SEARD_HELP} ]; then echo "Failed generating help file for nroff" ; exit 1; fi
    gen_nroff ${SEARD_HELP}  > $MAN
    if [ "$?" != "0" ] ; then echo "Failed creating Man file" ; exit 1; fi
    
    exit 0
else
    java ${JAVA_ARGS} $*
fi
