/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.JearduinoState;
import com.sandklef.jearduino.PinEvent;
import com.sandklef.searduino.Searduino;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PinTable
extends JPanel
implements ActionListener,
ChangeListener {
    private Object[][] pins;
    String[] columnNames = new String[]{"Number", "Type", "Mode", "Input", "Value"};
    private JPanel panel;
    JScrollPane scrollPane;
    private final int TABLE_NUMBER_POS = 0;
    private final int TABLE_TYPE_POS = 1;
    private final int TABLE_MODE_POS = 2;
    private final int TABLE_INPUT_POS = 3;
    private final int TABLE_OUTPUT_POS = 4;
    Searduino searduino;
    JearduinoState jState;
    private int[] pinMode;
    private int[] pinType;
    private PinEvent pe;

    public PinTable(PinEvent pinEvent, JearduinoState jearduinoState, Searduino searduino) {
        super(new GridLayout(2, 1));
        this.searduino = searduino;
        this.panel = this;
        this.pe = pinEvent;
        this.jState = jearduinoState;
        this.setBorder(BorderFactory.createTitledBorder("Pins"));
    }

    private int getItemPosFromCombo(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setTypeInputPin(int n, int n2, boolean bl) {
        if (this.pins == null) {
            System.out.println("setTypeInputPin() .... pins not created  yet, bailing out");
            return;
        }
        if (this.pins[0] == null) {
            System.out.println("setTypeInputPin() .... pins not created  yet, bailing out");
            return;
        }
        if (!this.searduino.hasGenericPinTypeBoolean(n, n2)) {
            System.out.println("*** ERROR: Can not set type " + Searduino.getPinType((int)n2) + " on pin " + n);
            return;
        }
        if (bl) {
            if (n2 == 1) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n3 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)1));
                if (n3 == -1) {
                    System.out.println("WARNING: deal with this way better (setting pin type needs rewrite)");
                } else {
                    jComboBox.setSelectedIndex(n3);
                }
            } else if (n2 == 2) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n4 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)2));
                jComboBox.setSelectedIndex(n4);
            } else if (n2 == 3) {
                JComboBox jComboBox = (JComboBox)this.pins[n][1];
                int n5 = this.getItemPosFromCombo(jComboBox, Searduino.getPinType((int)3));
                jComboBox.setSelectedIndex(n5);
            }
        } else {
            if (n2 == 1) {
                this.setDigitalInputPin(n);
            } else if (n2 == 2) {
                this.setAnalogInputPin(n);
            } else if (n2 == 3) {
                this.setPwmPin(n);
            }
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    public void setAnalogInputPin(int n) {
        if (this.pins == null) {
            return;
        }
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 1024, 10);
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setVisible(true);
        jSpinner.setEnabled(true);
        jSpinner.addChangeListener(this);
        GridBagLayout gridBagLayout = (GridBagLayout)this.panel.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.panel);
        if (this.pins[n][3] != null) {
            this.remove((Component)this.pins[n][3]);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n + 1;
        this.panel.add((Component)jSpinner, gridBagConstraints);
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pins[n][3] = jSpinner;
        this.pinType[n] = 2;
        jSpinner.repaint();
    }

    public void setDigitalInputPin(int n) {
        if (this.pins == null) {
            return;
        }
        JToggleButton jToggleButton = new JToggleButton("");
        jToggleButton.addActionListener(this);
        jToggleButton.setEnabled(true);
        jToggleButton.setVisible(true);
        GridBagLayout gridBagLayout = (GridBagLayout)this.panel.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.panel);
        if (this.pins[n][3] != null) {
            this.remove((Component)this.pins[n][3]);
        }
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n + 1;
        this.panel.add((Component)jToggleButton, gridBagConstraints);
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pins[n][3] = jToggleButton;
        this.pinType[n] = 1;
    }

    public void setPwmPin(int n) {
        int n2 = n * 5 + 3 + 1;
        JLabel jLabel = new JLabel("");
        jLabel.setEnabled(true);
        jLabel.setVisible(true);
        if (this.pins[n][3] != null) {
            this.remove((Component)this.pins[n][3]);
        }
        GridBagLayout gridBagLayout = (GridBagLayout)this.panel.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.panel);
        this.panel.add((Component)jLabel, gridBagConstraints);
        ((JLabel)this.pins[n][2]).setText("Output");
        this.pins[n][3] = jLabel;
        ((JLabel)this.pins[n][4]).setVisible(false);
        this.pinType[n] = 3;
    }

    private void handlePinActionPerformed(ActionEvent actionEvent) {
        for (int n = 0; n < this.jState.getBoardPins(); n = (int)((char)(n + 1))) {
            if (actionEvent.getSource() != this.pins[n][3]) continue;
            if (((JToggleButton)this.pins[n][3]).isSelected()) {
                this.pe.inputValueEvent(n, 1);
                continue;
            }
            this.pe.inputValueEvent(n, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("comboBoxChanged")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string2 = (String)jComboBox.getSelectedItem();
            int n = Searduino.getPinType((String)string2);
            for (int i = 0; i < this.jState.getBoardPins(); ++i) {
                if (this.pins[i][1] != jComboBox) continue;
                this.setTypeInputPin(i, n, false);
            }
        } else {
            this.handlePinActionPerformed(actionEvent);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        for (int i = 0; i < this.jState.getBoardPins(); ++i) {
            if (changeEvent.getSource() != this.pins[i][3]) continue;
            this.pe.inputValueEvent(i, (Integer)((JSpinner)this.pins[i][3]).getValue());
        }
    }

    public int getInputPinTypeLocal(int n) {
        return this.pinType[n];
    }

    public void setPinValue(int n, int n2, int n3) {
        JLabel jLabel = (JLabel)this.pins[n][4];
        jLabel.setVisible(true);
        jLabel.setText("" + n2);
        if (n3 == 1) {
            if (n2 == 0) {
                jLabel.setForeground(Color.green);
            } else {
                jLabel.setForeground(Color.red);
            }
        } else {
            jLabel.setForeground(Color.black);
        }
    }

    public void setPinTypeOBSOLETE(int n, int n2) {
    }

    public void setInputMode(int n) {
        this.setMode(n, 0);
    }

    public void setOutputMode(int n) {
        this.setMode(n, 1);
    }

    public void setMode(int n, int n2) {
        System.out.flush();
        if (n2 == 0) {
            ((JLabel)this.pins[n][2]).setText("INPUT");
            this.pinMode[n] = 0;
            if (this.pinType[n] == 1) {
                ((JToggleButton)this.pins[n][3]).setVisible(true);
            } else if (this.pinType[n] == 2) {
                ((JSpinner)this.pins[n][3]).setVisible(true);
            } else {
                System.out.println("ERROR ---- SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
            }
            ((JLabel)this.pins[n][4]).setVisible(false);
        } else {
            ((JLabel)this.pins[n][2]).setText("OUTPUT");
            this.pinMode[n] = 1;
            if (this.pinType[n] == 1) {
                ((JToggleButton)this.pins[n][3]).setVisible(false);
            } else if (this.pinType[n] == 2) {
                ((JSpinner)this.pins[n][3]).setVisible(true);
            } else {
                System.out.println("ERROR ---- SET PIN " + n + " (" + this.pinType[n] + ")  to: " + n2);
            }
            ((JLabel)this.pins[n][4]).setVisible(true);
        }
    }

    private void addTypeOnPin(ArrayList arrayList, int n, int n2) {
        if (this.searduino.hasGenericPinTypeBoolean(n, n2)) {
            arrayList.add(Searduino.getPinType((int)n2));
        }
    }

    public void setupPinTypes() {
        int n = this.jState.getBoardPins();
        for (int i = 0; i < n; ++i) {
            this.setTypeInputPin(i, this.searduino.getCurrentPinType(i), false);
        }
    }

    public void setupPins() {
        int n = this.jState.getBoardPins();
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.removeAll();
        this.pinMode = new int[n];
        this.pinType = new int[n];
        this.pins = new Object[n][5];
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panel.add((Component)new JLabel("Pin"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.panel.add((Component)new JLabel("Type"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        this.panel.add((Component)new JLabel("Mode"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.panel.add((Component)new JLabel("Ouput"), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.panel.add((Component)new JLabel("Input"), gridBagConstraints);
        for (int i = 0; i < n; ++i) {
            JLabel jLabel = new JLabel("" + i);
            jLabel.setVisible(true);
            ArrayList arrayList = new ArrayList();
            this.addTypeOnPin(arrayList, i, 1);
            this.addTypeOnPin(arrayList, i, 3);
            this.addTypeOnPin(arrayList, i, 2);
            JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
            jComboBox.setVisible(true);
            jComboBox.addActionListener(this);
            JLabel jLabel2 = new JLabel("INPUT");
            jLabel2.setVisible(true);
            JLabel jLabel3 = new JLabel("0");
            jLabel3.setVisible(false);
            JLabel jLabel4 = new JLabel("<none>");
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.gridx = 0;
            this.panel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.panel.add(jComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            this.panel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.panel.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridx = 4;
            this.panel.add((Component)jLabel4, gridBagConstraints);
            this.pins[i][0] = jLabel;
            this.pins[i][1] = jComboBox;
            this.pins[i][2] = jLabel2;
            this.pins[i][4] = jLabel3;
            this.pins[i][3] = jLabel4;
        }
    }
}

