#
#       Searduino
#
#  Copyright (C) 2011, 2012, 2014 Henrik Sandklef      
#                                                                   
# This program is free software; you can redistribute it and/or     
# modify it under the terms of the GNU General Public License       
# as published by the Free Software Foundation; either version 3    
# of the License, or any later version.                             
#                                                                   
#                                                                   
# This program is distributed in the hope that it will be useful,   
# but WITHOUT ANY WARRANTY; without even the implied warranty of    
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
# GNU General Public License for more details.                      
#                                                                   
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software       
# Foundation, Inc., 51 Franklin Street, Boston,            
# MA  02110-1301, USA.                                              
#
#

ifeq (${SEARDUINO_OVERRIDE_ARDUINO},)

else
ARDUINO=$(SEARDUINO_OVERRIDE_ARDUINO)
#SHLIB=""
SHLIB_LIBS=""
endif

ifndef ARDUINO
$(error Variables not set correctly ARDUINO='${ARDUINO}')
endif		

#
#
#
#
ARDUINO_SOURCES_FROM=Arduino
ARDUINO_PATH=/opt/searduino//

ifeq (${ARDUINO_SOURCES_FROM},Debian)
   #Debian build only
   ARDUINO_INC_PATH=$(ARDUINO_PATH)
   ARDUINO_LIB_PATH=$(ARDUINO_PATH)
   ARDUINO_LIB_INC_PATH=$(ARDUINO_LIBS_SOURCE_PATH)/../
else
  ARDUINO_INC_PATH=$(ARDUINO_PATH)/include/searduino/arduino-sources/
  ARDUINO_LIB_INC_PATH=$(SEARDUINO_PATH)/include/searduino/arduino-sources/
endif

#
# Searduino version
# 
SEARDUINO_VERSION=900
SEARDUINO_VERSION_STRING=0.9

SEARDUINO_VERSION_MAJOR=0
SEARDUINO_VERSION_MINOR=9
SEARDUINO_VERSION_PREPARE=

REQUESTED_SEARDUINO_VERSION_MAJOR=$(shell echo $(REQUESTED_SEARDUINO_VERSION) | sed 's,\([0-9]*\)\.[0-9]*,\1,g')
REQUESTED_SEARDUINO_VERSION_MINOR=$(shell echo $(REQUESTED_SEARDUINO_VERSION) | sed 's,[0-9]*\.\([0-9]*\),\1,g')
REQUESTED_SEARDUINO_VERSION_TOTAL=$(shell echo $(REQUESTED_SEARDUINO_VERSION_MAJOR)\*10000+$(REQUESTED_SEARDUINO_VERSION_MINOR)\*100 | bc)

#
#
#
ifdef REQUESTED_SEARDUINO_VERSION

  VERSION_OK := $(shell [ $(REQUESTED_SEARDUINO_VERSION_TOTAL) -gt  $(SEARDUINO_VERSION) ] && echo true)

  ifeq ($(VERSION_OK),true)    
     $(error "You've requested version ${REQUESTED_SEARDUINO_VERSION_MAJOR}.${REQUESTED_SEARDUINO_VERSION_MINOR} of Searudino and ${SEARDUINO_VERSION_STRING} is installed")
  endif

endif

UNAME := $(shell uname -s)

ARDUINO_VERSION=101

#
# Under cygwin, we need to add "C:\\cygwin" to the path
#   .... we're assuming cygwin has been installed to 
#   the default installation dir
#
CYGWIN=
ROOT_PATH=
ifeq (${CYGWIN},true)
  ROOT_PATH=C:\\\\cygwin
endif


SEARDUINO_MK_PATH=$(ROOT_PATH)/opt/searduino/share/searduino/
SEARDUINO_INC_PATH=$(ROOT_PATH)/opt/searduino/include/searduino/

ifdef USER_PORT
# User has defined a port, use that one
USB_DEV=$(USER_PORT)
else
# Try to identify port automatically
  ifeq (${CYGWIN},true)
       USB_DEV=$(shell $(SEARDUINO_MK_PATH)/../../bin/find_port.exe $(ARDUINO))
  else
       USB_DEV=$(shell $(SEARDUINO_MK_PATH)/../../bin/find_port.sh $(ARDUINO))
  endif

   ifneq "$(findstring No support, $(USB_DEV))" ""
   USB_DEV=""
   endif
endif




ifeq (${ARDUINO},stub)
include $(SEARDUINO_MK_PATH)/mk/searduino-stub.mk
else
include $(SEARDUINO_MK_PATH)/mk/searduino-arduino.mk
endif

SEARDUINO_LIB_PATH=-L$(ROOT_PATH)/opt/searduino/libs/searduino/arduino-libs/$(BOARD) -L$(ROOT_PATH)/opt/searduino/lib

include $(SEARDUINO_MK_PATH)/mk/searduino-functions.mk
