/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.ArduinoCodeNameEvent;
import com.sandklef.jearduino.Board;
import com.sandklef.jearduino.BoardEvent;
import com.sandklef.jearduino.DirEvent;
import com.sandklef.jearduino.ExecControl;
import com.sandklef.jearduino.ExecEvent;
import com.sandklef.jearduino.FileEvent;
import com.sandklef.jearduino.FileLogger;
import com.sandklef.jearduino.InfoPanel;
import com.sandklef.jearduino.InoDirEvent;
import com.sandklef.jearduino.JearduinoEvent;
import com.sandklef.jearduino.JearduinoMenu;
import com.sandklef.jearduino.JearduinoPreferences;
import com.sandklef.jearduino.JearduinoState;
import com.sandklef.jearduino.LCD;
import com.sandklef.jearduino.Logger;
import com.sandklef.jearduino.PinEvent;
import com.sandklef.jearduino.PinTable;
import com.sandklef.jearduino.ProjectPanel;
import com.sandklef.searduino.Searduino;
import com.sandklef.searduino.SearduinoObserver;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class Jearduino
extends JFrame
implements SearduinoObserver,
ExecEvent,
PinEvent,
BoardEvent,
FileEvent,
DirEvent,
InoDirEvent,
ArduinoCodeNameEvent,
JearduinoEvent {
    Searduino searduino;
    JearduinoPreferences jpref;
    JearduinoMenu jmenu;
    GridBagConstraints constraints;
    PinTable pins;
    Logger serial;
    Logger logger;
    FileLogger fileLogger;
    LCD lcd;
    InfoPanel infoPanel;
    ProjectPanel projectPanel;
    Container topPane;
    JPanel pane;
    JTabbedPane tabbedPane;
    private int codeNamesToStore;
    public String version;
    JPanel topPanel;
    JPanel controlPanel;
    JPanel pinPanel;
    JPanel logPanel;
    JPanel loggerPanel;
    JPanel fileLoggerPanel;
    ExecControl ec;
    Board board;
    JearduinoState jState = new JearduinoState();
    static int appSizeHeight = 700;
    static int appSizeWidth = 1080;
    static int infoSizeHeight = 20;
    static int infoSizeWidth = 800;

    public Jearduino() {
        this.jpref = new JearduinoPreferences();
        this.codeNamesToStore = this.jpref.getArduinoCodeNameCount();
        this.constraints = new GridBagConstraints();
        this.pane = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.topPane = this.getContentPane();
        this.topPane.add(jTabbedPane);
        this.pane.setLayout(new GridBagLayout());
        this.setSize(appSizeHeight, appSizeWidth);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 3));
        this.pinPanel = new JPanel();
        this.logPanel = new JPanel();
        this.loggerPanel = new JPanel();
        this.fileLoggerPanel = new JPanel();
        this.pinPanel.setVisible(true);
        this.pinPanel.setLayout(new GridLayout());
        this.logPanel.setLayout(new BoxLayout(this.logPanel, 3));
        this.ec = new ExecControl(this);
        this.controlPanel.add(this.ec);
        this.controlPanel.setVisible(true);
        this.jmenu = new JearduinoMenu(this, this, this, this, this, this);
        this.setJMenuBar(this.jmenu);
        this.searduino = new Searduino();
        this.board = new Board(this, this.searduino);
        this.infoPanel = new InfoPanel();
        this.projectPanel = new ProjectPanel();
        this.logger = new Logger("Log");
        this.fileLogger = new FileLogger("File Log", this);
        this.serial = new Logger("Serial");
        this.lcd = new LCD("LCD");
        this.serial.setMaximumSize(new Dimension(200, 400));
        this.logger.setMaximumSize(new Dimension(200, 400));
        this.lcd.setMaximumSize(new Dimension(200, 400));
        this.serial.setPreferredSize(new Dimension(200, 100));
        this.logger.setPreferredSize(new Dimension(600, 150));
        this.lcd.setPreferredSize(new Dimension(200, 100));
        this.logPanel.add(this.serial);
        this.logPanel.add(this.lcd);
        this.loggerPanel.add(this.logger);
        this.fileLoggerPanel.add(this.fileLogger);
        this.pins = new PinTable(this, this.jState, this.searduino);
        this.pins.setVisible(true);
        JScrollPane jScrollPane = new JScrollPane(this.pins);
        this.pinPanel.add(jScrollPane);
        this.setTitle("Jearduino - Searduino's Java frontend for Arduino simulation");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.searduino.setWriteTimelimit(0);
        this.searduino.disableStreamedOutput();
        this.searduino.registerPinModeCallback((SearduinoObserver)this);
        this.searduino.registerPinOutCallback((SearduinoObserver)this);
        this.searduino.registerPinTypeCallback((SearduinoObserver)this);
        this.searduino.registerLogCallback((SearduinoObserver)this);
        this.searduino.registerLCDCallback((SearduinoObserver)this);
        this.projectPanel.setArduinoCodeName(this.searduino.getArduinoCodeName());
        this.infoPanel.setSearduinoVersion(this.searduino.getSearduinoVersion());
        jTabbedPane.addTab("Control", null, this.pane, "Main tab");
        jTabbedPane.addTab("Log", null, this.fileLoggerPanel, "Log tab");
        this.setupSizes();
    }

    public void addLog(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-dd hh:mm:ss");
        String string2 = simpleDateFormat.format(new Date());
        String string3 = "[" + string2 + " jearduino-logger]: " + string + "\n";
        this.logger.addLog(string3);
        this.fileLogger.addLog(string3);
    }

    void tailLog() {
    }

    public void setupSizes() {
        this.projectPanel.setMinimumSize(new Dimension(10, 300));
        this.projectPanel.setMaximumSize(new Dimension(10, 300));
        this.infoPanel.setMinimumSize(new Dimension(400, 50));
        this.infoPanel.setMaximumSize(new Dimension(400, 50));
        this.pinPanel.setMaximumSize(new Dimension(400, 600));
        this.pinPanel.setMinimumSize(new Dimension(400, 600));
        this.controlPanel.setMaximumSize(new Dimension(400, 80));
        this.controlPanel.setMinimumSize(new Dimension(400, 80));
        this.logger.setMaximumSize(new Dimension(500, 300));
        this.logger.setMinimumSize(new Dimension(500, 300));
        this.loggerPanel.setMaximumSize(new Dimension(800, 300));
        this.loggerPanel.setMinimumSize(new Dimension(800, 300));
        this.serial.setMaximumSize(new Dimension(300, 300));
        this.serial.setMinimumSize(new Dimension(300, 300));
        int n = 0;
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 2;
        this.pane.add((Component)this.projectPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 2;
        this.pane.add((Component)this.controlPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 1;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.pane.add((Component)this.pinPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.pane.add((Component)this.logPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.pane.add((Component)this.loggerPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.pane.add((Component)this.infoPanel, this.constraints);
    }

    public boolean isBoardSupported(String string) {
        return this.board.isSupported(string);
    }

    public String[] getSupportedBoards() {
        return this.board.getSupported();
    }

    private void setupBoardPins() {
        int n = 0;
        String string = this.jState.getBoard();
        if (string == null) {
            return;
        }
        this.jState.setBoardPins(this.searduino.getBoardPins(string));
        if (this.jState.getBoardPins() <= 0) {
            System.out.println("setupBoardPins() --------------- too few pins, leaving " + this.jState.getBoardPins());
            return;
        }
        this.pins.setupPins();
        n = this.searduino.setUpBoard();
        this.pins.setupPinTypes();
        this.jpref.setBoard(string);
        this.infoPanel.setBoardName(string);
        this.version = this.searduino.getSearduinoVersion();
    }

    private int setupBoard(String string) {
        int n = this.searduino.setBoardName(string);
        if (n == 0) {
            System.out.println("Failed setting board name....");
            return 1;
        }
        this.jState.setBoard(string);
        this.setupBoardPins();
        return 0;
    }

    public void handlePinTypeEvent(int n, int n2) {
        this.pins.setTypeInputPin(n, n2, true);
    }

    public void handleLogEvent(int n, String string) {
        this.serial.addLog(string);
    }

    public void handleLCDEvent(String string, String string2) {
        this.lcd.setText(string, string2);
    }

    @Override
    public void handleBoardChoiceEvent(String string) {
        this.stopArduinoCode(false);
        this.setupBoard(string);
    }

    public void handlePinModeEvent(int n, int n2) {
        if (n == 0) {
            return;
        }
        this.pins.setMode(n, n2);
    }

    public void handlePinOutEvent(int n, int n2, int n3) {
        this.pins.setPinValue(n, n2, n3);
    }

    @Override
    public void inputValueEvent(int n, int n2) {
        this.searduino.setInputPinValue(n, n2, this.pins.getInputPinTypeLocal(n));
    }

    @Override
    public void ExecEvent(int n) {
        if (n == 2) {
            this.addLog("PAUSE");
            this.searduino.pauseArduinoCode();
        } else if (n == 3) {
            this.addLog("RESUME");
            this.searduino.resumeArduinoCode();
        } else if (n == 4) {
            this.addLog("HALT");
            this.stopArduinoCode(false);
        } else if (n == 1) {
            this.addLog("START");
            this.stopArduinoCode(true);
            boolean bl = false;
            if (!this.jState.getCurrentSearduinoProject().equals("")) {
                bl = true;
            }
            this.useCode(new File(this.jState.getCanonicalCodeName()), bl);
            this.searduino.startArduinoCode();
        }
    }

    public void getAndUseArduinoCodeName(String string, boolean bl) {
        this.stopArduinoCode(true);
        String string2 = bl ? string : (string == null ? this.jpref.getArduinoCodeName(1) : string);
        File file = new File(string2);
        if (file == null) {
            this.addLog("Couldn't open Arduino file: " + string);
            return;
        }
        this.openArduinoFileEvent(file, bl);
    }

    public void showArduinoCodeNameMenu() {
        this.jmenu.removeCodeItems();
        for (int i = 0; i < this.codeNamesToStore; ++i) {
            this.jmenu.updateCodeItem(i, this.jpref.getArduinoCodeName(i));
        }
    }

    public void removeJPrefFawlty() {
        int n;
        for (int i = 0; i < this.codeNamesToStore && (n = i + 1) != this.codeNamesToStore; ++i) {
            boolean bl;
            if (i == this.codeNamesToStore) continue;
            File file = new File(this.jpref.getArduinoCodeName(i));
            boolean bl2 = bl = file.isFile() && file.canRead();
            if ((this.jpref.getArduinoCodeName(n).length() == 0 || !this.jpref.getArduinoCodeName(i).equals(this.jpref.getArduinoCodeName(n))) && bl) continue;
            for (int j = n; j < this.codeNamesToStore; ++j) {
                this.jpref.setArduinoCodeName(j, this.jpref.getArduinoCodeName(j + 1));
                this.jpref.unsetArduinoCodeName(j + 1);
            }
        }
    }

    public void saveArduinoCodeName(String string, String string2) {
        int n;
        boolean bl = false;
        this.removeJPrefFawlty();
        for (n = 0; n < this.codeNamesToStore; ++n) {
            int n2 = n + 1;
            if (!string.equals(this.jpref.getArduinoCodeName(n))) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        for (n = this.codeNamesToStore - 1; n > -1; --n) {
            this.jpref.setArduinoCodeName(n + 1, this.jpref.getArduinoCodeName(n));
        }
        System.out.println("\n\n======= STORE " + string + "==================== \n+n");
        this.jpref.setArduinoCodeName(0, string);
        this.projectPanel.setArduinoCodeName(string2);
        this.showArduinoCodeNameMenu();
    }

    public void showError(String string) {
        this.addLog(string);
        JOptionPane.showMessageDialog(this, "Failed to " + string, string + " error", 0);
    }

    public void useCode(File file, boolean bl) {
        int n = 1;
        String string = null;
        String string2 = null;
        this.addLog("useCode(" + file + ", " + bl + ")");
        try {
            string = file.getName();
            string2 = file.getCanonicalPath();
            n = this.searduino.setArduinoCodeName(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.showError("load Arduino code: " + file);
            return;
        }
        catch (IOException iOException) {
            this.showError("load Arduino code: " + file);
            return;
        }
        if (n != 0) {
            if (this.jState.buildTypeStub()) {
                this.setSearduinoProjectInfo(this.jState.getCurrentSearduinoProject(), "", "");
                this.showError("load Arduino code: " + file);
            }
            this.projectPanel.setArduinoCodeName("");
            this.ec.unsetAll();
            return;
        }
        this.addLog("Loaded Arduino code: " + file);
        this.setupBoardPins();
        if (file.isDirectory()) {
            this.setSearduinoProjectInfo(string, "", "");
            this.ec.setStartable();
        } else {
            String string3 = bl ? this.jState.getCurrentSearduinoProject() : "";
            this.setSearduinoProjectInfo(string3, string, string2);
            this.saveArduinoCodeName(string2, string);
            this.ec.setStartable();
        }
    }

    public void setSearduinoProjectInfo(String string, String string2, String string3) {
        if (string == null) {
            string = "";
        }
        if (string.equals("")) {
            this.searduino.closeArduinoCode();
        }
        this.jState.setCurrentSearduinoProject(string);
        this.projectPanel.setProjectName(string);
        if (string2 != null) {
            this.jState.setCodeName(string2, string3);
            this.projectPanel.setArduinoCodeName(string2);
        }
    }

    @Override
    public void handleArduinoFileEvent(File file) {
        this.openArduinoFileEvent(file, false);
    }

    public void openArduinoFileEvent(File file, boolean bl) {
        boolean bl2 = false;
        String string = null;
        this.addLog("Opening file: " + file);
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.showError("load Arduino code: " + file.toString());
            return;
        }
        if (bl) {
            this.setSearduinoProjectInfo(this.jState.getCurrentSearduinoProject(), file.getName(), string);
        } else {
            this.setSearduinoProjectInfo("", file.getName(), string);
        }
        this.useCode(file, bl);
    }

    public void stopArduinoCode(boolean bl) {
        this.addLog("---> stopArduinoCode");
        this.searduino.haltArduinoCode();
        if (bl && this.jState.buildTypeStub()) {
            this.searduino.closeArduinoCode();
        }
        this.addLog("<--- stopArduinoCode");
    }

    public static void waitAWhile(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("waitAWhile() - exception\n");
        }
    }

    @Override
    public void handleArduinoCodeNameEvent(int n) {
        this.stopArduinoCode(true);
        this.setSearduinoProjectInfo("", this.jpref.getArduinoCodeName(n), this.jpref.getArduinoCodeName(n));
        this.searduino.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.ec.setStartable();
    }

    public void execCommand(String string, String string2) throws IOException {
        String string3;
        String string4 = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        process = Runtime.getRuntime().exec(string);
        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        string4 = "Command: " + string + "\n";
        while ((string3 = bufferedReader.readLine()) != null) {
            string4 = string4 + string3 + "\n";
        }
        this.addLog(string4);
        System.out.println(" Output from: " + string);
        System.out.println(" \t " + string4);
        int n = process.exitValue();
        String string5 = "SUCCESS";
        if (n != 0) {
            string5 = "ERROR";
        }
        this.addLog(string5 + ":");
        this.addLog("  Command:      " + string);
        if (n != 0) {
            this.addLog("  return value: " + n);
            this.showError(string2);
        }
    }

    @Override
    public void handleJearduinoEvent(int n, Object object) {
        if (n == 1) {
            this.jState.setCurrentBuildType(this.jState.SEARDUINO_STATE_STUB);
            this.buildSearduinoProject(this.jState.getCurrentSearduinoProject());
        } else if (n == 2) {
            this.jState.setCurrentBuildType(this.jState.SEARDUINO_STATE_ARDUINO);
            this.buildSearduinoProject(this.jState.getCurrentSearduinoProject(), this.searduino.getBoardName(), false);
        } else if (n == 3) {
            this.jState.setCurrentBuildType(this.jState.SEARDUINO_STATE_ARDUINO);
            this.buildSearduinoProject(this.jState.getCurrentSearduinoProject(), this.searduino.getBoardName(), true);
        }
    }

    private void getAndUseSearduinoDir(File file) {
        this.stopArduinoCode(true);
        String string = null;
        String string2 = file.getName();
        try {
            if (file.exists()) {
                string = file.getCanonicalPath() + "/lib" + string2.toLowerCase() + ".so";
            } else {
                String string3 = System.getProperty("searduino.project.dir");
                string = string3 + "/" + string2 + "/lib" + string2.toLowerCase() + ".so";
            }
        }
        catch (IOException iOException) {
            this.addLog("Failed opening directory: " + file);
            this.addLog("  Exception: " + iOException);
            return;
        }
        this.setSearduinoProjectInfo(file.toString(), "", "");
        this.getAndUseArduinoCodeName(string, true);
    }

    @Override
    public void handleSearduinoDirEvent(File file) {
        this.stopArduinoCode(true);
        this.getAndUseSearduinoDir(file);
    }

    private void buildSearduinoProject(File file, String string, boolean bl) {
        String string2 = "build";
        String string3 = System.getProperty("searduino.dir") + "/bin/searduino-builder ";
        String string4 = "";
        if (string.equals("")) {
            string = "stub";
        }
        String string5 = "";
        if (bl) {
            string5 = " --upload ";
            string2 = "Upload";
        }
        string4 = " --board " + string + " ";
        try {
            String string6;
            String string7 = null;
            String string8 = file.getName();
            if (file.exists()) {
                string7 = file.getCanonicalPath();
            } else {
                string6 = System.getProperty("searduino.project.dir");
                string7 = string6 + "/" + string8;
            }
            string6 = string4 + string5 + " " + string7;
            string3 = string3 + " " + string6;
            this.execCommand(string3, string2 + " (" + string7 + ") to " + string);
            if (this.jState.buildTypeStub()) {
                this.getAndUseSearduinoDir(file);
            } else {
                this.ec.unsetAll();
            }
        }
        catch (IOException iOException) {
            this.addLog("Failed building file: " + this.jState.getCurrentSearduinoProject());
        }
    }

    private void buildSearduinoProject(File file, String string) {
        this.buildSearduinoProject(file, string, false);
    }

    private void buildSearduinoProject(String string, String string2) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        this.buildSearduinoProject(file, string2);
    }

    private void buildSearduinoProject(String string, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        this.buildSearduinoProject(file, string2, bl);
    }

    private void buildSearduinoProject(String string) {
        this.buildSearduinoProject(string, "stub");
    }

    private void buildSearduinoProject(File file) {
        this.buildSearduinoProject(file, "stub");
    }

    private void createSearduinoFromIno(File file) throws IOException {
        String string = file.getName();
        String string2 = System.getProperty("searduino.dir") + "/bin/searduino-builder";
        String string3 = "--ino-dir " + file;
        string2 = string2 + " " + string3;
        this.execCommand(string2, "Import INO dir (" + file + ")");
    }

    public boolean validBoard() {
        return !this.searduino.getBoardName().equals("<none>");
    }

    @Override
    public void handleInoDirEvent(File file) {
        try {
            this.createSearduinoFromIno(file);
            String string = System.getProperty("searduino.project.dir");
            String string2 = file.getName();
            this.buildSearduinoProject(string2);
        }
        catch (IOException iOException) {
            this.addLog("ERROR when building from INO file");
            iOException.printStackTrace();
            return;
        }
    }

    public String getJearduinoState() {
        return this.jState.toString();
    }

    public String getSearduinoState() {
        return this.searduino.getSystemInformation();
    }

    public static void main(String[] stringArray) {
        final Jearduino jearduino = new Jearduino();
        boolean bl = false;
        boolean bl2 = false;
        int n = stringArray.length;
        String string = "<none>";
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("--board")) {
                if (i + 1 < n) {
                    string = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --board");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--arduino-code")) {
                if (i + 1 < n) {
                    string2 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --arduino-code");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--searduino-project")) {
                if (i + 1 < n) {
                    string3 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --seardino-project");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--build")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("--start")) {
                bl = true;
                continue;
            }
            System.err.println("Error when pasing command line '" + stringArray[i] + "'");
            System.exit(1);
        }
        if (string3 != null && string2 != null) {
            System.out.println("You can't supply both --arduino-code and --searduino-project arguments");
            System.exit(1);
        }
        if (string == null) {
            string = jearduino.jpref.getBoard();
        }
        if (n2 != 0) {
            System.out.println("Could not set up board " + string + " returned: " + n2);
            System.exit(n2);
        }
        jearduino.fileLogger.start();
        jearduino.showArduinoCodeNameMenu();
        System.out.println("Searduino version: " + jearduino.version);
        System.out.println("Searduino board:   " + jearduino.searduino.getBoardName());
        if (string2 == null && string3 == null) {
            bl = false;
        }
        if (jearduino.isBoardSupported(string)) {
            n2 = jearduino.setupBoard(string);
        } else {
            System.out.println("You supplied an unsupported board: " + string);
            Object[] objectArray = jearduino.getSupportedBoards();
            String string4 = Arrays.toString(objectArray);
            System.out.println("   Supported boards: " + string4);
            System.exit(1);
        }
        if (string3 != null) {
            jearduino.handleSearduinoDirEvent(new File(string3));
        } else if (string2 != null) {
            jearduino.getAndUseArduinoCodeName(string2, false);
        } else {
            jearduino.getAndUseArduinoCodeName(null, false);
        }
        if (bl2) {
            jearduino.handleJearduinoEvent(1, null);
        }
        if (bl) {
            jearduino.ec.sendStart();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jearduino.setVisible(true);
            }
        });
    }
}

