/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.Jearduino;
import com.sandklef.jearduino.Tailer;
import com.sandklef.jearduino.TailerEvent;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class FileLogger
extends JPanel
implements TailerEvent,
ActionListener {
    private JTextArea textArea;
    Tailer tailer;
    JButton clear;
    JButton printState;
    Jearduino jearduino;
    JPanel pane;
    JScrollPane scrollPane;

    public FileLogger(String string, Jearduino jearduino) {
        super(new GridLayout(2, 1));
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        this.pane = new JPanel();
        this.clear = new JButton("Clear");
        this.printState = new JButton("Print State");
        this.jearduino = jearduino;
        this.add(this.scrollPane);
        this.add(this.pane);
        this.pane.add(this.clear);
        this.pane.add(this.printState);
        this.scrollPane.setPreferredSize(new Dimension(600, 700));
        this.clear.addActionListener(this);
        this.printState.addActionListener(this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (actionEvent.getSource() == this.clear) {
            this.textArea.setText("");
        } else if (actionEvent.getSource() == this.printState) {
            this.addLog(this.jearduino.getJearduinoState());
            this.addLog(this.jearduino.getSearduinoState());
            this.addLog(this.jearduino.searduino.getBoardSetup());
        }
    }

    @Override
    public void handleFileInput(String string) {
        this.addLog(string + "\n");
    }

    public void start() {
        this.tailer = new Tailer("/tmp/searduino-internal.log", this);
        Thread thread = new Thread(this.tailer);
        thread.start();
    }

    public void addLog(String string) {
        this.textArea.append(string);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
        this.validate();
        this.revalidate();
        this.repaint();
    }
}

