/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.ArduinoCodeNameEvent;
import com.sandklef.jearduino.Board;
import com.sandklef.jearduino.BoardEvent;
import com.sandklef.jearduino.DirEvent;
import com.sandklef.jearduino.ExecControl;
import com.sandklef.jearduino.ExecEvent;
import com.sandklef.jearduino.FileEvent;
import com.sandklef.jearduino.FileLogger;
import com.sandklef.jearduino.InfoPanel;
import com.sandklef.jearduino.InoDirEvent;
import com.sandklef.jearduino.JearduinoEvent;
import com.sandklef.jearduino.JearduinoMenu;
import com.sandklef.jearduino.JearduinoPreferences;
import com.sandklef.jearduino.LCD;
import com.sandklef.jearduino.Logger;
import com.sandklef.jearduino.PinEvent;
import com.sandklef.jearduino.PinTable;
import com.sandklef.jearduino.ProjectPanel;
import com.sandklef.searduino.Searduino;
import com.sandklef.searduino.SearduinoObserver;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class Jearduino
extends JFrame
implements SearduinoObserver,
ExecEvent,
PinEvent,
BoardEvent,
FileEvent,
DirEvent,
InoDirEvent,
ArduinoCodeNameEvent,
JearduinoEvent {
    Searduino searduino;
    JearduinoPreferences jpref = new JearduinoPreferences();
    JearduinoMenu jmenu;
    GridBagConstraints constraints;
    PinTable pins;
    Logger serial;
    Logger logger;
    FileLogger fileLogger;
    LCD lcd;
    InfoPanel infoPanel;
    ProjectPanel projectPanel;
    Container topPane;
    JPanel pane;
    JTabbedPane tabbedPane;
    private int codeNamesToStore = this.jpref.getArduinoCodeNameCount();
    private int nrpins = 0;
    public String version;
    JPanel topPanel;
    JPanel controlPanel;
    JPanel pinPanel;
    JPanel logPanel;
    JPanel loggerPanel;
    JPanel fileLoggerPanel;
    ExecControl ec;
    Board board;
    String currentSearduinoProject = "";
    static int appSizeHeight = 700;
    static int appSizeWidth = 1080;
    static int infoSizeHeight = 20;
    static int infoSizeWidth = 800;

    public Jearduino() {
        this.constraints = new GridBagConstraints();
        this.pane = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.topPane = this.getContentPane();
        this.topPane.add(jTabbedPane);
        this.pane.setLayout(new GridBagLayout());
        this.setSize(appSizeHeight, appSizeWidth);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 3));
        this.pinPanel = new JPanel();
        this.logPanel = new JPanel();
        this.loggerPanel = new JPanel();
        this.fileLoggerPanel = new JPanel();
        this.pinPanel.setVisible(true);
        this.pinPanel.setLayout(new GridLayout());
        this.logPanel.setLayout(new BoxLayout(this.logPanel, 3));
        this.ec = new ExecControl(this);
        this.controlPanel.add(this.ec);
        this.controlPanel.setVisible(true);
        this.jmenu = new JearduinoMenu(this, this, this, this, this, this);
        this.setJMenuBar(this.jmenu);
        this.board = new Board(this);
        this.searduino = new Searduino();
        this.infoPanel = new InfoPanel();
        this.projectPanel = new ProjectPanel();
        this.logger = new Logger("Log");
        this.fileLogger = new FileLogger("File Log");
        this.serial = new Logger("Serial");
        this.lcd = new LCD("LCD");
        this.serial.setMaximumSize(new Dimension(200, 400));
        this.logger.setMaximumSize(new Dimension(200, 400));
        this.fileLogger.setMaximumSize(new Dimension(200, 1000));
        this.lcd.setMaximumSize(new Dimension(200, 400));
        this.serial.setPreferredSize(new Dimension(200, 100));
        this.logger.setPreferredSize(new Dimension(600, 150));
        this.fileLogger.setPreferredSize(new Dimension(600, 400));
        this.lcd.setPreferredSize(new Dimension(200, 100));
        this.logPanel.add(this.serial);
        this.logPanel.add(this.lcd);
        this.loggerPanel.add(this.logger);
        this.fileLoggerPanel.add(this.fileLogger);
        this.pins = new PinTable(this, this.searduino);
        this.pins.setVisible(true);
        this.pinPanel.add(this.pins);
        this.setTitle("Jearduino - Searduino's Java frontend for Arduino simulation");
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.searduino.setWriteTimelimit(0);
        this.searduino.disableStreamedOutput();
        this.searduino.registerPinModeCallback((SearduinoObserver)this);
        this.searduino.registerPinOutCallback((SearduinoObserver)this);
        this.searduino.registerPinTypeCallback((SearduinoObserver)this);
        this.searduino.registerLogCallback((SearduinoObserver)this);
        this.searduino.registerLCDCallback((SearduinoObserver)this);
        this.projectPanel.setArduinoCodeName(this.searduino.getArduinoCodeName());
        this.infoPanel.setSearduinoVersion(this.searduino.getSearduinoVersion());
        jTabbedPane.addTab("Control", null, this.pane, "Main tab");
        jTabbedPane.addTab("Log", null, this.fileLoggerPanel, "Log tab");
        this.setupSizes();
    }

    public void addLog(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-dd hh:mm:ss");
        String string2 = simpleDateFormat.format(new Date());
        String string3 = "[" + string2 + " jearduino-logger]: " + string + "\n";
        System.out.println("Logger:   " + string);
        System.out.flush();
        this.logger.addLog(string3);
        this.fileLogger.addLog(string3);
    }

    void tailLog() {
    }

    public void setupSizes() {
        this.projectPanel.setMinimumSize(new Dimension(10, 300));
        this.projectPanel.setMaximumSize(new Dimension(10, 300));
        this.infoPanel.setMinimumSize(new Dimension(400, 50));
        this.infoPanel.setMaximumSize(new Dimension(400, 50));
        this.pinPanel.setMaximumSize(new Dimension(400, 600));
        this.pinPanel.setMinimumSize(new Dimension(400, 600));
        this.controlPanel.setMaximumSize(new Dimension(400, 80));
        this.controlPanel.setMinimumSize(new Dimension(400, 80));
        this.logger.setMaximumSize(new Dimension(500, 300));
        this.logger.setMinimumSize(new Dimension(500, 300));
        this.loggerPanel.setMaximumSize(new Dimension(800, 300));
        this.loggerPanel.setMinimumSize(new Dimension(800, 300));
        this.serial.setMaximumSize(new Dimension(300, 300));
        this.serial.setMinimumSize(new Dimension(300, 300));
        int n = 0;
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 2;
        System.out.println("projectPanel" + this.projectPanel + " c " + this.constraints);
        this.pane.add((Component)this.projectPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 2;
        this.pane.add((Component)this.controlPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 1;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.pane.add((Component)this.pinPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = n;
        this.constraints.ipadx = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.pane.add((Component)this.logPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.pane.add((Component)this.loggerPanel, this.constraints);
        this.constraints.fill = 2;
        this.constraints.ipady = 0;
        this.constraints.weightx = 0.0;
        this.constraints.gridwidth = 0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.pane.add((Component)this.infoPanel, this.constraints);
    }

    private void setupBoardPins() {
        this.logger.addLog("setupBoardPins() <---------------");
        String string = this.searduino.getBoardName();
        if (string == null) {
            return;
        }
        this.jpref.setBoard(string);
        this.infoPanel.setBoardName(string);
        this.nrpins = this.searduino.getNrOfPins();
        this.version = this.searduino.getSearduinoVersion();
        this.pins.setupPins();
    }

    private void setupBoard(String string) {
        String string2 = this.searduino.getSearduinoVersion();
        this.searduino.setBoardName(string);
        this.setupBoardPins();
    }

    public void handlePinTypeEvent(int n, int n2) {
        this.pins.setTypeInputPin(n, n2, true);
    }

    public void handleLogEvent(int n, String string) {
        this.serial.addLog(string);
    }

    public void handleLCDEvent(String string, String string2) {
        this.lcd.setText(string, string2);
    }

    @Override
    public void handleBoardChoiceEvent(String string) {
        this.setupBoard(string);
    }

    public void handlePinModeEvent(int n, int n2) {
        if (n == 0) {
            return;
        }
        this.addLog("EVENT: PIN MODE JAVA (really) pin[" + n + "]: mode=" + n2);
        this.pins.setMode(n, n2);
    }

    public void handlePinOutEvent(int n, int n2, int n3) {
        this.pins.setPinValue(n, n2, n3);
    }

    @Override
    public void inputValueEvent(int n, int n2) {
        this.searduino.setInputPinValue(n, n2, this.pins.getInputPinTypeLocal(n));
    }

    @Override
    public void ExecEvent(int n) {
        if (n == 2) {
            this.addLog("PAUSE");
            this.searduino.pauseArduinoCode();
        } else if (n == 3) {
            this.addLog("RESUME");
            this.searduino.resumeArduinoCode();
        } else if (n == 4) {
            this.addLog("HALT");
            this.stopArduinoCode(false);
        } else if (n == 1) {
            this.addLog("START");
            this.searduino.startArduinoCode();
        }
    }

    public void getAndUseArduinoCodeName(String string) {
        this.stopArduinoCode(true);
        String string2 = string == null ? this.jpref.getArduinoCodeName(1) : string;
        File file = new File(string2);
        if (file == null) {
            this.addLog("Couldn't open Arduino file: " + string);
            return;
        }
        this.openArduinoFileEvent(file);
    }

    public void showArduinoCodeNameMenu() {
        this.jmenu.removeCodeItems();
        for (int i = 0; i < this.codeNamesToStore; ++i) {
            this.jmenu.updateCodeItem(i, this.jpref.getArduinoCodeName(i));
        }
    }

    public void removeJPrefFawlty() {
        int n;
        for (int i = 0; i < this.codeNamesToStore && (n = i + 1) != this.codeNamesToStore; ++i) {
            boolean bl;
            if (i == this.codeNamesToStore) continue;
            File file = new File(this.jpref.getArduinoCodeName(i));
            boolean bl2 = bl = file.isFile() && file.canRead();
            if ((this.jpref.getArduinoCodeName(n).length() == 0 || !this.jpref.getArduinoCodeName(i).equals(this.jpref.getArduinoCodeName(n))) && bl) continue;
            for (int j = n; j < this.codeNamesToStore; ++j) {
                this.jpref.setArduinoCodeName(j, this.jpref.getArduinoCodeName(j + 1));
                this.jpref.unsetArduinoCodeName(j + 1);
            }
        }
    }

    public void saveArduinoCodeName(String string, String string2) {
        int n;
        boolean bl = false;
        this.removeJPrefFawlty();
        for (n = 0; n < this.codeNamesToStore; ++n) {
            int n2 = n + 1;
            if (!string.equals(this.jpref.getArduinoCodeName(n))) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        for (n = this.codeNamesToStore - 1; n > -1; --n) {
            this.jpref.setArduinoCodeName(n + 1, this.jpref.getArduinoCodeName(n));
        }
        this.jpref.setArduinoCodeName(0, string);
        this.projectPanel.setArduinoCodeName(string2);
        this.showArduinoCodeNameMenu();
    }

    public void setSearduinoProjectInfo(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals("")) {
            this.searduino.closeArduinoCode();
        }
        this.currentSearduinoProject = string;
        this.projectPanel.setProjectName(string);
    }

    @Override
    public void handleArduinoFileEvent(File file) {
        this.stopArduinoCode(true);
        this.setupBoardPins();
        this.openArduinoFileEvent(file);
        this.setArduinoFileInfo("");
        this.setSearduinoProjectInfo("");
    }

    public void setArduinoFileInfo(String string) {
        this.projectPanel.setArduinoCodeName(string);
        this.projectPanel.setProjectName("");
        this.setSearduinoProjectInfo(string);
    }

    public void openArduinoFileEvent(File file) {
        String string = "";
        int n = 0;
        this.addLog("Opening file: " + file);
        this.setArduinoFileInfo("");
        try {
            string = file.getCanonicalPath();
            n = this.searduino.setArduinoCodeName(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.projectPanel.setArduinoCodeName("");
            this.addLog("Failed loading Arduino code: " + file);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Uh oh... could not get file name");
            this.addLog("Failed loading Arduino code: " + file.toString());
        }
        if (n != 0) {
            this.setArduinoFileInfo("");
            this.addLog("Failed loading Arduino code: " + file);
            this.ec.unsetAll();
        } else {
            this.addLog("Loaded Arduino code: " + file);
            this.setupBoardPins();
            if (file.isDirectory()) {
                this.projectPanel.setProjectName(file.toString());
            } else if (file.isFile()) {
                this.projectPanel.setArduinoCodeName(file.toString());
            } else {
                this.setArduinoFileInfo(string);
            }
            this.saveArduinoCodeName(string, file.getName());
            this.ec.setStartable();
        }
    }

    public void stopArduinoCode(boolean bl) {
        this.addLog("---> stopArduinoCode");
        this.searduino.haltArduinoCode();
        if (bl) {
            this.addLog("---> unset");
            this.searduino.closeArduinoCode();
            this.addLog("<--- unset");
        }
        this.addLog("--- stopArduinoCode setup pins");
        this.setupBoardPins();
        this.addLog("--- stopArduinoCode setup pins done");
        this.addLog("<--- stopArduinoCode");
    }

    public void waitAWhile(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("waitAWhile() - exception\n");
        }
    }

    @Override
    public void handleArduinoCodeNameEvent(int n) {
        this.addLog("--- 1 handleArduinoCodeNameEvent");
        this.addLog("---> handleArduinoCodeNameEvent");
        this.stopArduinoCode(true);
        this.addLog("---  handleArduinoCodeNameEvent ac stoped");
        this.projectPanel.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.addLog("--- 2 handleArduinoCodeNameEvent");
        this.projectPanel.setProjectName("");
        this.addLog("--- 3 handleArduinoCodeNameEvent");
        this.projectPanel.setProjectName(null);
        this.projectPanel.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.searduino.setArduinoCodeName(this.jpref.getArduinoCodeName(n));
        this.addLog("--- 4 handleArduinoCodeNameEvent");
        this.ec.setStartable();
        this.addLog("<--- handleArduinoCodeNameEvent");
    }

    public void execCommand(String string) throws IOException {
        String string2;
        String string3 = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        process = Runtime.getRuntime().exec(string);
        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        string3 = "Command: " + string + "\n";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\n";
        }
        this.addLog(string3);
        System.out.println(" Output from: " + string);
        System.out.println(" \t " + string3);
    }

    public void craeteSearduinoProjectFromIno() {
    }

    @Override
    public void handleJearduinoEvent(int n, Object object) {
        if (n == 1) {
            try {
                if (this.currentSearduinoProject != null) {
                    this.buildSearduinoProject(new File(this.currentSearduinoProject));
                }
            }
            catch (IOException iOException) {
                this.addLog("Failed opening file: " + this.currentSearduinoProject);
            }
        }
    }

    private void getAndUseSearduinoDir(File file) {
        String string = System.getProperty("searduino.project.dir");
        String string2 = file.getName();
        String string3 = string + "/" + string2 + "/lib" + string2.toLowerCase() + ".so";
        this.stopArduinoCode(true);
        this.getAndUseArduinoCodeName(string3);
    }

    @Override
    public void handleSearduinoDirEvent(File file) {
        this.stopArduinoCode(true);
        this.getAndUseSearduinoDir(file);
        this.setSearduinoProjectInfo(file.toString());
    }

    private void buildSearduinoProject(File file) throws IOException {
        String string = file.getName();
        String string2 = System.getProperty("searduino.project.dir");
        String string3 = System.getProperty("searduino.dir") + "/bin/searduino-builder ";
        String string4 = string2 + "/" + string;
        string3 = string3 + " " + string4;
        this.execCommand(string3);
        this.getAndUseSearduinoDir(file);
    }

    private void createSearduinoFromIno(File file) throws IOException {
        String string = file.getName();
        String string2 = System.getProperty("searduino.dir") + "/bin/searduino-builder";
        String string3 = "--ino-dir " + file;
        string2 = string2 + " " + string3;
        this.execCommand(string2);
    }

    @Override
    public void handleInoDirEvent(File file) {
        try {
            this.createSearduinoFromIno(file);
            this.buildSearduinoProject(file);
            this.getAndUseSearduinoDir(file);
            this.setSearduinoProjectInfo(file.toString());
        }
        catch (IOException iOException) {
            this.addLog("ERROR when building from INO file");
            iOException.printStackTrace();
            return;
        }
    }

    public static void main(String[] stringArray) {
        final Jearduino jearduino = new Jearduino();
        boolean bl = false;
        int n = stringArray.length;
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("--board")) {
                if (i + 1 < n) {
                    string = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --board");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--arduino-code")) {
                if (i + 1 < n) {
                    string2 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --arduino-code");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--searduino-project")) {
                if (i + 1 < n) {
                    string3 = stringArray[i + 1];
                    ++i;
                    continue;
                }
                System.err.println("Missing args to --arduino-code");
                System.exit(1);
                continue;
            }
            if (stringArray[i].equals("--start")) {
                bl = true;
                continue;
            }
            System.err.println("Error when pasing command line '" + stringArray[i] + "'");
            System.exit(1);
        }
        if (string3 != null && string2 != null) {
            System.out.println("You can't supply both --arduino-code and --searduino-project arguments");
            System.exit(1);
        }
        if (string == null) {
            jearduino.setupBoard(jearduino.jpref.getBoard());
        } else {
            jearduino.setupBoard(string);
        }
        if (string3 != null) {
            jearduino.handleSearduinoDirEvent(new File(string3));
        } else if (string2 != null) {
            jearduino.getAndUseArduinoCodeName(string2);
        } else {
            jearduino.getAndUseArduinoCodeName(null);
        }
        jearduino.fileLogger.start();
        jearduino.showArduinoCodeNameMenu();
        System.out.println("Searduino version: " + jearduino.version);
        System.out.println("Searduino board:   " + jearduino.searduino.getBoardName());
        if (bl) {
            jearduino.ec.sendStart();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jearduino.setVisible(true);
            }
        });
    }
}

