/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.searduino;

import com.sandklef.searduino.SearduinoObserver;

public class Searduino {
    private static final int SEARDUINO_PIN_MODE = 1;
    private static final int SEARDUINO_PIN_VALUE = 2;
    private static final int SEARDUINO_PIN_TYPE = 3;
    private static final int SEARDUINO_LOG = 4;
    private static final int SEARDUINO_LCD = 5;
    public static final int SEARDUINO_PINTYPE_DIGITAL = 1;
    public static final int SEARDUINO_PINTYPE_ANALOG = 2;
    public static final int SEARDUINO_PINTYPE_PWM = 3;
    public static final String SEARDUINO_PINTYPE_DIGITAL_STRING = "Digital";
    public static final String SEARDUINO_PINTYPE_ANALOG_STRING = "Analog";
    public static final String SEARDUINO_PINTYPE_PWM_STRING = "PWM";
    SearduinoObserver observer;

    public native int getWriteTimelimit();

    public native int setWriteTimelimit(int var1);

    public native void pauseArduinoCode();

    public native void resumeArduinoCode();

    public native void haltArduinoCode();

    public native int isPausedArduinoCode();

    public native int isHaltedArduinoCode();

    public native int isRunningArduinoCode();

    public native int isPausableArduinoCode();

    public native void disableStreamedOutput();

    public native void enableStreamedOutput();

    public native void startArduinoCode();

    public native String getArduinoCodeName();

    public native void closeArduinoCode();

    public native String getSearduinoVersion();

    public native String getSearduinoName();

    public native String getBoardName();

    public native int setBoardName(String var1);

    public native int getNrOfPins();

    public native int getDigitalMode(int var1);

    public native int setArduinoCodeName(String var1);

    public native int getCurrentPinType(int var1);

    public native int hasGenericPinType(int var1, int var2);

    private native int registerPinCallback(SearduinoObserver var1, int var2);

    public native int fakeAnalogInput(int var1, int var2);

    public native int fakeDigitalInput(int var1, int var2);

    public Searduino() {
        System.loadLibrary("searduinojni");
    }

    public boolean hasGenericPinTypeBoolean(int n, int n2) {
        return this.hasGenericPinType(n, n2) == 1;
    }

    public int getPinMode(int n) {
        return n - 1;
    }

    public static int getPinType(String string) {
        if (string.equals(SEARDUINO_PINTYPE_DIGITAL_STRING)) {
            return 1;
        }
        if (string.equals(SEARDUINO_PINTYPE_ANALOG_STRING)) {
            return 2;
        }
        if (string.equals(SEARDUINO_PINTYPE_PWM_STRING)) {
            return 3;
        }
        return -1;
    }

    public static String getPinType(int n) {
        if (n == 1) {
            return SEARDUINO_PINTYPE_DIGITAL_STRING;
        }
        if (n == 3) {
            return SEARDUINO_PINTYPE_PWM_STRING;
        }
        if (n == 2) {
            return SEARDUINO_PINTYPE_ANALOG_STRING;
        }
        return "";
    }

    private void registerObserver(SearduinoObserver searduinoObserver) {
        if (this.observer == null) {
            this.observer = searduinoObserver;
        }
    }

    public void registerPinModeCallback(SearduinoObserver searduinoObserver) {
        this.registerObserver(searduinoObserver);
        this.registerPinCallback(searduinoObserver, 1);
    }

    public void registerPinOutCallback(SearduinoObserver searduinoObserver) {
        this.registerObserver(searduinoObserver);
        this.registerPinCallback(searduinoObserver, 2);
    }

    public void registerPinTypeCallback(SearduinoObserver searduinoObserver) {
        this.registerObserver(searduinoObserver);
        this.registerPinCallback(searduinoObserver, 3);
    }

    public void registerLogCallback(SearduinoObserver searduinoObserver) {
        this.registerObserver(searduinoObserver);
        try {
            this.registerPinCallback(searduinoObserver, 4);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void registerLCDCallback(SearduinoObserver searduinoObserver) {
        this.registerObserver(searduinoObserver);
        try {
            this.registerPinCallback(searduinoObserver, 5);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void setPwmPin(int n, int n2) {
    }

    public int setInputPinValue(int n, int n2, int n3) {
        if (n3 == 1) {
            return this.fakeDigitalInput(n, n2);
        }
        if (n3 == 2) {
            return this.fakeAnalogInput(n, n2);
        }
        return -1;
    }

    public String getCurrentPinTypeString(int n) {
        if (this.getCurrentPinType(n) == 1) {
            return SEARDUINO_PINTYPE_DIGITAL_STRING;
        }
        if (this.getCurrentPinType(n) == 2) {
            return SEARDUINO_PINTYPE_ANALOG_STRING;
        }
        if (this.getCurrentPinType(n) == 3) {
            return SEARDUINO_PINTYPE_PWM_STRING;
        }
        return "<undefined>";
    }

    public void setupPins() {
        for (int i = 0; i < 100; ++i) {
            System.out.println("setupPins() pin " + i + " " + this.getCurrentPinType(i));
        }
    }
}

