/*
 * Decompiled with CFR 0.152.
 */
package com.sandklef.jearduino;

import com.sandklef.jearduino.ArduinoCodeNameEvent;
import com.sandklef.jearduino.BoardEvent;
import com.sandklef.jearduino.FileEvent;
import com.sandklef.jearduino.JearduinoAbout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class JearduinoMenu
extends JMenuBar
implements ActionListener {
    BoardEvent be;
    FileEvent fe;
    ArduinoCodeNameEvent ae;
    JMenu boardMenu;
    JMenu fileMenu;
    JMenu helpMenu;
    JMenu codeMenu;
    JRadioButtonMenuItem leoItem;
    JRadioButtonMenuItem unoItem;
    JRadioButtonMenuItem megaItem;
    JRadioButtonMenuItem mega2560Item;
    JMenuItem boardItem;
    JMenuItem aboutItem;
    JMenuItem[] codeItem;
    JFileChooser fc;

    public JearduinoMenu(BoardEvent boardEvent, FileEvent fileEvent, ArduinoCodeNameEvent arduinoCodeNameEvent) {
        this.be = boardEvent;
        this.fe = fileEvent;
        this.ae = arduinoCodeNameEvent;
        this.codeItem = new JMenuItem[10];
        this.boardMenu = new JMenu("Board");
        this.fileMenu = new JMenu("File");
        this.helpMenu = new JMenu("Help");
        this.codeMenu = new JMenu("Code");
        this.add(this.fileMenu);
        this.add(this.boardMenu);
        this.add(this.helpMenu);
        this.add(this.codeMenu);
        this.createBoardMenu();
        this.createFileMenu();
        this.createHelpMenu();
    }

    public void findArduinoCode() {
        this.fc = new JFileChooser();
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            File file = this.fc.getSelectedFile();
            try {
                System.out.println("Opening: " + file.getCanonicalPath());
                this.fe.handleArduinoFileEvent(file);
            }
            catch (IOException iOException) {
                System.out.println("Uh oh... could not get file name");
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    public void showAbout() {
        System.out.println("Show about");
        JearduinoAbout jearduinoAbout = new JearduinoAbout();
        jearduinoAbout.pack();
        jearduinoAbout.setVisible(true);
    }

    public int handleCodeChoice(Object object) {
        for (int i = 0; i < 10; ++i) {
            if (object != this.codeItem[i]) continue;
            System.out.println("Code at " + i + " was choosen ");
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("MENU click " + actionEvent.getActionCommand());
        Object object = actionEvent.getSource();
        int n = this.handleCodeChoice(object);
        if (object == this.leoItem || object == this.unoItem || object == this.megaItem || object == this.mega2560Item) {
            this.be.handleBoardChoiceEvent(actionEvent.getActionCommand());
        } else if (object == this.boardItem) {
            this.findArduinoCode();
        } else if (object == this.aboutItem) {
            this.showAbout();
        } else if (n != -1) {
            System.out.println("Code at " + n + " was choosen ");
            this.ae.handleArduinoCodeNameEvent(n);
        }
    }

    public void createFileMenu() {
        this.boardItem = new JMenuItem("Open Arduino file");
        this.fileMenu.add(this.boardItem);
        this.boardItem.addActionListener(this);
    }

    public void createHelpMenu() {
        this.aboutItem = new JMenuItem("About");
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.addActionListener(this);
    }

    public void removeCodeItems() {
        this.codeMenu.removeAll();
    }

    public void updateCodeItem(int n, String string) {
        this.codeItem[n] = new JMenuItem(string);
        this.codeMenu.add(this.codeItem[n]);
        this.codeItem[n].addActionListener(this);
    }

    public void createBoardMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.leoItem = new JRadioButtonMenuItem("Leonardo");
        this.unoItem = new JRadioButtonMenuItem("Uno");
        this.megaItem = new JRadioButtonMenuItem("Mega");
        this.mega2560Item = new JRadioButtonMenuItem("Mega 2560");
        this.boardMenu.add(this.leoItem);
        this.leoItem.addActionListener(this);
        this.unoItem.addActionListener(this);
        this.megaItem.addActionListener(this);
        this.mega2560Item.addActionListener(this);
        buttonGroup.add(this.unoItem);
        buttonGroup.add(this.megaItem);
        buttonGroup.add(this.mega2560Item);
        this.boardMenu.add(this.unoItem);
        this.boardMenu.add(this.megaItem);
        this.boardMenu.add(this.mega2560Item);
    }
}

