/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device;

import java.util.HashMap;
import java.util.Map;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;

public class DeviceData {
    private Map<CommandVariableType, Map<CommandName, Command>> deviceParameters = new HashMap<CommandVariableType, Map<CommandName, Command>>(255);
    private Map<CommandName, Map<Integer, Command>> indexedDeviceParameters = new HashMap<CommandName, Map<Integer, Command>>(16);

    protected void clearParameters() {
        this.deviceParameters.clear();
        this.indexedDeviceParameters.clear();
    }

    public void setDeviceParameter(Command command) {
        CommandName commandName = command.getCommandName();
        if (commandName.isIndexedA()) {
            Map<Integer, Command> cmds = this.getTypeMapIndexed(commandName);
            Integer key = null;
            key = commandName.isIndexedB() ? new Integer(command.getArgu0()) : new Integer(command.getArgu1());
            cmds.put(key, command);
            return;
        }
        Map<CommandName, Command> typeMap = this.getTypeMap(commandName);
        typeMap.put(commandName, command);
    }

    public Map<CommandVariableType, Map<CommandName, Command>> getDeviceParameters() {
        return this.deviceParameters;
    }

    public Map<CommandName, Command> getTypeMap(CommandName commandName) {
        return this.getTypeMap(commandName.getType());
    }

    public Map<Integer, Command> getTypeMapIndexed(CommandName commandName) {
        Map<Integer, Command> indexMap = this.indexedDeviceParameters.get(commandName);
        if (indexMap == null) {
            indexMap = new HashMap<Integer, Command>(16);
            if (!commandName.isIndexedA()) {
                return indexMap;
            }
            this.indexedDeviceParameters.put(commandName, indexMap);
        }
        return indexMap;
    }

    public Map<CommandName, Command> getTypeMap(CommandVariableType commandType) {
        Map<CommandName, Command> typeList = this.deviceParameters.get(commandType);
        if (typeList == null) {
            typeList = new HashMap<CommandName, Command>(100);
            this.deviceParameters.put(commandType, typeList);
        }
        return typeList;
    }

    public Command getDeviceParameterIndexed(Command command, Integer idx) {
        return this.getDeviceParameterIndexed(command.getCommandName(), idx);
    }

    public Command getDeviceParameterIndexed(CommandName commandName, Integer idx) {
        Map<Integer, Command> indexMap = this.getTypeMapIndexed(commandName);
        return indexMap.get(idx);
    }

    public Command getDeviceParameter(Command command) {
        return this.getDeviceParameter(command.getCommandName());
    }

    public Command getDeviceParameter(CommandName commandName) {
        Map<CommandName, Command> typeMap = this.getTypeMap(commandName);
        return typeMap.get(commandName);
    }
}

