/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.wire.CommandName;

public class JCommandSettingListDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1129423377219936985L;
    private PulseFireUISettingKeys setting = null;
    private List<CommandName> selectCommands = null;
    private List<CommandName> selectedCommands = null;
    private JButton resetButton = null;
    private JButton saveButton = null;
    private JButton cancelButton = null;
    private JList selectList = null;
    private JList selectedList = null;
    private DefaultListModel selectListModel = null;
    private DefaultListModel selectedListModel = null;
    private JButton moveLeft = null;
    private JButton moveRight = null;
    private JButton moveUp = null;
    private JButton moveDown = null;

    public JCommandSettingListDialog(Frame parentFrame, String title, String text, PulseFireUISettingKeys setting, List<CommandName> commands, List<CommandName> defaultSelected) {
        super(parentFrame, true);
        this.setting = setting;
        this.selectCommands = commands;
        this.selectListModel = new DefaultListModel();
        this.selectedListModel = new DefaultListModel();
        String settingValue = PulseFireUI.getInstance().getSettingsManager().getSettingString(setting);
        this.selectedCommands = CommandName.decodeCommandList((String)settingValue);
        if (this.selectedCommands.isEmpty()) {
            this.selectedCommands.addAll(defaultSelected);
        }
        this.setTitle(title);
        this.setMinimumSize(new Dimension(500, 600));
        this.setPreferredSize(new Dimension(550, 600));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JCommandSettingListDialog.this.clearAndHide();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.createTopPanel(text), "North");
        mainPanel.add((Component)this.createLeftPanel(), "West");
        mainPanel.add((Component)this.createCenterPanel(), "Center");
        mainPanel.add((Component)this.createRightPanel(), "East");
        mainPanel.add((Component)this.createPanelBottom(), "South");
        this.getContentPane().add(mainPanel);
        this.initListModels();
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    private JPanel createTopPanel(String text) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(text));
        return panel;
    }

    private JPanel createLeftPanel() {
        JPanel panel = JComponentFactory.createJFirePanel("Select");
        this.selectList = new JList(this.selectListModel);
        this.selectList.setSelectionMode(2);
        this.selectList.addKeyListener(this);
        JScrollPane listScroller = new JScrollPane(this.selectList);
        listScroller.setPreferredSize(new Dimension(200, 450));
        panel.add(listScroller);
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        this.moveLeft = new JButton("<");
        this.moveLeft.addActionListener(this);
        buttonPanel.add((Component)this.moveLeft, "West");
        this.moveRight = new JButton(">");
        this.moveRight.addActionListener(this);
        buttonPanel.add((Component)this.moveRight, "East");
        this.moveUp = new JButton("Up");
        this.moveUp.addActionListener(this);
        buttonPanel.add((Component)this.moveUp, "North");
        this.moveDown = new JButton("Down");
        this.moveDown.addActionListener(this);
        buttonPanel.add((Component)this.moveDown, "South");
        JLabel fillLabel = new JLabel();
        fillLabel.setSize(200, 200);
        panel.add(fillLabel);
        panel.add(JComponentFactory.createJPanelJWrap(buttonPanel));
        return panel;
    }

    private JPanel createRightPanel() {
        JPanel panel = JComponentFactory.createJFirePanel("Selected");
        this.selectedListModel = new DefaultListModel();
        this.selectedList = new JList(this.selectedListModel);
        this.selectedList.setSelectionMode(2);
        this.selectedList.addKeyListener(this);
        JScrollPane listScroller = new JScrollPane(this.selectedList);
        listScroller.setPreferredSize(new Dimension(200, 450));
        panel.add(listScroller);
        return panel;
    }

    private JPanel createPanelBottom() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setLayout(new FlowLayout(2));
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        panel.add(this.resetButton);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        panel.add(this.saveButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
        return panel;
    }

    public void clearAndHide() {
        this.setVisible(false);
    }

    private void initListModels() {
        this.selectedListModel.removeAllElements();
        this.selectListModel.removeAllElements();
        for (CommandName cn : this.selectCommands) {
            if (this.selectedCommands.contains(cn)) continue;
            this.selectListModel.addElement(cn);
        }
        for (CommandName cn : this.selectedCommands) {
            this.selectedListModel.addElement(cn);
        }
        this.orderSelectListModel();
    }

    private void orderSelectListModel() {
        DefaultListModel listModel = this.selectListModel;
        ArrayList<CommandName> orderList = new ArrayList<CommandName>(listModel.size());
        for (int i = 0; i < listModel.size(); ++i) {
            Object o = listModel.get(i);
            orderList.add((CommandName)o);
        }
        listModel.removeAllElements();
        Collections.sort(orderList, new Comparator<CommandName>(){

            @Override
            public int compare(CommandName o1, CommandName o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (CommandName cn : orderList) {
            listModel.addElement(cn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            ArrayList<CommandName> saveList = new ArrayList<CommandName>(this.selectedListModel.size());
            for (int i = 0; i < this.selectedListModel.size(); ++i) {
                Object o = this.selectedListModel.get(i);
                saveList.add((CommandName)o);
            }
            String value = CommandName.encodeCommandList(saveList);
            PulseFireUI.getInstance().getSettingsManager().setSettingString(this.setting, value);
            this.clearAndHide();
            return;
        }
        if (e.getSource() == this.cancelButton) {
            this.clearAndHide();
            return;
        }
        if (e.getSource() == this.resetButton) {
            this.initListModels();
            return;
        }
        if (e.getSource() == this.moveLeft) {
            for (Object o : this.selectedList.getSelectedValues()) {
                this.selectedListModel.removeElement(o);
                this.selectListModel.addElement(o);
            }
            this.orderSelectListModel();
            return;
        }
        if (e.getSource() == this.moveRight) {
            for (Object o : this.selectList.getSelectedValues()) {
                if (this.selectedListModel.contains(o)) continue;
                this.selectedListModel.addElement(o);
                this.selectListModel.removeElement(o);
            }
            return;
        }
        if (e.getSource() == this.moveUp) {
            if (this.selectedList.getSelectedIndex() >= 0 && this.selectedList.getSelectedIndex() - 1 >= 0) {
                Object move = this.selectedListModel.get(this.selectedList.getSelectedIndex() - 1);
                this.selectedListModel.set(this.selectedList.getSelectedIndex() - 1, this.selectedList.getSelectedValue());
                this.selectedListModel.set(this.selectedList.getSelectedIndex(), move);
                this.selectedList.setSelectedIndex(this.selectedList.getSelectedIndex() - 1);
            }
        } else if (e.getSource() == this.moveDown && this.selectedList.getSelectedIndex() >= 0 && this.selectedList.getSelectedIndex() + 1 < this.selectedListModel.size()) {
            Object move = this.selectedListModel.get(this.selectedList.getSelectedIndex() + 1);
            this.selectedListModel.set(this.selectedList.getSelectedIndex() + 1, this.selectedList.getSelectedValue());
            this.selectedListModel.set(this.selectedList.getSelectedIndex(), move);
            this.selectedList.setSelectedIndex(this.selectedList.getSelectedIndex() + 1);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.selectList.hasFocus()) {
                for (Object o : this.selectList.getSelectedValues()) {
                    this.selectedListModel.addElement(o);
                    this.selectListModel.removeElement(o);
                }
            }
            if (this.selectedList.hasFocus()) {
                for (Object o : this.selectedList.getSelectedValues()) {
                    this.selectedListModel.removeElement(o);
                    this.selectListModel.addElement(o);
                }
                this.orderSelectListModel();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

