/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceWireManager;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JCommandComboBox
extends JComboBox
implements ActionListener,
DeviceCommandListener,
DeviceConnectListener {
    private static final long serialVersionUID = -8483163326183468077L;
    private DeviceWireManager deviceManager = PulseFireUI.getInstance().getDeviceManager();
    private Command command = null;
    private volatile boolean noEvent = false;

    public JCommandComboBox(CommandName commandName) {
        this(commandName, commandName.getListValues());
    }

    public JCommandComboBox(CommandName commandName, String[] values) {
        super(values);
        this.command = new Command(commandName);
        this.addActionListener(this);
        JComponentEnableStateListener.attach(this, commandName);
        this.deviceManager.addDeviceCommandListener(this.command.getCommandName(), (DeviceCommandListener)this);
        this.setToolTipText(commandName.name());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String enumName = (String)this.getSelectedItem();
        for (int i = 0; i < this.command.getCommandName().getListValues().length; ++i) {
            String sel = this.command.getCommandName().getListValues()[i];
            if (!sel.equals(enumName)) continue;
            if (this.command.getCommandName().isMagicTopListValue() && this.getSelectedIndex() == this.command.getCommandName().getListValues().length - 1) {
                this.command.setArgu0(new Integer(255).toString());
            } else {
                this.command.setArgu0(new Integer(i).toString());
            }
            if (!this.noEvent) {
                this.deviceManager.requestCommand(this.command);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandReceived(Command command) {
        Integer idx;
        if (this.getItemCount() == 1) {
            try {
                this.noEvent = true;
                this.removeAllItems();
                for (String i : command.getCommandName().getListValues()) {
                    this.addItem(i);
                }
            }
            finally {
                this.noEvent = false;
            }
        }
        if ((idx = Integer.valueOf(Integer.parseInt(command.getArgu0()))) == 255) {
            idx = this.getItemCount() - 1;
        }
        if (!idx.equals(this.getSelectedIndex())) {
            if (idx >= this.getItemCount()) {
                throw new IllegalStateException("Idx: " + idx + " is larger then: " + this.getItemCount() + " of " + command.getCommandName().name());
            }
            try {
                this.noEvent = true;
                this.setSelectedIndex(idx);
            }
            finally {
                this.noEvent = false;
            }
        }
    }

    public void deviceConnect() {
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnect() {
        try {
            this.noEvent = true;
            this.removeAllItems();
            this.addItem("    ");
        }
        finally {
            this.noEvent = false;
        }
    }
}

