<?php
/*
 $Id: index.php 86 2009-05-02 19:02:20Z lxp $

 This file is part of OpenClone.

 Copyright (C) 2009  David Gnedt, Manuel Steiner

 OpenClone is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenClone is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
*/

session_start();

require_once('Doctrine/lib/Doctrine.php');
include('functions/session_func.php');
include('config.php');

spl_autoload_register(array('Doctrine', 'autoload'));
$conn = Doctrine_Manager::connection(DB_URL);
Doctrine_Manager::getInstance()->setAttribute('model_loading', 'conservative');
Doctrine_Manager::getInstance()->setAttribute(Doctrine::ATTR_QUOTE_IDENTIFIER, true);
Doctrine::loadModels('db');

if (isset($_GET["site"]) && in_array("sites/".$_GET["site"].".php", glob("sites/*.php"))) {
	$site = $_GET["site"];
} else {
	$site = "overview";
}
if (isset($_GET["menu"]) && in_array("menu/".$_GET["menu"].".php", glob("menu/*.php"))) {
	$menu = $_GET["menu"];
} else {
	$menu = "nothing";
}


if(isset($_POST['login'])) {
    $userid=check_user($_POST['username'], $_POST['userpass']);
    if ($userid!=false)
        try
        {
            login($userid);
        }
        catch(Exception $loginException)
        {
            echo 'Error: Unable to login!<br/>';
            echo 'System Error: '.$loginException->getMessage().'<br/><br/>';
        }
}

else if(isset($_GET['operation'])) {
    if($_GET['operation'] == 'logout') {
        $conn->beginTransaction();
        try
        {
            logout();
            $conn->commit();
        }
        catch(Exception $logoutException)
        {
            $conn->rollback();
            echo 'Error: Unable to logout!<br/>';
            echo 'System Error: '.$logoutException->getMessage().'<br/><br/>';
        }
    }
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="de">
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<?php
if($site == 'status') {
echo '<meta http-equiv="refresh" content="10" />';
}
?>
<title>OpenClone Webinterface</title>
<link rel="stylesheet" type="text/css" href="screen.css" />
<!--[if lte IE 6]>
 <link rel="stylesheet" type="text/css" href="screen_ie.css" />
<![endif]-->
</head>
<body>
<div id="bgtop"></div>
<div id="logo"><img src="img/logo.png" width="154" height="30" alt="OpenClone" /></div>
<ul id="menutop">
<?php
if(isset($_SESSION['authenticated']) && $_SESSION['authenticated'] == true) {
    echo '<li><div class="menutop_left"></div><a href="?site=overview">System Overview</a></li>';
    echo '<li><div class="menutop_middle"></div><a href="?menu=create&amp;site=create1">Image Creation Wizard</a></li>';
    echo '<li><div class="menutop_middle"></div><a href="?menu=deploy&amp;site=deploy1">Depolyment Wizard</a></li>';
    echo '<li><div class="menutop_middle"></div><a href="?menu=advanced&amp;site=advanced">Advanced</a></li>';
	echo '<li><div class="menutop_middle"></div><a href="?operation=logout">Logout</a><div class="menutop_right"></div></li>';
}
else {
    echo '<li><div class="menutop_left"></div><a href="">Login</a><div class="menutop_right"></div></li>';
}
?>
</ul>
<div id="content">
<div id="content_top"><div id="content_topleft"></div><div id="content_topmiddle"></div><div id="content_topright"></div></div>
<div id="content_middle">
<ul id="content_menu">
<?php
if(isset($_SESSION['authenticated']) && $_SESSION['authenticated'] == true) {
    if (file_exists("menu/".$menu.".php")) {
        include("menu/".$menu.".php");
    }
    echo '</ul>';
    echo '<div id="content_inside">';

    if (file_exists("sites/".$site.".php")) {
	    include("sites/".$site.".php");
    } else {
        echo "Work in progress...<br /><br /><br /><br /><br />";
    }
}

else {
    echo '</ul>';
    echo '<div id="content_inside">';

    echo '<br/>';
    echo '<form method="post" action="">';
    echo '<table align="center">';
    echo '<thead>';
	echo '<td colspan="2" align="center"><b><u>Login</u></b></td>';
	echo '</thead>';
	echo '<tbody>';
	echo '<tr>';
    echo '<td>Username: </td>';
	echo '<td><input name="username" type="text"></td>';
	echo '</tr>';
	echo '<tr>';
    echo '<td>Password: </td>';
	echo '<td><input name="userpass" type="password"></td>';
	echo '</tr>';
	echo '<tr>';
    echo '<td colspan="2" align="center"><input name="login" type="submit" value="Login"></td>';
	echo '</tr>';
	echo '</tdbody>';
	echo '</table>';
    echo '</form>'; 
}

?>
</div>
</div>
<div id="content_bottom"><div id="content_bottomleft"></div><div id="content_bottommiddle"><div id="content_bottommiddle_line"></div></div><div id="content_bottomright"></div></div>
</div>
</body>
</html>

