#
# $Id: lzo.py 86 2009-05-02 19:02:20Z lxp $
#
# This file is part of OpenClone.
#
# Copyright (C) 2009  David Gnedt
#
# OpenClone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# OpenClone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with OpenClone.  If not, see <http://www.gnu.org/licenses/>.
#

import logging
import subprocess

MODE_COMPRESS, MODE_DECOMPRESS = range(2)

logger = logging.getLogger('lzo')

class LZOCompression:
    proc = None
    status = None
    
    def __init__(self, mode, **kw):
        # TODO: Get path (configuration?)
        args = ['/usr/bin/lzop']
        
        if mode is MODE_COMPRESS:
            pass
        
        elif mode is MODE_DECOMPRESS:
            args.append('-d')
        
        else:
            raise Exception('Unknown mode "%d"' % mode)
        
        if 'level' in kw:
            args.append('-%d' % kw['level'])
        
        if 'input' not in kw:
            kw['input'] = subprocess.PIPE
        
        if 'output' not in kw:
            kw['output'] = subprocess.PIPE
        
        logger.debug('Exec: %s' % ' '.join(args))
        self.proc = subprocess.Popen(args, stdin=kw['input'], stdout=kw['output'], close_fds=True)
        
        self.status = {}
        
        # TODO: Handle stderr
    
    def getStdin(self):
        return self.proc.stdin
    
    def getStdout(self):
        return self.proc.stdout
    
    def getStatus(self):
        return self.status
    
    def wait(self):
        ret = self.proc.wait()
        if ret == 0:
            success = True
        
        else:
            success = False
        
        self.status['return'] = ret
        self.status['success'] = success
