/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <cstdio>
#include <string>
#include <vector>
#include "common.h"
#include "rectangle.h"
#include "vrhomboid.h"
#include "track.h"
#include "bitmap.h"
#include "block.h"
#include "blockmap.h"
#include "character.h"
#include "textline.h"
#include "textblock.h"
#include "textpage.h"


Textpage::Textpage( const Bitmap & page_image, const char * filename,
                    const Control & control ) throw()
  : Rectangle( 0, 0, page_image.width() - 1, page_image.height() - 1 ),
  name( filename )
  {
  // build a Textblock for every rectangle of text
  for( int i = 0; i < page_image.rectangles(); ++i )
    {
    Blockmap * bmp = new Blockmap( page_image, i, control.debug_level );
    if( !bmp->blocks() ) { delete bmp; continue; }

    if( control.debug_level >= 90 && control.debug_level <= 100 )
      {
      if( control.outfile )
        bmp->print( control.outfile, control.debug_level );
      delete bmp;
      }
    else if( control.debug_level < 90 )
      {
      bmpv.push_back( bmp );
      tbpv.push_back( new Textblock( page_image.rectangle_vector()[i], control.charset, bmp->block_matrix() ) );
      }
    }
  }


Textpage::~Textpage() throw()
  {
  for( int i = textblocks() - 1; i >= 0; --i ) delete tbpv[i];
  for( int i = blockmaps() - 1; i >= 0; --i ) delete bmpv[i];
  }

/*
const Blockmap & Textpage::blockmap( int i ) const throw()
  {
  if( i < 0 || i >= blockmaps() )
    Ocrad::internal_error( "Textpage::blockmap, index out of bounds" );
  return *(bmpv[i]);
  }


const Textblock & Textpage::textblock( int i ) const throw()
  {
  if( i < 0 || i >= textblocks() )
    Ocrad::internal_error( "Textpage::textblock, index out of bounds" );
  return *(tbpv[i]);
  }
*/

void Textpage::print( const Control & control ) const throw()
  {
  if( control.outfile )
    for( int i = 0; i < textblocks(); ++i )
      tbpv[i]->print( control );
  }


void Textpage::dprint( const Control & control, bool graph, bool recursive ) const throw()
  {
  if( control.outfile )
    for( int i = 0; i < textblocks(); ++i )
      tbpv[i]->dprint( control, graph, recursive );
  }


void Textpage::xprint( const Control & control ) const throw()
  {
  if( !control.exportfile ) return;

  std::fprintf( control.exportfile, "source file %s\n", name.c_str() );
  std::fprintf( control.exportfile, "total blocks %d\n", textblocks() );

  for( int i = 0; i < textblocks(); ++i )
    {
    const Textblock & tb = *(tbpv[i]);
    std::fprintf( control.exportfile, "block %d %d %d %d %d\n", i + 1,
                  tb.left(), tb.top(), tb.width(), tb.height() );
    tb.xprint( control );
    }
  }
